/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import iaik.security.dh.ESDHParameterSpec;
import iaik.security.dh.ESDHPrivateKeySpec;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;

public class ESDHPrivateKey
extends PrivateKeyInfo
implements DHPrivateKey {
    private static final long serialVersionUID = 2690600339057554682L;
    private transient ASN1 c;
    private BigInteger d;
    private transient ESDHParameterSpec e;

    public ESDHPrivateKey(BigInteger bigInteger, ESDHParameterSpec eSDHParameterSpec) {
        this.d = bigInteger;
        this.e = eSDHParameterSpec;
        this.a();
    }

    public ESDHPrivateKey(ESDHPrivateKeySpec eSDHPrivateKeySpec) {
        this.d = eSDHPrivateKeySpec.getX();
        this.e = new ESDHParameterSpec(eSDHPrivateKeySpec.getP(), eSDHPrivateKeySpec.getG(), eSDHPrivateKeySpec.getQ(), eSDHPrivateKeySpec.getJ(), eSDHPrivateKeySpec.getSeed(), eSDHPrivateKeySpec.getPGenCounter());
        this.a();
    }

    public ESDHPrivateKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public ESDHPrivateKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    public ESDHPrivateKey(InputStream inputStream) throws IOException, InvalidKeyException {
        super(inputStream);
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.c = new ASN1(byArray);
            this.d = (BigInteger)this.c.toASN1Object().getValue();
            ASN1Object aSN1Object = this.private_key_algorithm.getParameter();
            BigInteger bigInteger = (BigInteger)aSN1Object.getComponentAt(0).getValue();
            BigInteger bigInteger2 = (BigInteger)aSN1Object.getComponentAt(1).getValue();
            BigInteger bigInteger3 = (BigInteger)aSN1Object.getComponentAt(2).getValue();
            BigInteger bigInteger4 = null;
            byte[] byArray2 = null;
            int n2 = 0;
            for (int i2 = 0; i2 < aSN1Object.countComponents() - 3; ++i2) {
                if (aSN1Object.getComponentAt(i2 + 3) instanceof INTEGER) {
                    bigInteger4 = (BigInteger)aSN1Object.getComponentAt(i2 + 3).getValue();
                }
                if (!(aSN1Object.getComponentAt(i2 + 3) instanceof SEQUENCE)) continue;
                SEQUENCE sEQUENCE = (SEQUENCE)aSN1Object.getComponentAt(i2 + 3);
                byArray2 = (byte[])sEQUENCE.getComponentAt(0).getValue();
                n2 = ((BigInteger)sEQUENCE.getComponentAt(1).getValue()).intValue();
            }
            this.e = new ESDHParameterSpec(bigInteger, bigInteger2, bigInteger3, bigInteger4, byArray2, n2);
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No ESDH Public Key: " + exception.toString());
        }
    }

    private void a() {
        try {
            this.c = new ASN1(new INTEGER(this.d));
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.e.getP()));
            sEQUENCE.addComponent(new INTEGER(this.e.getG()));
            sEQUENCE.addComponent(new INTEGER(this.e.getQ()));
            if (this.e.getJ() != null) {
                sEQUENCE.addComponent(new INTEGER(this.e.getJ()));
            }
            if (this.e.getSeed() != null) {
                SEQUENCE sEQUENCE2 = new SEQUENCE();
                sEQUENCE2.addComponent(new BIT_STRING(this.e.getSeed()));
                sEQUENCE2.addComponent(new INTEGER(this.e.getPGenCounter()));
                sEQUENCE.addComponent(sEQUENCE2);
            }
            this.private_key_algorithm = (AlgorithmID)AlgorithmID.esdh.clone();
            this.private_key_algorithm.setParameter(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        this.createPrivateKeyInfo();
    }

    public byte[] encode() {
        return this.c.toByteArray(true);
    }

    public BigInteger getX() {
        return this.d;
    }

    public DHParameterSpec getParams() {
        return this.e;
    }

    public String getAlgorithm() {
        return "ESDH";
    }

    public int hashCode() {
        return this.d.hashCode() ^ this.e.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ESDH private key");
        stringBuffer.append(this.e == null ? ":\n" : " (" + this.e.getP().bitLength() + " bits):\n");
        stringBuffer.append("x: " + this.d.toString(16) + "\n");
        if (this.e != null) {
            stringBuffer.append("key parameters:\n" + this.e.toString() + "\n");
        }
        return stringBuffer.toString();
    }
}

