/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.asn1.ASN1;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.security.dh.DHParameters;
import iaik.security.dh.ESDHParameterSpec;
import iaik.utils.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class ESDHParameters
extends DHParameters {
    private BigInteger c = null;
    private BigInteger d = null;
    private byte[] e = null;
    private int f = 0;

    protected byte[] engineGetEncoded() throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new INTEGER(this.a));
        sEQUENCE.addComponent(new INTEGER(this.b));
        sEQUENCE.addComponent(new INTEGER(this.c));
        if (this.d != null) {
            sEQUENCE.addComponent(new INTEGER(this.d));
        }
        if (this.e != null) {
            SEQUENCE sEQUENCE2 = new SEQUENCE();
            sEQUENCE2.addComponent(new BIT_STRING(this.e));
            sEQUENCE2.addComponent(new INTEGER(this.f));
            sEQUENCE.addComponent(sEQUENCE2);
        }
        try {
            return new ASN1(sEQUENCE).toByteArray();
        }
        catch (CodingException codingException) {
            throw new IOException("Encoding error. " + codingException.toString());
        }
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        ESDHParameterSpec eSDHParameterSpec = new ESDHParameterSpec(this.a, this.b, this.c, this.d, this.e, this.f);
        if (!eSDHParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return eSDHParameterSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof ESDHParameterSpec)) {
            throw new InvalidParameterSpecException("Parameter must be ESDHParameterSpec.");
        }
        this.a = ((ESDHParameterSpec)algorithmParameterSpec).getP();
        this.b = ((ESDHParameterSpec)algorithmParameterSpec).getG();
        this.c = ((ESDHParameterSpec)algorithmParameterSpec).getQ();
        this.d = ((ESDHParameterSpec)algorithmParameterSpec).getJ();
        this.e = ((ESDHParameterSpec)algorithmParameterSpec).getSeed();
        this.f = ((ESDHParameterSpec)algorithmParameterSpec).getPGenCounter();
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1 aSN1 = new ASN1(byArray);
            this.a = (BigInteger)aSN1.getComponentAt(0).getValue();
            this.b = (BigInteger)aSN1.getComponentAt(1).getValue();
            this.c = (BigInteger)aSN1.getComponentAt(2).getValue();
            for (int i2 = 0; i2 < aSN1.countComponents() - 3; ++i2) {
                if (aSN1.getComponentAt(i2 + 3) instanceof INTEGER) {
                    this.d = (BigInteger)aSN1.getComponentAt(i2 + 3).getValue();
                }
                if (!(aSN1.getComponentAt(i2 + 3) instanceof SEQUENCE)) continue;
                SEQUENCE sEQUENCE = (SEQUENCE)aSN1.getComponentAt(i2 + 3);
                this.e = (byte[])sEQUENCE.getComponentAt(0).getValue();
                this.f = ((BigInteger)sEQUENCE.getComponentAt(1).getValue()).intValue();
            }
        }
        catch (CodingException codingException) {
            throw new IOException("Decoding error. " + codingException.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.b.hashCode() ^ this.c.hashCode();
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("p: " + this.a + "\n");
        stringBuffer.append("g: " + this.b + "\n");
        stringBuffer.append("q: " + this.c.toString());
        if (this.d != null) {
            stringBuffer.append("j: " + this.d.toString());
        }
        if (this.e != null) {
            stringBuffer.append("seed: " + Util.toString(this.e));
            stringBuffer.append("pgenCounter: " + this.f);
        }
        return stringBuffer.toString();
    }
}

