/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.math.BigInteger;
import javax.crypto.spec.DHParameterSpec;

public class ESDHParameterSpec
extends DHParameterSpec {
    private BigInteger a;
    private BigInteger b;
    private byte[] c;
    private int d;

    public ESDHParameterSpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        super(bigInteger, bigInteger2);
        this.a = bigInteger3;
    }

    public ESDHParameterSpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        super(bigInteger, bigInteger2);
        this.a = bigInteger3;
        this.b = bigInteger4;
    }

    public ESDHParameterSpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte[] byArray, int n2) {
        super(bigInteger, bigInteger2);
        this.a = bigInteger3;
        this.c = byArray != null ? (byte[])byArray.clone() : null;
        this.d = n2;
    }

    public ESDHParameterSpec(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, byte[] byArray, int n2) {
        super(bigInteger, bigInteger2);
        this.a = bigInteger3;
        this.b = bigInteger4;
        this.c = byArray != null ? (byte[])byArray.clone() : null;
        this.d = n2;
    }

    public BigInteger getQ() {
        return this.a;
    }

    public BigInteger getJ() {
        return this.b;
    }

    public byte[] getSeed() {
        return this.c != null ? (byte[])this.c.clone() : null;
    }

    public int getPGenCounter() {
        return this.d;
    }

    public int getL() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ESDHParameterSpec)) {
            return false;
        }
        ESDHParameterSpec eSDHParameterSpec = (ESDHParameterSpec)object;
        if (!this.getP().equals(eSDHParameterSpec.getP())) {
            return false;
        }
        if (!this.getG().equals(eSDHParameterSpec.getG())) {
            return false;
        }
        if (!this.a.equals(eSDHParameterSpec.a)) {
            return false;
        }
        if (this.b != null && eSDHParameterSpec.b != null ? !this.b.equals(eSDHParameterSpec.b) : this.b != null || eSDHParameterSpec.b != null) {
            return false;
        }
        if (this.c != null && eSDHParameterSpec.c != null ? !CryptoUtils.secureEqualsBlock(this.c, eSDHParameterSpec.c) : this.c != null || eSDHParameterSpec.c != null) {
            return false;
        }
        return this.d == eSDHParameterSpec.d;
    }

    public int hashCode() {
        int n2 = this.getP().hashCode() ^ this.getG().hashCode() ^ this.a.hashCode();
        if (this.b != null) {
            n2 ^= this.b.hashCode();
        }
        if (this.c != null) {
            n2 ^= Util.calculateHashCode(this.c);
        }
        return n2 ^ this.d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("p: " + this.getP().toString(16));
        stringBuffer.append("\ng: " + this.getG().toString(16));
        stringBuffer.append("\nq: " + this.a.toString(16));
        if (this.b != null) {
            stringBuffer.append("\nj: " + this.b.toString(16));
        }
        if (this.c != null) {
            stringBuffer.append("\nseed: " + Util.toString(this.c));
            stringBuffer.append("\npgenCounter: " + this.d);
        }
        return stringBuffer.toString();
    }
}

