/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.security.dh.DHParameterGenerator;
import iaik.security.dh.ESDHParameterGenerator;
import iaik.security.dh.ESDHParameterSpec;
import iaik.security.dh.ESDHPrivateKey;
import iaik.security.dh.ESDHPublicKey;
import iaik.security.random.SecRandom;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;

public class ESDHKeyPairGenerator
extends KeyPairGenerator {
    private static final byte[] a = new byte[]{126, 19, 102, -15, -94, -46, 109, -107, -39, -27, -116, 104, -127, 117, -11, -86, 102, -38, -9, 42, 61, -40, 20, 89, 99, -16, 46, -39, -69, -110, 87, -122, -113, -73, -39, -124, -63, 86, 122, 72, 43, -119, 84, 87, -88, 38, -111, 19, 36, 78, -56, -101, 9, -126, 71, -61, 38, 118, 109, -3, 8, -126, -50, 65};
    private static final byte[] b = new byte[]{-67, 46, 57, -115, 64, -123, -71, -120, 116, 123, -101, -7, 22, 89, -121, 106, 42, -72, -19, -48, -114, 97, 29, 112, -88, -19, -46, 72, -115, 7, -35, 7, 63, 105, 10, 9, -31, -13, -61, -95, -5, -33, -83, -49, -97, 67, -118, 103, -6, 78, 4, -112, 13, -4, 75, 1, -50, -66, 115, 66, -24, 4, 61, -21};
    private static final byte[] c = new byte[]{13, -114, -61, 92, -65, -63, 114, -32, -128, 39, -76, 45, -110, 32, -1, 78, -107, -54, 47, 75, -19, -22, -28, 31, 85, 18, 62, 41, 99, 0, 79, 83, -19, -27, -88, 24, -41, -17};
    private static final byte[] d = new byte[]{13, -12, 42, 41, -45, 108, -69, -48, -119, 35, 53, -79, 8, 27, -93, 88, 111, 81, -104, -76, 50, 99, -125, -121, 70, -26, -74};
    private static final byte[] e = new byte[]{-21, 116, -32, -62, 69, -107, 100, -67, 17, 59, -38, -81, -92, -89, 54, -16, -110, 62, 23, 78, -116, -99, -26, 118, -71, 109, -114, -127, 12, 25, 68, -60, 17, -126, 20, -111, -24, 31};
    private static int f = 348;
    private static final byte[] g = new byte[]{-119, -61, -126, -41, 13, 34, 26, 27, 42, 102, 81, 41, -74, 53, 11, -23, 99, 91, -10, -65, 22, 106, -26, -35, -102, 46, -37, -7, 9, 6, -6, 68, -19, -60, 120, -106, 85, -41, 98, -34, -38, 94, -61, 101, -128, -3, -59, -36, -74, 6, -21, -86, -124, 22, 20, -111, -87, -59, 82, 45, 46, 95, -7, -72, -48, 110, -71, 93, 114, 32, 2, -9, -86, 22, 12, 98, -87, -102, -18, 3, 107, -34, 103, -46, 69, -119, -35, 110, -115, 17, -29, -88, 90, 83, 107, 83};
    private static final byte[] h = new byte[]{-24, -70, 122, -95, -76, 114, 87, 26, -66, -77, -63, 104, 110, -70, 84, 75, -43, 70, -118, -40, 41, 96, 107, 13, -117, -86, 24, 1, 113, 25, 46, -8, 111, 18, 68, -12, -5, 83, -2, -23, 19, -90, -39, -81, -125, 94, -119, -91, 28, -116, 39, 59, 55, 50, -124, 110, -112, 10, -89, -69, -116, 71, 47, -76, -111, -80, 101, -58, -25, 54, 46, 36, -71, 8, 20, -41, 22, 9, -18, -84, 102, -11, 20, -82, 73, 63, 5, -71, 102, -114, -51, -44, 15, 123, 79, -69};
    private static final byte[] i = new byte[]{14, -102, -25, 93, -42, 68, 39, -17, -27, 34, -88, 46, 115, -62, -28, 62, 3, 60, 83, -32, -69, -50, -98, -54, -115, -8, 88, 55, -58, -117, 17, 49, -42, 76, -97, -25, -93, 49};
    private static final byte[] j = new byte[]{15, -17, 75, 118, 76, 110, 71, -50, -55, 104, 3, 12, -104, 56, 71, 23, -40, 29, -55, 91, -46, 126, 61, 29, 93, 53, -39, 81, 89, 72, -36, -75, 30, 24, -47, -61, -110, -57, 14, 112, 72, -94, -20, -52, -53, 46, 2, -55, -127, 59, -7, -112, 82, 90, -115, 126, -39, -40, -38};
    private static final byte[] k = new byte[]{105, -87, 107, -56, 85, 40, -53, 100, 5, -105, -125, 78, 57, -87, 55, 72, 71, -80, -43, 98, 95, 50, 73, 29, 24, 121, 107, -69, -23, -120, 94, 108, -106, -110, -92, 11, 32, 2};
    private static int l = 409;
    private static final byte[] m = new byte[]{124, -108, 123, 56, -47, 64, 17, -18, -58, -106, -40, 14, -115, 114, 44, -76, 58, 108, -82, 53, 109, 32, 106, 58, -29, 67, 45, 98, 55, -28, -125, -43, -93, 127, -108, -125, 103, 86, 108, 28, -38, -82, -80, -9, -100, -120, 111, 38, -59, 10, 116, 69, 107, 64, -52, 59, 97, 90, 90, -120, 59, 44, -124, 31, 71, 27, 5, -25, 115, 66, 49, -108, -2, 77, 59, 118, -76, 58, 5, 88, -97, -117, 60, -15, 77, -33, -110, -114, 17, 34, -107, 28, -32, 121, 109, 37, -81, -67, 94, -106, 75, -86, -43, -45, -64, -85, 33, -45, 97, -90, -39, 33, 62, 115, -120, 9, 8, -11, 82, -68, -88, -115, 29, -36, -9, 35, -72, 90};
    private static final byte[] n = new byte[]{-27, -21, -122, 101, 122, -77, 95, 11, -58, 29, -16, -114, -2, -5, -12, -15, -126, 77, 94, -21, -74, 72, 59, 78, -96, 67, -48, 31, -34, -53, -114, -4, -121, -83, 82, 16, -126, 79, 84, 30, -107, -51, 33, 54, -65, -51, 84, 105, -3, -126, -9, 116, 117, -124, -96, 20, 113, 100, -105, -102, 4, 103, -53, 48, 10, -73, -51, 6, 127, 121, 9, -117, -111, -36, -111, -42, -104, 29, -41, 23, -13, -58, -45, 7, 73, -70, 82, 60, 116, -127, -125, 29, -116, -26, 51, -29, 8, 59, -92, 39, -102, -30, -27, 17, 46, 66, 38, -49, -97, 19, -19, -100, -17, -78, -79, 3, 38, -100, 32, -40, -79, 77, 108, 28, -40, -46, -51, -13};
    private static final byte[] o = new byte[]{10, 70, -69, -105, -95, 52, 74, 90, -86, -41, 34, 86, 86, 10, -100, 121, -95, -73, 30, -77, -61, 60, 102, 102, -100, -17, 27, -125, 11, -69, -85, 100, -41, 36, 63, -90, 119, -105};
    private static final byte[] p = new byte[]{22, 95, -78, 64, 5, -15, 8, 55, -114, -118, 30, 113, 57, 36, 104, 14, 1, 31, 114, -125, -21, 4, -11, -7, -109, 104, 100, 71, 77, 76, -87, -75, 17, 58, 102, 98, -32, 85, 123, 75, -67, -68, -87, 124, -8, -65, -111, -15, -45, -31, 127, 109, 30, -82, -3, 113, -61, 74, -6, -29, -85, 49, 123, -125, 58, -77, 43, -79, -115, -85, -84, 79, 69, 58, -92, 101, -18, 103, -41, -72, 88, 49, -87, -13, -102, 72, -53, -86, -36, -49, -34};
    private static final byte[] q = new byte[]{-7, -127, -28, -33, 83, -55, -24, -45, -54, -49, -123, 125, -30, -83, 97, 82, 119, 25, -17, -89, -79, 119, 112, 90, 19, -126, -107, -33, -84, -108, 106, 46, 28, 83, 61, 8, -16, 15};
    private static int r = 42;
    private static final byte[] s = new byte[]{-123, -75, 87, 86, -77, 98, 126, -69, 26, -9, 74, 98, -13, -54, 85, -36, -49, 108, -95, 41, 113, 8, 113, 65, 111, -4, 34, 113, -15, -27, 38, -1, 78, 26, 122, 56, 96, -123, -91, 103, 43, 104, -63, 81, -82, 92, 80, -87, -16, 60, -37, -38, 88, -117, 37, -94, -86, 99, 115, 57, -44, -38, -121, 64, -102, -84, -8, -59, 51, -56, -68, 89, 35, -52, -91, 100, 71, -18, 122, -89, 17, 108, -26, 117, -3, 76, 10, 67, -29, -44, 120, -59, -74, -85, -8, 17, -7, 9, 16, 88, 117, 96, -76, 40, 35, 34, 73, -86, 35, -122, -47, 83, 72, -81, 5, -77, -66, 32, -36, -12, 39, -90, 69, 32, -52, -104, -105, 17, 76, 24, -37, -99, -77, 11, 100, 90, -77, -123, -94, 100, -120, 4, -26, 126, 122, -70, -32, 122, -98, -91, -99, -123, 126, 14, -126, -47, 4, -86, -64, -82, -57, -40, 112, 87, 100, 50, 96, -110, 87, -106, 54, -94, 39, 120, 31, -109, -19, 126, 48, 71, 96, -65, -66, -94, 101, 35, -124, -113, -106, -78, -101, -86, 7, 109, -3, 73, -103, -13, -85, -112, 75, -17, -33, 99, -75, -71, 51, -34, -96, -2, 114, -95, -46, -67, -120, 51, 22, -112, 32, -105, -88, -108, -54, 10, -69, -4, 82, 25, 6, 65, -35, -70, -80, 78, -123, 122, -26, -5, -86, 69, -13, -24, -45, -101, 77, 84, 64, 108, -121, -101, -38, 104, 54, -69, -115, -19};
    private static final byte[] t = new byte[]{-74, 94, 41, -30, -68, 12, 71, -86, -72, 84, -79, -117, 18, 49, 66, -86, 10, -54, -50, -116, 53, 95, -121, 56, 97, 1, -95, -24, 66, -91, 90, 23, 5, -82, -40, -117, -127, 34, -90, -24, 44, 25, -44, -113, 49, -65, 111, 36, -9, 100, -12, -97, -98, -97, -3, -36, 45, 24, -75, -95, -27, 102, 115, -53, -79, 112, 78, 121, -19, -27, 91, -100, -18, 18, 32, 122, -42, 66, 24, -38, 42, 114, 39, 94, -86, -121, 23, 102, 107, -41, 52, -74, -16, 89, 66, -63, 27, -66, -87, 108, -51, 97, -114, 21, -96, -92, -7, 93, 125, 42, 126, 10, 59, 9, 21, 99, 78, -114, 61, 86, 68, 66, 69, -18, -33, 78, 58, 27, -116, 93, -82, 122, 104, 60, -57, -1, 50, 125, 109, 106, -68, 47, 42, 60, -29, 98, 118, -68, 8, 47, -46, 100, -79, -70, 80, -61, -23, -12, 59, 120, -94, 55, -40, -55, -10, 22, 73, -39, -28, 88, -52, -95, 37, -70, 24, 63, -39, 21, -3, 35, 74, 22, 99, -21, -117, -34, 100, 44, 107, -62, 87, -126, 83, -2, 21, 32, 28, 87, 19, 86, 27, 49, -77, 42, -35, 9, 118, 29, -77, -67, 78, -33, -118, -45, -48, -101, -64, -114, -122, 85, 125, 49, 73, -112, -119, -47, 83, 83, -11, -39, 56, -37, -84, -78, 59, 42, -17, 124, -71, -55, -51, 63, 48, 41, 17, -55, -69, 68, 78, 87, -97, -128, 74, -25, -93, -39};
    private static final byte[] u = new byte[]{13, -15, -3, -92, -83, 42, -36, -79, 37, 116, 36, 59, -29, -2, -78, -95, 32, -66, -78, -123, 72, -39, 87, 98, 19, 35, 118, -35, 62, 124, -14, -97, 49, -19, 100, 17, 99, -85};
    private static final byte[] v = new byte[]{13, 19, -49, -36, -61, -63, -42, -20, 59, 5, 120, 29, 44, -114, 97, -13, 103, 0, -76, 103, 29, 114, -41, -55, -99, 79, -126, 73, -89, -105, -6, -85, -1, 85, -108, -43, 120, 65, -2, 12, 122, 33, 101, 91, 62, -52, -119, 120, 37, 46, -109, -82, -59, 56, -109, -34, 77, 115, 53, 91, -16, -15, 87, 92, 100, 40, 55, 104, 99, -92, -76, -118, -123, -116, -71, -29, 40, 56, 27, -94, -6, 75, -6, -55, -9, 34, -55, -26, -15, -19, -29, -107, 78, -28, 1, -43, -57, 84, -10, 102, 89, -120, -104, -97, 88, 37, -114, -33, -2, 74, -55, 75, -88, -1, -35, -89, -49, -73, -79, -123, -67, -17, -90, -40, -79, 8, -31, -52, -33, -98, 37, -48, -34, 7, 2, -11, -96, 95, 5, -33, -93, -125, 2, -86, 67, 51, -71, -73, -54, -97, -24, 74, 47, -106, 62, 46, -28, 27, -77, -9, -78, -41, 12, -67, 91, -69, -40, 97, 35, 91, 3, -91, -113, 94, -36, 114, 127, 9, 41, -45, -93, -90, 24, -103, 38, 11, -104, 110, -96, -26, -56, 75, -23, -104, 77, 65, 14, 36, -91, -30, -24, -53, 46, 24, 46, 85, 88, 46, -77, -124, 120, 22, -49, 108, 114, -64, -49, 19, -120};
    private static final byte[] w = new byte[]{21, 20, 38, 54, -21, -117, -40, -46, 23, 122, 20, -60, -58, 125, -1, 33, -44, -83, 82, 111, -104, 97, -12, -91, -58, 114, -19, -67, 77, -127, -78, -50, -51, 38, -51, -11, -43, -74};
    private static int x = 227;
    private SecureRandom y;
    private int z = -1;
    private int A = -1;
    private BigInteger B = null;
    private BigInteger C = null;
    private BigInteger D = null;
    private BigInteger E = null;
    private byte[] F = null;
    private int G = 0;

    public ESDHKeyPairGenerator() {
        super("ESDH");
    }

    public void initialize(int n2) {
        this.initialize(n2, null);
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        this.y = secureRandom;
        this.z = n2;
        switch (this.z) {
            case 512: {
                this.B = new BigInteger(1, b);
                this.C = new BigInteger(1, a);
                this.D = new BigInteger(1, c);
                this.E = new BigInteger(1, d);
                this.F = e;
                this.G = f;
                break;
            }
            case 768: {
                this.B = new BigInteger(1, h);
                this.C = new BigInteger(1, g);
                this.D = new BigInteger(1, i);
                this.E = new BigInteger(1, j);
                this.F = k;
                this.G = l;
                break;
            }
            case 1024: {
                this.B = new BigInteger(1, n);
                this.C = new BigInteger(1, m);
                this.D = new BigInteger(1, o);
                this.E = new BigInteger(1, p);
                this.F = q;
                this.G = r;
                break;
            }
            case 2048: {
                this.B = new BigInteger(1, t);
                this.C = new BigInteger(1, s);
                this.D = new BigInteger(1, u);
                this.E = new BigInteger(1, v);
                this.F = w;
                this.G = x;
                break;
            }
            default: {
                this.B = null;
                this.C = null;
            }
        }
        this.A = -1;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.y = secureRandom;
        if (algorithmParameterSpec instanceof ESDHParameterSpec) {
            this.B = ((ESDHParameterSpec)algorithmParameterSpec).getP();
            this.C = ((ESDHParameterSpec)algorithmParameterSpec).getG();
            this.D = ((ESDHParameterSpec)algorithmParameterSpec).getQ();
            this.E = ((ESDHParameterSpec)algorithmParameterSpec).getJ();
            this.F = ((ESDHParameterSpec)algorithmParameterSpec).getSeed();
            this.G = ((ESDHParameterSpec)algorithmParameterSpec).getPGenCounter();
            this.z = this.B.bitLength();
            this.A = this.D.bitLength();
            if (this.A > this.z) {
                throw new InvalidAlgorithmParameterException("The size of the exponent must be less than the size of the modulus");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Parameter must be a ESDHParameterSpec.");
        }
    }

    public KeyPair generateKeyPair() {
        BigInteger bigInteger;
        Object object;
        Object object2;
        if (this.y == null) {
            this.y = SecRandom.getDefault();
        }
        if (this.z < 0) {
            this.z = 2048;
            this.initialize(this.z, this.y);
        }
        if (this.A <= 0) {
            this.A = DHParameterGenerator.a(this.z);
        }
        ESDHParameterSpec eSDHParameterSpec = new ESDHParameterSpec(this.B, this.C, this.D, this.E, this.F, this.G);
        if (this.B == null || this.C == null || this.D == null) {
            try {
                object2 = new DHGenParameterSpec(this.z, this.A);
                object = new ESDHParameterGenerator();
                ((DHParameterGenerator)object).engineInit((AlgorithmParameterSpec)object2, this.y);
                AlgorithmParameters algorithmParameters = ((DHParameterGenerator)object).engineGenerateParameters();
                eSDHParameterSpec = (ESDHParameterSpec)algorithmParameters.getParameterSpec(eSDHParameterSpec.getClass());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeException(invalidAlgorithmParameterException.toString());
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new RuntimeException(invalidParameterSpecException.toString());
            }
        }
        while ((bigInteger = new BigInteger(this.A, this.y)).bitLength() != this.A) {
        }
        object2 = new ESDHPrivateKey(bigInteger, eSDHParameterSpec);
        BigInteger bigInteger2 = eSDHParameterSpec.getG().modPow(bigInteger, eSDHParameterSpec.getP());
        object = new ESDHPublicKey(bigInteger2, eSDHParameterSpec);
        return new KeyPair((PublicKey)object, (PrivateKey)object2);
    }
}

