/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.security.dh.ESDHParameterSpec;
import iaik.security.dh.ESDHPrivateKey;
import iaik.security.dh.ESDHPrivateKeySpec;
import iaik.security.dh.ESDHPublicKey;
import iaik.security.dh.ESDHPublicKeySpec;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class ESDHKeyFactory
extends KeyFactorySpi {
    static Class a;
    static Class b;
    static Class c;
    static Class d;

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof ESDHPrivateKeySpec) {
                return new ESDHPrivateKey((ESDHPrivateKeySpec)keySpec);
            }
            if (keySpec instanceof PKCS8EncodedKeySpec) {
                return new ESDHPrivateKey(((PKCS8EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Only ESDH key specs allowed.");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Invalid KeySpec: " + invalidKeyException.toString());
        }
    }

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        try {
            if (keySpec instanceof ESDHPublicKeySpec) {
                return new ESDHPublicKey((ESDHPublicKeySpec)keySpec);
            }
            if (keySpec instanceof X509EncodedKeySpec) {
                return new ESDHPublicKey(((X509EncodedKeySpec)keySpec).getEncoded());
            }
            throw new InvalidKeySpecException("Only ESDH key specs allowed.");
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidKeySpecException("Invalid KeySpec: " + invalidKeyException.toString());
        }
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (key instanceof ESDHPublicKey) {
            if ((a == null ? (a = ESDHKeyFactory.class$("iaik.security.dh.ESDHPublicKeySpec")) : a).isAssignableFrom(clazz)) {
                ESDHPublicKey eSDHPublicKey = (ESDHPublicKey)key;
                ESDHParameterSpec eSDHParameterSpec = (ESDHParameterSpec)eSDHPublicKey.getParams();
                return new ESDHPublicKeySpec(eSDHPublicKey.getY(), eSDHParameterSpec.getP(), eSDHParameterSpec.getG(), eSDHParameterSpec.getQ(), eSDHParameterSpec.getJ(), eSDHParameterSpec.getSeed(), eSDHParameterSpec.getPGenCounter());
            }
            if ((b == null ? (b = ESDHKeyFactory.class$("java.security.spec.X509EncodedKeySpec")) : b).isAssignableFrom(clazz)) {
                return new X509EncodedKeySpec(key.getEncoded());
            }
            throw new InvalidKeySpecException("Can't convert key to KeySpec.");
        }
        if (key instanceof ESDHPrivateKey) {
            ESDHPrivateKey eSDHPrivateKey = (ESDHPrivateKey)key;
            if ((c == null ? (c = ESDHKeyFactory.class$("iaik.security.dh.ESDHPrivateKeySpec")) : c).isAssignableFrom(clazz)) {
                ESDHParameterSpec eSDHParameterSpec = (ESDHParameterSpec)eSDHPrivateKey.getParams();
                return new ESDHPrivateKeySpec(eSDHPrivateKey.getX(), eSDHParameterSpec.getP(), eSDHParameterSpec.getG(), eSDHParameterSpec.getQ(), eSDHParameterSpec.getJ(), eSDHParameterSpec.getSeed(), eSDHParameterSpec.getPGenCounter());
            }
            if ((d == null ? (d = ESDHKeyFactory.class$("java.security.spec.PKCS8EncodedKeySpec")) : d).isAssignableFrom(clazz)) {
                return new PKCS8EncodedKeySpec(eSDHPrivateKey.getEncoded());
            }
            throw new InvalidKeySpecException("Can't convert key to KeySpec.");
        }
        throw new InvalidKeySpecException("Can only convert ESDH keys.");
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (key instanceof ESDHPrivateKey || key instanceof ESDHPublicKey) {
            return key;
        }
        throw new InvalidKeyException("Can't convert key other than ESDHPrivateKey or ESDHPublicKey!");
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

