/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.security.cipher.DESKeyGenerator;
import iaik.security.cipher.SecretKey;
import iaik.security.dh.ESDHKEKParameterSpec;
import iaik.security.dh.ESDHKEKParameters;
import iaik.security.dh.ESDHParameterSpec;
import iaik.security.dh.ESDHPrivateKey;
import iaik.security.dh.ESDHPublicKey;
import iaik.security.md.SHA;
import iaik.utils.CriticalObject;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class ESDHKeyAgreement
extends KeyAgreementSpi {
    private ESDHKEKParameterSpec a;
    private byte[] b;
    private ESDHPrivateKey c;
    private BigInteger d;
    private BigInteger e;
    private byte[] f;

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof ESDHPrivateKey)) {
            throw new InvalidKeyException("Only ESDH private keys are allowed.");
        }
        this.c = (ESDHPrivateKey)key;
        this.d = this.c.getParams().getP();
        this.e = this.c.getParams().getG();
        if (algorithmParameterSpec != null) {
            if (algorithmParameterSpec instanceof ESDHKEKParameterSpec) {
                this.a = (ESDHKEKParameterSpec)algorithmParameterSpec;
            } else {
                throw new InvalidKeyException("Params must be ESDHKEKParameterSpec!");
            }
        }
    }

    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInit(key, null, secureRandom);
    }

    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        ESDHPublicKey eSDHPublicKey = null;
        if (key instanceof ESDHPublicKey) {
            if (this.c == null || this.d == null || this.e == null) {
                throw new IllegalStateException("Not initialized yet!");
            }
            ESDHPublicKey eSDHPublicKey2 = (ESDHPublicKey)key;
            BigInteger bigInteger = eSDHPublicKey2.getY();
            DHParameterSpec dHParameterSpec = eSDHPublicKey2.getParams();
            if (dHParameterSpec != null) {
                if (!this.d.equals(dHParameterSpec.getP()) && !this.e.equals(dHParameterSpec.getG())) {
                    throw new InvalidKeyException("ESDH parameters are not equal.");
                }
                ESDHPublicKey.validatePublicKey(eSDHPublicKey2);
            }
            BigInteger bigInteger2 = bigInteger.modPow(this.c.getX(), this.d);
            if (bl) {
                this.f = bigInteger2.toByteArray();
                if (this.f[0] == 0) {
                    byte[] byArray = new byte[this.f.length - 1];
                    System.arraycopy(this.f, 1, byArray, 0, this.f.length - 1);
                    this.f = byArray;
                }
            } else {
                eSDHPublicKey = new ESDHPublicKey(bigInteger2, (ESDHParameterSpec)this.c.getParams());
            }
        } else {
            throw new InvalidKeyException("ESDH public key needed.");
        }
        if (bl && this.a != null) {
            this.b = this.a(this.f);
        }
        return eSDHPublicKey;
    }

    protected javax.crypto.SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        javax.crypto.SecretKey secretKey;
        if (this.b == null) {
            throw new InvalidKeyException("Cannot create secret key. Please init this KeyAgreement with ESDHKEKParameterSpec!");
        }
        if (string.equals("DES")) {
            if (this.b.length < 8) {
                throw new InvalidKeyException("Generated secret to short for a DES key!");
            }
            byte[] byArray = (byte[])this.b.clone();
            DESKeyGenerator.adjustParity(byArray, 0);
            secretKey = new SecretKey(byArray, 0, 8, "DES");
        } else if (string.equals("3DES") || string.equals("DESede")) {
            if (this.b.length < 24) {
                throw new InvalidKeyException("Generated secret to short for a Triple DES key!");
            }
            byte[] byArray = (byte[])this.b.clone();
            DESKeyGenerator.adjustParity(byArray, 0);
            DESKeyGenerator.adjustParity(byArray, 8);
            DESKeyGenerator.adjustParity(byArray, 16);
            secretKey = new SecretKey(byArray, 0, 24, "DESede");
        } else {
            SecretKeySpec secretKeySpec = null;
            try {
                secretKeySpec = new SecretKeySpec(this.b, string);
                SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
                secretKey = secretKeyFactory.generateSecret(secretKeySpec);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new InvalidKeyException("Invalid key: " + invalidKeySpecException.toString());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                secretKey = secretKeySpec;
            }
        }
        return secretKey;
    }

    protected int engineGenerateSecret(byte[] byArray, int n2) throws IllegalStateException, ShortBufferException {
        if (this.f == null) {
            throw new IllegalStateException("Secret not calculated yet!");
        }
        if (byArray.length - n2 < this.f.length) {
            throw new ShortBufferException("Output buffer is to small for holding the secret.");
        }
        System.arraycopy(this.f, 0, byArray, n2, this.f.length);
        return this.f.length;
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        return this.f;
    }

    private byte[] a(byte[] byArray) throws IllegalStateException {
        if (this.a == null) {
            throw new IllegalStateException("KeyAgreement not initialized yet!");
        }
        try {
            int n2 = byArray.length;
            this.a.resetCounter();
            ESDHKEKParameters eSDHKEKParameters = new ESDHKEKParameters(this.a);
            int n3 = this.a.getSuppPubInfoAsInt() / 8;
            int n4 = (n3 + 19) / 20;
            byte[] byArray2 = new byte[n4 * 20];
            byte[] byArray3 = eSDHKEKParameters.engineGetEncoded();
            byte[] byArray4 = new byte[n2 + byArray3.length];
            SHA sHA = new SHA();
            for (int i2 = 0; i2 < n4; ++i2) {
                if (i2 > 0) {
                    eSDHKEKParameters.incrementCounter();
                    byArray3 = eSDHKEKParameters.engineGetEncoded();
                }
                System.arraycopy(byArray, 0, byArray4, 0, n2);
                System.arraycopy(byArray3, 0, byArray4, n2, byArray3.length);
                System.arraycopy(sHA.digest(byArray4), 0, byArray2, i2 * 20, 20);
            }
            CriticalObject.destroy(byArray4);
            byte[] byArray5 = new byte[n3];
            System.arraycopy(byArray2, 0, byArray5, 0, n3);
            CriticalObject.destroy(byArray2);
            return byArray5;
        }
        catch (IOException iOException) {
            throw new InternalErrorException("Error encoding OtherInfo. " + iOException.getMessage(), iOException);
        }
    }

    static {
        Util.toString(null, -1, 1);
    }
}

