/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.asn1.ObjectID;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.security.spec.AlgorithmParameterSpec;

public class ESDHKEKParameterSpec
implements Cloneable,
AlgorithmParameterSpec {
    private ObjectID a;
    private byte[] b;
    private byte[] c;
    private byte[] d;

    ESDHKEKParameterSpec() {
    }

    public ESDHKEKParameterSpec(ObjectID objectID, byte[] byArray) {
        this.a(objectID);
        this.a(byArray);
        this.resetCounter();
    }

    public ESDHKEKParameterSpec(ObjectID objectID, int n2) {
        this.a(objectID);
        this.a(n2);
        this.resetCounter();
    }

    void a(ObjectID objectID) {
        if (objectID == null) {
            throw new IllegalArgumentException("Cannot create ESDHKEKParameterSpec. Missing Cek wrap algorithm!");
        }
        this.a = objectID;
    }

    public void setCounter(byte[] byArray) {
        if (byArray != null && byArray.length != 4) {
            throw new IllegalArgumentException("Counter must be 4 bytes long!");
        }
        this.b = byArray;
    }

    public void setCounter(int n2) {
        this.b = new byte[4];
        CryptoUtils.spreadIntsToBytes(new int[]{n2}, 0, this.b, 0, 1);
    }

    public void resetCounter() {
        if (this.b == null) {
            this.b = new byte[4];
        }
        this.b[0] = 0;
        this.b[1] = 0;
        this.b[2] = 0;
        this.b[3] = 1;
    }

    public void incrementCounter() {
        int n2 = this.b.length;
        while (n2 > 0) {
            int n3 = --n2;
            this.b[n3] = (byte)(this.b[n3] + 1);
            byte by = this.b[n3];
            if (by == 0) continue;
            break;
        }
    }

    public void setPartyAInfo(byte[] byArray) {
        if (byArray != null && byArray.length != 64) {
            throw new IllegalArgumentException("PartyAInfo must be 512 bits long!");
        }
        this.c = byArray;
    }

    private void a(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Cannot create ESDHKEKParameterSpec. Missing SuppPubInfo!");
        }
        if (byArray.length != 4) {
            throw new IllegalArgumentException("SuppPubInfo must be 4 bytes long!");
        }
        this.d = byArray;
    }

    private void a(int n2) {
        byte[] byArray = new byte[4];
        CryptoUtils.spreadIntsToBytes(new int[]{n2}, 0, byArray, 0, 1);
        this.a(byArray);
    }

    public ObjectID getCekWrapAlgorithm() {
        return this.a;
    }

    public byte[] getCounter() {
        if (this.b == null) {
            return null;
        }
        return (byte[])this.b.clone();
    }

    public int getCounterAsInt() {
        int[] nArray = new int[1];
        CryptoUtils.squashBytesToInts(this.b, 0, nArray, 0, 1);
        return nArray[0];
    }

    public byte[] getPartyAInfo() {
        if (this.c == null) {
            return null;
        }
        return (byte[])this.c.clone();
    }

    public byte[] getSuppPubInfo() {
        if (this.d == null) {
            return null;
        }
        return (byte[])this.d.clone();
    }

    public int getSuppPubInfoAsInt() {
        int[] nArray = new int[1];
        CryptoUtils.squashBytesToInts(this.d, 0, nArray, 0, 1);
        return nArray[0];
    }

    public Object clone() {
        ESDHKEKParameterSpec eSDHKEKParameterSpec = null;
        try {
            eSDHKEKParameterSpec = (ESDHKEKParameterSpec)super.clone();
            if (this.a != null) {
                eSDHKEKParameterSpec.a = (ObjectID)this.a.clone();
            }
            if (this.b != null) {
                eSDHKEKParameterSpec.b = (byte[])this.b.clone();
            }
            if (this.c != null) {
                eSDHKEKParameterSpec.c = (byte[])this.c.clone();
            }
            if (this.d != null) {
                eSDHKEKParameterSpec.d = (byte[])this.d.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return eSDHKEKParameterSpec;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CEK wrap algorithm: " + this.a.toString() + "\n");
        stringBuffer.append("counter: " + Util.toString(this.b) + "\n");
        if (this.c != null) {
            stringBuffer.append("partyAInfo: " + Util.toString(this.c, 0, 10) + "...\n");
        }
        stringBuffer.append("suppPubInfo: " + Util.toString(this.d) + "\n");
        return stringBuffer.toString();
    }
}

