/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.utils.InternalErrorException;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DHPublicKey
extends PublicKeyInfo
implements javax.crypto.interfaces.DHPublicKey {
    private static final long serialVersionUID = 4363294640634943357L;
    private static final BigInteger a = BigInteger.valueOf(2L);
    private transient ASN1 c;
    private BigInteger d;
    private transient DHParameterSpec e;

    public static void validatePublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws InvalidKeyException {
        BigInteger bigInteger4 = bigInteger2.subtract(a);
        if (bigInteger.compareTo(a) < 0 || bigInteger.compareTo(bigInteger4) > 0) {
            throw new InvalidKeyException("DH public key value out of range!");
        }
        if (bigInteger3 != null && (bigInteger3.compareTo(a) < 0 || bigInteger3.compareTo(bigInteger4) > 0)) {
            throw new InvalidKeyException("DH base generator out of range!");
        }
    }

    public DHPublicKey(BigInteger bigInteger, DHParameterSpec dHParameterSpec) {
        this.d = bigInteger;
        this.e = dHParameterSpec;
        this.a();
    }

    public DHPublicKey(DHPublicKeySpec dHPublicKeySpec) {
        this.d = dHPublicKeySpec.getY();
        this.e = new DHParameterSpec(dHPublicKeySpec.getP(), dHPublicKeySpec.getG());
        this.a();
    }

    public DHPublicKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public DHPublicKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    public DHPublicKey(InputStream inputStream) throws IOException, InvalidKeyException {
        super(inputStream);
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.c = new ASN1(byArray);
            this.d = (BigInteger)this.c.toASN1Object().getValue();
            ASN1Object aSN1Object = this.public_key_algorithm.getParameter();
            BigInteger bigInteger = (BigInteger)aSN1Object.getComponentAt(0).getValue();
            BigInteger bigInteger2 = (BigInteger)aSN1Object.getComponentAt(1).getValue();
            if (aSN1Object.countComponents() > 2) {
                int n2 = ((BigInteger)aSN1Object.getComponentAt(2).getValue()).intValue();
                this.e = new DHParameterSpec(bigInteger, bigInteger2, n2);
            } else {
                this.e = new DHParameterSpec(bigInteger, bigInteger2);
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No DH Public Key: " + exception.toString());
        }
    }

    private void a() {
        try {
            this.c = new ASN1(new INTEGER(this.d));
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.e.getP()));
            sEQUENCE.addComponent(new INTEGER(this.e.getG()));
            if (this.e.getL() > 0) {
                sEQUENCE.addComponent(new INTEGER(this.e.getL()));
            }
            this.public_key_algorithm = (AlgorithmID)AlgorithmID.dhKeyAgreement.clone();
            this.public_key_algorithm.setParameter(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        this.createPublicKeyInfo();
    }

    public byte[] encode() {
        return this.c.toByteArray();
    }

    public String getAlgorithm() {
        return "DH";
    }

    public BigInteger getY() {
        return this.d;
    }

    public DHParameterSpec getParams() {
        return this.e;
    }

    public byte[] getFingerprint() {
        return this.c.fingerprint();
    }

    public int hashCode() {
        return this.d.hashCode() ^ this.e.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DH public key");
        stringBuffer.append(this.e == null ? ":\n" : " (" + this.e.getP().bitLength() + " bits):\n");
        stringBuffer.append("Y: " + this.d.toString(16) + "\n");
        if (this.e != null) {
            stringBuffer.append("key parameters:\n" + this.e.toString() + "\n");
        }
        return stringBuffer.toString();
    }
}

