/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.security.dh.DHParameterGenerator;
import iaik.security.dh.DHPrivateKey;
import iaik.security.dh.DHPublicKey;
import iaik.security.random.SecRandom;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;

public class DHKeyPairGenerator
extends KeyPairGenerator {
    private static final byte[] c = new byte[]{2};
    private static final byte[] d = new byte[]{-1, -57, -123, 98, 127, -101, 46, 102, -36, 85, -49, -49, -107, -127, 82, -108, -56, -54, 76, 37, 121, -93, 107, -111, 34, 64, -92, -102, -118, -49, -103, 80, -27, -71, 101, -23, 12, 58, 67, 92, -128, 78, 45, 62, 124, 104, -3, -31, 24, -100, 69, 80, -37, -46, -97, -122, -123, 86, -90, 87, 29, 124, -122, -3};
    private SecureRandom e;
    private int f = -1;
    private int g = -1;
    BigInteger a;
    BigInteger b;

    public DHKeyPairGenerator() {
        super("DH");
    }

    public void initialize(int n2) {
        this.initialize(n2, null);
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        this.e = secureRandom;
        this.f = n2;
        switch (this.f) {
            case 512: {
                this.a = new BigInteger(1, d);
                this.b = new BigInteger(c);
                break;
            }
            case 1024: {
                this.a = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF", 16);
                this.b = BigInteger.valueOf(2L);
                break;
            }
            case 1536: {
                this.a = new BigInteger("FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA237327FFFFFFFFFFFFFFFF", 16);
                this.b = BigInteger.valueOf(2L);
                break;
            }
            case 2048: {
                this.a = new BigInteger("FFFFFFFFFFFFFFFFADF85458A2BB4A9AAFDC5620273D3CF1D8B9C583CE2D3695A9E13641146433FBCC939DCE249B3EF97D2FE363630C75D8F681B202AEC4617AD3DF1ED5D5FD65612433F51F5F066ED0856365553DED1AF3B557135E7F57C935984F0C70E0E68B77E2A689DAF3EFE8721DF158A136ADE73530ACCA4F483A797ABC0AB182B324FB61D108A94BB2C8E3FBB96ADAB760D7F4681D4F42A3DE394DF4AE56EDE76372BB190B07A7C8EE0A6D709E02FCE1CDF7E2ECC03404CD28342F619172FE9CE98583FF8E4F1232EEF28183C3FE3B1B4C6FAD733BB5FCBC2EC22005C58EF1837D1683B2C6F34A26C1B2EFFA886B423861285C97FFFFFFFFFFFFFFFF", 16);
                this.b = BigInteger.valueOf(2L);
                break;
            }
            case 3072: {
                this.a = new BigInteger("FFFFFFFFFFFFFFFFADF85458A2BB4A9AAFDC5620273D3CF1D8B9C583CE2D3695A9E13641146433FBCC939DCE249B3EF97D2FE363630C75D8F681B202AEC4617AD3DF1ED5D5FD65612433F51F5F066ED0856365553DED1AF3B557135E7F57C935984F0C70E0E68B77E2A689DAF3EFE8721DF158A136ADE73530ACCA4F483A797ABC0AB182B324FB61D108A94BB2C8E3FBB96ADAB760D7F4681D4F42A3DE394DF4AE56EDE76372BB190B07A7C8EE0A6D709E02FCE1CDF7E2ECC03404CD28342F619172FE9CE98583FF8E4F1232EEF28183C3FE3B1B4C6FAD733BB5FCBC2EC22005C58EF1837D1683B2C6F34A26C1B2EFFA886B4238611FCFDCDE355B3B6519035BBC34F4DEF99C023861B46FC9D6E6C9077AD91D2691F7F7EE598CB0FAC186D91CAEFE130985139270B4130C93BC437944F4FD4452E2D74DD364F2E21E71F54BFF5CAE82AB9C9DF69EE86D2BC522363A0DABC521979B0DEADA1DBF9A42D5C4484E0ABCD06BFA53DDEF3C1B20EE3FD59D7C25E41D2B66C62E37FFFFFFFFFFFFFFFF", 16);
                this.b = BigInteger.valueOf(2L);
                break;
            }
            case 4096: {
                this.a = new BigInteger("FFFFFFFFFFFFFFFFADF85458A2BB4A9AAFDC5620273D3CF1D8B9C583CE2D3695A9E13641146433FBCC939DCE249B3EF97D2FE363630C75D8F681B202AEC4617AD3DF1ED5D5FD65612433F51F5F066ED0856365553DED1AF3B557135E7F57C935984F0C70E0E68B77E2A689DAF3EFE8721DF158A136ADE73530ACCA4F483A797ABC0AB182B324FB61D108A94BB2C8E3FBB96ADAB760D7F4681D4F42A3DE394DF4AE56EDE76372BB190B07A7C8EE0A6D709E02FCE1CDF7E2ECC03404CD28342F619172FE9CE98583FF8E4F1232EEF28183C3FE3B1B4C6FAD733BB5FCBC2EC22005C58EF1837D1683B2C6F34A26C1B2EFFA886B4238611FCFDCDE355B3B6519035BBC34F4DEF99C023861B46FC9D6E6C9077AD91D2691F7F7EE598CB0FAC186D91CAEFE130985139270B4130C93BC437944F4FD4452E2D74DD364F2E21E71F54BFF5CAE82AB9C9DF69EE86D2BC522363A0DABC521979B0DEADA1DBF9A42D5C4484E0ABCD06BFA53DDEF3C1B20EE3FD59D7C25E41D2B669E1EF16E6F52C3164DF4FB7930E9E4E58857B6AC7D5F42D69F6D187763CF1D5503400487F55BA57E31CC7A7135C886EFB4318AED6A1E012D9E6832A907600A918130C46DC778F971AD0038092999A333CB8B7A1A1DB93D7140003C2A4ECEA9F98D0ACC0A8291CDCEC97DCF8EC9B55A7F88A46B4DB5A851F44182E1C68A007E5E655F6AFFFFFFFFFFFFFFFF", 16);
                this.b = BigInteger.valueOf(2L);
                break;
            }
            default: {
                this.a = null;
                this.b = null;
            }
        }
        this.g = -1;
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.e = secureRandom;
        if (algorithmParameterSpec instanceof DHParameterSpec) {
            this.a = ((DHParameterSpec)algorithmParameterSpec).getP();
            this.b = ((DHParameterSpec)algorithmParameterSpec).getG();
            this.f = this.a.bitLength();
            this.g = ((DHParameterSpec)algorithmParameterSpec).getL();
            if (this.g > this.f) {
                throw new InvalidAlgorithmParameterException("The size of the exponent must be less than the size of the modulus");
            }
        } else {
            throw new InvalidAlgorithmParameterException("Parameter must be a DHParameterSpec.");
        }
    }

    public KeyPair generateKeyPair() {
        Object object;
        Object object2;
        if (this.e == null) {
            this.e = SecRandom.getDefault();
        }
        if (this.f < 0) {
            this.f = 2048;
            this.initialize(this.f, this.e);
        }
        if (this.g <= 0) {
            this.g = DHParameterGenerator.a(this.f);
        }
        DHParameterSpec dHParameterSpec = new DHParameterSpec(this.a, this.b);
        if (this.a == null || this.b == null) {
            try {
                object2 = new DHGenParameterSpec(this.f, this.g);
                object = new DHParameterGenerator();
                ((DHParameterGenerator)object).engineInit((AlgorithmParameterSpec)object2, this.e);
                AlgorithmParameters algorithmParameters = ((DHParameterGenerator)object).engineGenerateParameters();
                dHParameterSpec = (DHParameterSpec)algorithmParameters.getParameterSpec(dHParameterSpec.getClass());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new RuntimeException(invalidAlgorithmParameterException.toString());
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new RuntimeException(invalidParameterSpecException.toString());
            }
        }
        BigInteger bigInteger = new BigInteger(this.g, this.e).setBit(this.g - 1);
        object2 = new DHPrivateKey(bigInteger, dHParameterSpec);
        BigInteger bigInteger2 = dHParameterSpec.getG().modPow(bigInteger, dHParameterSpec.getP());
        object = new DHPublicKey(bigInteger2, dHParameterSpec);
        return new KeyPair((PublicKey)object, (PrivateKey)object2);
    }
}

