/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.security.cipher.IvParameters;
import iaik.utils.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

public class RC5Parameters
extends IvParameters {
    private int b;
    private int c;
    private int d;

    protected byte[] engineGetEncoded() throws IOException {
        try {
            SEQUENCE sEQUENCE = new SEQUENCE();
            ((ASN1Object)sEQUENCE).addComponent(new INTEGER(this.b));
            ((ASN1Object)sEQUENCE).addComponent(new INTEGER(this.c));
            ((ASN1Object)sEQUENCE).addComponent(new INTEGER(this.d << 1));
            if (this.a != null) {
                ((ASN1Object)sEQUENCE).addComponent(new OCTET_STRING(this.a));
            }
            return DerCoder.encode(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new IOException("Cannot encode RC5 parameters: " + codingException.getMessage());
        }
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        RC5ParameterSpec rC5ParameterSpec = this.a == null ? new RC5ParameterSpec(this.b, this.c, this.d) : new RC5ParameterSpec(this.b, this.c, this.d, this.a);
        if (!rC5ParameterSpec.getClass().isAssignableFrom(clazz)) {
            return super.engineGetParameterSpec(clazz);
        }
        return rC5ParameterSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof RC5ParameterSpec) {
            RC5ParameterSpec rC5ParameterSpec = (RC5ParameterSpec)algorithmParameterSpec;
            this.b = rC5ParameterSpec.getVersion();
            this.c = rC5ParameterSpec.getRounds();
            if (this.c < 8 || this.c > 127) {
                throw new InvalidParameterSpecException("Invalid number of rounds: " + this.c);
            }
            this.d = rC5ParameterSpec.getWordSize();
            if (this.d != 32) {
                throw new InvalidParameterSpecException("Invalid word size. Only 32 supported at this time.");
            }
            this.a = rC5ParameterSpec.getIV();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            this.b = 16;
            this.c = 12;
            this.d = 32;
            this.a = ivParameterSpec.getIV();
        } else {
            throw new InvalidParameterSpecException("Parameter must be RC5ParameterSpec.");
        }
        if (this.a != null && this.a.length != 8) {
            throw new InvalidParameterSpecException("Invalid IV; must be 8 octets long.");
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        block7: {
            try {
                ASN1Object aSN1Object = DerCoder.decode(byArray);
                if (aSN1Object.isA(ASN.SEQUENCE)) {
                    this.b = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
                    this.c = ((BigInteger)aSN1Object.getComponentAt(1).getValue()).intValue();
                    if (this.c < 8 || this.c > 127) {
                        throw new IOException("Invalid number of rounds: " + this.c);
                    }
                    this.d = ((BigInteger)aSN1Object.getComponentAt(2).getValue()).intValue() >> 1;
                    if (this.d != 32) {
                        throw new IOException("Invalid word size. Only 32 supported at this time.");
                    }
                    if (aSN1Object.countComponents() == 4) {
                        this.a = (byte[])aSN1Object.getComponentAt(3).getValue();
                        if (this.a == null || this.a.length != 8) {
                            throw new IOException("Cannot init RC5 params. Invalid IV; must be 8 octets long.");
                        }
                    }
                    break block7;
                }
                throw new IOException("Cannot decode RC5 params. Invalid ASN.1 type!");
            }
            catch (CodingException codingException) {
                throw new IOException("DER decoding error. " + codingException.toString());
            }
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("version: " + this.b + "\n");
        stringBuffer.append("rounds: " + this.c + "\n");
        stringBuffer.append("wordsize: " + this.b + "\n");
        stringBuffer.append("iv: " + Util.toString(this.a) + "\n");
        return stringBuffer.toString();
    }
}

