/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.security.cipher.PBEKey;
import iaik.security.cipher.PBEKeyBMP;
import iaik.security.cipher.RC2;
import iaik.security.cipher.SecretKey;
import iaik.security.cipher.g;
import iaik.security.pbe.PBEGenParameterSpec;
import iaik.security.provider.IAIK;
import iaik.security.spec.PBEKeyAndParameterSpec;
import iaik.utils.IaikSecurity;
import java.lang.reflect.Method;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PbeWithSHAAnd40BitRC2_CBC
extends RC2 {
    protected AlgorithmParameters params;
    static Class a;

    public PbeWithSHAAnd40BitRC2_CBC() throws NoSuchAlgorithmException, NoSuchPaddingException {
        super.engineSetMode("CBC");
    }

    public AlgorithmParameters engineGetParameters() {
        return this.params;
    }

    public void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = this.a("PBE");
            algorithmParameterGenerator.init(8, secureRandom);
            this.params = algorithmParameterGenerator.generateParameters();
            this.initCipher(n2, key, secureRandom);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    public void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters == null || !algorithmParameters.getAlgorithm().equals("PBE")) {
            throw new InvalidAlgorithmParameterException("Parameters must be of type PBEParameters.");
        }
        this.params = algorithmParameters;
        this.initCipher(n2, key, secureRandom);
    }

    public void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            this.engineInit(n2, key, secureRandom);
        } else {
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                try {
                    this.params = IaikSecurity.getAlgorithmParametersInstance("PBE", IAIK.getInstance());
                }
                catch (Exception exception) {
                    try {
                        this.params = AlgorithmParameters.getInstance("PBE");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new InvalidAlgorithmParameterException("Cannot create PBE Algorithm parameters!");
                    }
                }
                try {
                    this.params.init(algorithmParameterSpec);
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    throw new InvalidAlgorithmParameterException("Error setting algorithm parameters.");
                }
            }
            if (algorithmParameterSpec instanceof PBEGenParameterSpec) {
                try {
                    AlgorithmParameterGenerator algorithmParameterGenerator = this.a("PBE");
                    algorithmParameterGenerator.init(algorithmParameterSpec, secureRandom);
                    this.params = algorithmParameterGenerator.generateParameters();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InvalidAlgorithmParameterException("Error setting algorithm parameters.");
                }
            } else {
                throw new InvalidAlgorithmParameterException("Parameters must be an instance of PBEParameterSpec or PBEGenParameterSpec.");
            }
            this.initCipher(n2, key, secureRandom);
        }
    }

    public static PBEKeyBMP converToPBEKeyBMP(javax.crypto.SecretKey secretKey) throws InvalidKeyException {
        Object object;
        Object object2;
        if (secretKey instanceof PBEKeyBMP) {
            return (PBEKeyBMP)secretKey;
        }
        char[] cArray = null;
        if (secretKey instanceof PBEKey) {
            cArray = ((PBEKey)secretKey).getKey();
        } else {
            try {
                object2 = Class.forName("javax.crypto.interfaces.PBEKey");
                if (((Class)object2).isAssignableFrom(secretKey.getClass())) {
                    object = secretKey.getClass().getDeclaredMethod("getPassword", new Class[0]);
                    cArray = (char[])((Method)object).invoke((Object)secretKey, null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (cArray != null) {
            object2 = new PBEKeySpec(cArray);
            object = null;
            try {
                object = IaikSecurity.getSecretKeyFactoryInstance("PKCS#12", IAIK.getInstance());
                PBEKeyBMP pBEKeyBMP = (PBEKeyBMP)((SecretKeyFactory)object).generateSecret((KeySpec)object2);
                return pBEKeyBMP;
            }
            catch (Exception exception) {
                throw new InvalidKeyException(exception.getMessage());
            }
        }
        throw new InvalidKeyException("Must be a PBEKey in RAW_BMP format.");
    }

    protected void initCipher(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEParameterSpec pBEParameterSpec;
        Object object;
        if (key == null) {
            throw new InvalidKeyException("key must not be null.");
        }
        Key key2 = key;
        if (!(key instanceof PBEKeyBMP)) {
            key2 = null;
            if (key instanceof javax.crypto.SecretKey) {
                try {
                    key2 = PbeWithSHAAnd40BitRC2_CBC.converToPBEKeyBMP((javax.crypto.SecretKey)key);
                }
                catch (InvalidKeyException invalidKeyException) {
                    // empty catch block
                }
            }
            if (key2 == null) {
                object = key.getAlgorithm();
                if (!((String)object).equals("PBE") && !((String)object).equals("PBEWithSHA1AndRC2_40") || !key.getFormat().equals("RAW_BMP")) {
                    throw new InvalidKeyException("Must be a PBEKey in RAW_BMP format.");
                }
                key2 = key;
            }
        }
        object = key2.getEncoded();
        if (this.params == null) {
            throw new InvalidAlgorithmParameterException("Cipher not initialized yet!");
        }
        try {
            pBEParameterSpec = (PBEParameterSpec)this.params.getParameterSpec(a == null ? (a = PbeWithSHAAnd40BitRC2_CBC.class$("javax.crypto.spec.PBEParameterSpec")) : a);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException.getMessage());
        }
        PBEKeyAndParameterSpec pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec((byte[])object, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount(), 5);
        try {
            KeyGenerator keyGenerator = IaikSecurity.getKeyGeneratorInstance("PKCS#12", IAIK.getInstance());
            keyGenerator.init(pBEKeyAndParameterSpec, secureRandom);
            SecretKey secretKey = (SecretKey)keyGenerator.generateKey();
            secretKey.setAlgorithm("RC2");
            KeyGenerator keyGenerator2 = IaikSecurity.getKeyGeneratorInstance("PKCS#12-IV", IAIK.getInstance());
            pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec((byte[])object, pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount(), 8);
            keyGenerator2.init(pBEKeyAndParameterSpec, secureRandom);
            SecretKey secretKey2 = (SecretKey)keyGenerator2.generateKey();
            IvParameterSpec ivParameterSpec = new IvParameterSpec(secretKey2.getEncoded());
            super.engineInit(n2, (Key)secretKey, ivParameterSpec, secureRandom);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException("Algorithm not available: " + noSuchAlgorithmException.getMessage());
        }
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
        this.h = new g();
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n2 = 40;
        return n2;
    }

    private AlgorithmParameterGenerator a(String string) throws NoSuchAlgorithmException {
        AlgorithmParameterGenerator algorithmParameterGenerator = null;
        try {
            algorithmParameterGenerator = IaikSecurity.getAlgorithmParameterGeneratorInstance(string, IAIK.getInstance());
        }
        catch (Exception exception) {
            algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance(string);
        }
        return algorithmParameterGenerator;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

