/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.security.cipher.DES;
import iaik.security.cipher.DESKeyGenerator;
import iaik.security.cipher.PBEKey;
import iaik.security.cipher.SecretKey;
import iaik.security.cipher.g;
import iaik.security.pbe.PBEGenParameterSpec;
import iaik.security.provider.IAIK;
import iaik.utils.IaikSecurity;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class PbeWithMD5AndDES_CBC
extends DES {
    protected AlgorithmParameters params;
    static Class a;

    public PbeWithMD5AndDES_CBC() throws NoSuchAlgorithmException, NoSuchPaddingException {
        super.engineSetMode("CBC");
    }

    public AlgorithmParameters engineGetParameters() {
        return this.params;
    }

    protected void initCipher(int n2, Key key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        PBEParameterSpec pBEParameterSpec;
        Object object;
        if (key == null) {
            throw new InvalidKeyException("key must not be null!");
        }
        if (!(key instanceof PBEKey || (((String)(object = key.getAlgorithm())).equals("PBE") || ((String)object).equals("PBEWithMD5AndDES")) && key.getFormat().equals("RAW"))) {
            throw new InvalidKeyException("Must be a PBEKey in RAW format.");
        }
        object = key.getEncoded();
        if (this.params == null) {
            throw new InvalidAlgorithmParameterException("Cipher not initialized yet!");
        }
        try {
            pBEParameterSpec = (PBEParameterSpec)this.params.getParameterSpec(a == null ? (a = PbeWithMD5AndDES_CBC.class$("javax.crypto.spec.PBEParameterSpec")) : a);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InvalidAlgorithmParameterException(invalidParameterSpecException.getMessage());
        }
        byte[] byArray = pBEParameterSpec.getSalt();
        int n3 = pBEParameterSpec.getIterationCount();
        if (byArray.length != 8) {
            throw new InvalidAlgorithmParameterException("Salt must be 8 bytes long.");
        }
        byte[] byArray2 = new byte[((Object)object).length + byArray.length];
        System.arraycopy(object, 0, byArray2, 0, ((Object)object).length);
        System.arraycopy(byArray, 0, byArray2, ((Object)object).length, byArray.length);
        MessageDigest messageDigest = null;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                messageDigest = IaikSecurity.getMessageDigestInstance("MD5", IAIK.getInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (messageDigest == null) {
            try {
                messageDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidKeyException(noSuchAlgorithmException.toString());
            }
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            byArray2 = messageDigest.digest(byArray2);
        }
        DESKeyGenerator.adjustParity(byArray2, 0);
        SecretKey secretKey = new SecretKey(byArray2, 0, 8, "DES");
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2, 8, 8);
        super.engineInit(n2, (Key)secretKey, ivParameterSpec, null);
    }

    public void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            AlgorithmParameterGenerator algorithmParameterGenerator = this.a("PBE");
            algorithmParameterGenerator.init(8, secureRandom);
            this.params = algorithmParameterGenerator.generateParameters();
            this.initCipher(n2, key);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidKeyException(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.getMessage());
        }
    }

    public void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameters == null || !algorithmParameters.getAlgorithm().equals("PBE")) {
            throw new InvalidAlgorithmParameterException("Parameters must be of type PBEParameters.");
        }
        this.params = algorithmParameters;
        this.initCipher(n2, key);
    }

    public void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec == null) {
            this.engineInit(n2, key, secureRandom);
        } else {
            if (algorithmParameterSpec instanceof PBEParameterSpec) {
                try {
                    this.params = IaikSecurity.getAlgorithmParametersInstance("PBE", IAIK.getInstance());
                }
                catch (Exception exception) {
                    try {
                        this.params = AlgorithmParameters.getInstance("PBE");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new InvalidAlgorithmParameterException("Cannot create PBE Algorithm parameters!");
                    }
                }
                try {
                    this.params.init(algorithmParameterSpec);
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    throw new InvalidAlgorithmParameterException("Error setting algorithm parameters.");
                }
            }
            if (algorithmParameterSpec instanceof PBEGenParameterSpec) {
                try {
                    AlgorithmParameterGenerator algorithmParameterGenerator = this.a("PBE");
                    algorithmParameterGenerator.init(algorithmParameterSpec, secureRandom);
                    this.params = algorithmParameterGenerator.generateParameters();
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new InvalidAlgorithmParameterException("Error setting algorithm parameters.");
                }
            } else {
                throw new InvalidAlgorithmParameterException("Parameters must be an instance of PBEParameterSpec or PBEGenParameterSpec.");
            }
            this.initCipher(n2, key);
        }
    }

    public void engineSetPadding(String string) {
        this.h = new g();
    }

    public void engineSetMode(String string) {
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        int n2 = 56;
        return n2;
    }

    private AlgorithmParameterGenerator a(String string) throws NoSuchAlgorithmException {
        AlgorithmParameterGenerator algorithmParameterGenerator = null;
        try {
            algorithmParameterGenerator = IaikSecurity.getAlgorithmParameterGeneratorInstance(string, IAIK.getInstance());
        }
        catch (Exception exception) {
            algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance(string);
        }
        return algorithmParameterGenerator;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

