/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs5.PBES2ParameterSpec;
import iaik.pkcs.pkcs5.PBKDF2KeyAndParameterSpec;
import iaik.pkcs.pkcs5.PBKDF2ParameterSpec;
import iaik.security.cipher.A;
import iaik.security.cipher.C;
import iaik.security.cipher.H;
import iaik.security.cipher.K;
import iaik.security.cipher.L;
import iaik.security.cipher.M;
import iaik.security.cipher.N;
import iaik.security.cipher.O;
import iaik.security.cipher.PBEKey;
import iaik.security.cipher.b;
import iaik.security.cipher.i;
import iaik.security.cipher.m;
import iaik.security.cipher.n;
import iaik.security.cipher.u;
import iaik.security.cipher.x;
import iaik.security.cipher.y;
import iaik.security.provider.IAIK;
import iaik.security.random.SecRandom;
import iaik.utils.CriticalObject;
import iaik.utils.IaikSecurity;
import iaik.utils.InternalErrorException;
import java.lang.reflect.Method;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PBES2Cipher
extends b {
    static final AlgorithmID a = (AlgorithmID)AlgorithmID.hMAC_SHA1_.clone();
    private static final AlgorithmID o = (AlgorithmID)AlgorithmID.aes128_CBC.clone();
    private PBES2ParameterSpec p;
    private PBES2ParameterSpec q;
    private AlgorithmID r;
    private int s;
    private AlgorithmID t;
    static Class k;
    static Class l;
    static Class m;
    static Class n;

    private static String[] a(String string) {
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringArray[i2] = stringTokenizer.nextToken().trim();
        }
        if (stringArray[1] == null) {
            stringArray[1] = "CBC";
        }
        if (stringArray[2] == null) {
            stringArray[2] = "PKCS5Padding";
        }
        return stringArray;
    }

    private static x b(String string) throws NoSuchAlgorithmException {
        x x2 = null;
        String string2 = string.toUpperCase(Locale.US);
        if (string2.startsWith("AES")) {
            string2 = "Rijndael";
            x2 = new K();
        } else if (string2.equals("DESEDE")) {
            string2 = "TripleDES";
            x2 = new N();
        } else if (string2.startsWith("CAST")) {
            string2 = "CAST128";
            x2 = new n();
        } else if (string2.equals("ARCFOUR") || string2.equals("RC4")) {
            x2 = new i();
        } else if (string2.equals("BLOWFISH")) {
            x2 = new m();
        } else if (string2.equals("CAMELLIA")) {
            x2 = new u();
        } else if (string2.equals("DES")) {
            x2 = new y();
        } else if (string2.equals("GOST")) {
            x2 = new A();
        } else if (string2.equals("MARS")) {
            x2 = new C();
        } else if (string2.equals("RC2")) {
            x2 = new H();
        } else if (string2.equals("RIJNDAEl256")) {
            x2 = new L();
        } else if (string2.equals("SERPENT")) {
            x2 = new M();
        } else if (string2.equals("TWOFISH")) {
            x2 = new O();
        } else {
            string2 = string;
        }
        if (x2 == null) {
            try {
                Class<?> clazz = Class.forName("iaik.security.cipher.Raw" + string2);
                x2 = (x)clazz.newInstance();
            }
            catch (Throwable throwable) {
                throw new NoSuchAlgorithmException("No Cipher implementation for " + string + ": " + throwable.toString());
            }
        }
        return x2;
    }

    public PBES2Cipher() {
    }

    PBES2Cipher(x x2, int n2, AlgorithmID algorithmID, AlgorithmID algorithmID2) {
        super(x2);
        this.s = n2;
        this.t = (AlgorithmID)algorithmID.clone();
        this.r = (AlgorithmID)algorithmID2.clone();
    }

    public void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec;
        block7: {
            algorithmParameterSpec = null;
            if (algorithmParameters != null) {
                try {
                    String string = algorithmParameters.getAlgorithm().toUpperCase(Locale.US);
                    if (string.startsWith("PBES2")) {
                        algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(k == null ? (k = PBES2Cipher.class$("iaik.pkcs.pkcs5.PBES2ParameterSpec")) : k);
                        break block7;
                    }
                    if ("PBKDF2".equals(string)) {
                        algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(l == null ? (l = PBES2Cipher.class$("iaik.pkcs.pkcs5.PBKDF2ParameterSpec")) : l);
                        break block7;
                    }
                    if ("IV".equals(string)) {
                        algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(m == null ? (m = PBES2Cipher.class$("javax.crypto.spec.IvParameterSpec")) : m);
                        break block7;
                    }
                    if (string.startsWith("PBE")) {
                        algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(n == null ? (n = PBES2Cipher.class$("javax.crypto.spec.PBEParameterSpec")) : n);
                        break block7;
                    }
                    throw new InvalidAlgorithmParameterException("Parameters must be of type PBES2Parameters.");
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    throw new InvalidAlgorithmParameterException(invalidParameterSpecException.toString());
                }
            }
        }
        this.a(n2, key, algorithmParameterSpec, secureRandom);
    }

    public void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a(n2, key, algorithmParameterSpec, secureRandom);
    }

    public void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.a(n2, key, null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.toString());
        }
    }

    public AlgorithmParameters engineGetParameters() {
        if (this.p == null) {
            throw new IllegalStateException("Cipher not initialized yet!");
        }
        try {
            AlgorithmParameters algorithmParameters = IaikSecurity.getAlgorithmParametersInstance("PBES2", IAIK.getInstance());
            algorithmParameters.init(this.p);
            return algorithmParameters;
        }
        catch (Exception exception) {
            throw new InternalErrorException(exception);
        }
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return this.s;
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
        if (this.b != null) {
            super.engineSetPadding(string);
        }
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (this.b != null) {
            super.engineSetMode(string);
        }
    }

    private String a(AlgorithmID algorithmID) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Object object;
        String string = algorithmID.getImplementationName();
        String[] stringArray = PBES2Cipher.a(string);
        String string2 = stringArray[0];
        if (string2 == null) {
            throw new NoSuchAlgorithmException("Encryption scheme " + algorithmID.getName() + " not supported!");
        }
        if (this.b == null) {
            object = PBES2Cipher.b(string2);
            this.a((x)object);
        }
        object = stringArray[1];
        String string3 = stringArray[2];
        this.engineSetMode((String)object);
        this.engineSetPadding(string3);
        return string2;
    }

    void a(int n2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        byte[] byArray;
        int n3;
        int n4;
        AlgorithmID algorithmID;
        AlgorithmID algorithmID2;
        PBES2ParameterSpec pBES2ParameterSpec;
        block30: {
            pBES2ParameterSpec = null;
            algorithmID2 = null;
            algorithmID = null;
            n4 = 0;
            n3 = 0;
            byArray = null;
            if (algorithmParameterSpec instanceof PBES2ParameterSpec) {
                pBES2ParameterSpec = (PBES2ParameterSpec)algorithmParameterSpec;
                algorithmID2 = pBES2ParameterSpec.getEncryptionScheme();
                if (this.r != null && !this.r.equals(algorithmID2)) {
                    throw new InvalidAlgorithmParameterException("Illegal encryption scheme (" + algorithmID2.getAlgorithm().getName() + "). Must be " + this.r.getAlgorithm().getName());
                }
            } else {
                if (n2 != 1 && n2 != 3) {
                    throw new InvalidAlgorithmParameterException("Params must be PBES2ParameterSpec!");
                }
                algorithmID2 = this.r == null ? (AlgorithmID)o.clone() : (AlgorithmID)this.r.clone();
            }
            if (algorithmParameterSpec instanceof PBKDF2ParameterSpec) {
                PBKDF2ParameterSpec pBKDF2ParameterSpec = (PBKDF2ParameterSpec)algorithmParameterSpec;
                algorithmID = pBKDF2ParameterSpec.getPrf();
                if (a.equals(algorithmID)) {
                    if (this.t != null) {
                        algorithmID = (AlgorithmID)this.t.clone();
                    }
                } else if (this.t != null && !this.t.equals(algorithmID)) {
                    throw new InvalidAlgorithmParameterException("Illegal PRF (" + algorithmID.getAlgorithm().getName() + "). Must be " + this.t.getAlgorithm().getName());
                }
                if ((n4 = pBKDF2ParameterSpec.getDerivedKeyLength()) <= 0) {
                    if (this.s == 0) {
                        throw new InvalidAlgorithmParameterException("Derived key length not specified!");
                    }
                    n4 = this.s;
                } else if (this.s > 0 && this.s != n4) {
                    throw new InvalidAlgorithmParameterException("Illegal key length (" + n4 + "). Must be " + this.s);
                }
                byArray = pBKDF2ParameterSpec.getSalt();
                n3 = pBKDF2ParameterSpec.getIterationCount();
            } else if (algorithmParameterSpec instanceof IvParameterSpec) {
                try {
                    algorithmID2.setAlgorithmParameterSpec(algorithmParameterSpec, IAIK.getInstance());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    algorithmID2.setAlgorithmParameterSpec(algorithmParameterSpec);
                }
            } else if (algorithmParameterSpec instanceof PBEParameterSpec) {
                PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
                byArray = pBEParameterSpec.getSalt();
                n3 = pBEParameterSpec.getIterationCount();
                try {
                    Method method = pBEParameterSpec.getClass().getDeclaredMethod("getParameterSpec", new Class[0]);
                    AlgorithmParameterSpec algorithmParameterSpec2 = (AlgorithmParameterSpec)method.invoke((Object)pBEParameterSpec, null);
                    if (algorithmParameterSpec2 == null) break block30;
                    try {
                        algorithmID2.setAlgorithmParameterSpec(algorithmParameterSpec2, IAIK.getInstance());
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        algorithmID2.setAlgorithmParameterSpec(algorithmParameterSpec2);
                    }
                }
                catch (Throwable throwable) {}
            } else if (algorithmParameterSpec != null) {
                throw new InvalidAlgorithmParameterException("Params must be PBES2ParameterSpec or PBKDF2ParameterSpec or IvParameterSpec!");
            }
        }
        if (pBES2ParameterSpec == null) {
            if (byArray == null) {
                byArray = new byte[32];
                secureRandom.nextBytes(byArray);
            }
            if (n3 <= 0) {
                n3 = 2000;
            }
            if (algorithmID == null) {
                AlgorithmID algorithmID3 = algorithmID = this.t != null ? (AlgorithmID)this.t.clone() : (AlgorithmID)a.clone();
            }
            if (n4 <= 0) {
                n4 = this.s > 0 ? this.s : 16;
            }
            pBES2ParameterSpec = new PBES2ParameterSpec(byArray, n3, n4, algorithmID2);
            pBES2ParameterSpec.setPrf(algorithmID);
        }
        this.q = (PBES2ParameterSpec)pBES2ParameterSpec.clone();
        this.p = (PBES2ParameterSpec)pBES2ParameterSpec.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        block23: {
            String string;
            if (!(key instanceof PBEKey)) {
                throw new InvalidKeyException("Must be a PBEKey in RAW format (iaik.security.cipher.PBEKey).");
            }
            if (secureRandom == null) {
                secureRandom = SecRandom.getDefault();
            }
            this.a(n2, algorithmParameterSpec, secureRandom);
            AlgorithmID algorithmID = this.p.getEncryptionScheme();
            try {
                string = this.a(algorithmID);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException(exception.toString());
            }
            KeyGenerator keyGenerator = null;
            try {
                keyGenerator = IaikSecurity.getKeyGeneratorInstance("PBKDF2", IAIK.getInstance());
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException(exception.toString());
            }
            byte[] byArray = key.getEncoded();
            byte[] byArray2 = this.p.getSalt();
            int n3 = this.p.getIterationCount();
            int n4 = this.p.getDerivedKeyLength();
            AlgorithmID algorithmID2 = this.p.getPrf();
            SecretKey secretKey = null;
            try {
                PBKDF2KeyAndParameterSpec pBKDF2KeyAndParameterSpec = new PBKDF2KeyAndParameterSpec(byArray, byArray2, n3, n4);
                pBKDF2KeyAndParameterSpec.setPrf(algorithmID2);
                keyGenerator.init(pBKDF2KeyAndParameterSpec, secureRandom);
                secretKey = keyGenerator.generateKey();
                SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), string);
                SecretKeyFactory secretKeyFactory = null;
                try {
                    secretKeyFactory = IaikSecurity.getSecretKeyFactoryInstance(string, IAIK.getInstance());
                    secretKey = secretKeyFactory.generateSecret(secretKeySpec);
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Error creating encryption scheme key: " + exception.toString());
                }
                if (this.q == null) {
                    throw new InvalidAlgorithmParameterException("Cipher not initialized yet!");
                }
                AlgorithmParameterSpec algorithmParameterSpec2 = null;
                try {
                    algorithmParameterSpec2 = this.q.getEncryptionSchemeParameters();
                }
                catch (Exception exception) {
                    throw new InvalidAlgorithmParameterException("Error parsing encryption scheme parameters: " + exception.toString());
                }
                if (algorithmParameterSpec2 == null) {
                    super.engineInit(n2, secretKey, secureRandom);
                } else {
                    super.engineInit(n2, (Key)secretKey, algorithmParameterSpec2, secureRandom);
                }
                AlgorithmParameters algorithmParameters = super.engineGetParameters();
                if (algorithmParameters == null) break block23;
                algorithmID.setAlgorithmParameters(algorithmParameters);
                try {
                    Class<?> clazz = null;
                    if (algorithmParameterSpec2 == null) {
                        try {
                            algorithmParameterSpec2 = algorithmID.getAlgorithmParameterSpec(IAIK.getInstance());
                        }
                        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                            algorithmParameterSpec2 = algorithmID.getAlgorithmParameterSpec();
                        }
                    }
                    if (algorithmParameterSpec2 != null) {
                        clazz = algorithmParameterSpec2.getClass();
                    }
                    if (clazz != null) {
                        algorithmParameterSpec2 = algorithmParameters.getParameterSpec(clazz);
                        this.p.setEncryptionSchemeParameters(algorithmParameterSpec2);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                CriticalObject.destroy(byArray);
            }
        }
    }

    void a() {
        if (this.q != null) {
            this.p = (PBES2ParameterSpec)this.q.clone();
        }
        super.a();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class PBES2WithHmacSHA1AndDESede
    extends PBES2Cipher {
        public PBES2WithHmacSHA1AndDESede() {
            super(new N(), 24, AlgorithmID.hMAC_SHA1, AlgorithmID.des_EDE3_CBC);
        }
    }

    public static final class PBES2WithHmacSHA512AndAES256
    extends PBES2Cipher {
        public PBES2WithHmacSHA512AndAES256() {
            super(new K(), 32, AlgorithmID.hMAC_SHA512, AlgorithmID.aes256_CBC);
        }
    }

    public static final class PBES2WithHmacSHA512AndAES
    extends PBES2Cipher {
        public PBES2WithHmacSHA512AndAES() {
            super(new K(), 16, AlgorithmID.hMAC_SHA512, AlgorithmID.aes128_CBC);
        }
    }

    public static final class PBES2WithHmacSHA384AndAES256
    extends PBES2Cipher {
        public PBES2WithHmacSHA384AndAES256() {
            super(new K(), 32, AlgorithmID.hMAC_SHA384, AlgorithmID.aes256_CBC);
        }
    }

    public static final class PBES2WithHmacSHA384AndAES192
    extends PBES2Cipher {
        public PBES2WithHmacSHA384AndAES192() {
            super(new K(), 24, AlgorithmID.hMAC_SHA384, AlgorithmID.aes192_CBC);
        }
    }

    public static final class PBES2WithHmacSHA384AndAES
    extends PBES2Cipher {
        public PBES2WithHmacSHA384AndAES() {
            super(new K(), 16, AlgorithmID.hMAC_SHA384, AlgorithmID.aes128_CBC);
        }
    }

    public static final class PBES2WithHmacSHA256AndAES256
    extends PBES2Cipher {
        public PBES2WithHmacSHA256AndAES256() {
            super(new K(), 32, AlgorithmID.hMAC_SHA256, AlgorithmID.aes256_CBC);
        }
    }

    public static final class PBES2WithHmacSHA256AndAES
    extends PBES2Cipher {
        public PBES2WithHmacSHA256AndAES() {
            super(new K(), 16, AlgorithmID.hMAC_SHA256, AlgorithmID.aes128_CBC);
        }
    }

    public static final class PBES2WithHmacSHA224AndAES256
    extends PBES2Cipher {
        public PBES2WithHmacSHA224AndAES256() {
            super(new K(), 32, AlgorithmID.hMAC_SHA224, AlgorithmID.aes256_CBC);
        }
    }

    public static final class PBES2WithHmacSHA224AndAES
    extends PBES2Cipher {
        public PBES2WithHmacSHA224AndAES() {
            super(new K(), 16, AlgorithmID.hMAC_SHA224, AlgorithmID.aes128_CBC);
        }
    }

    public static final class PBES2WithHmacSHA1AndAES256
    extends PBES2Cipher {
        public PBES2WithHmacSHA1AndAES256() {
            super(new K(), 32, AlgorithmID.hMAC_SHA1_, AlgorithmID.aes256_CBC);
        }
    }

    public static final class PBES2WithHmacSHA1AndAES
    extends PBES2Cipher {
        public PBES2WithHmacSHA1AndAES() {
            super(new K(), 16, AlgorithmID.hMAC_SHA1_, AlgorithmID.aes128_CBC);
        }
    }
}

