/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.security.cipher.IvGenParameterSpec;
import iaik.security.provider.IAIK;
import iaik.security.random.SecRandom;
import iaik.utils.IaikSecurity;
import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class IvParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    private SecureRandom a;
    private int b;

    public IvParameterGenerator() {
        this.b = 8;
    }

    public IvParameterGenerator(int n2) {
        this.b = n2;
    }

    protected void engineInit(int n2, SecureRandom secureRandom) {
        this.a = secureRandom;
        this.b = n2;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        this.a = secureRandom;
        if (!(algorithmParameterSpec instanceof IvGenParameterSpec)) {
            throw new InvalidAlgorithmParameterException("param must be an instance of IvGenParameterSpec.");
        }
        this.b = ((IvGenParameterSpec)algorithmParameterSpec).getIvLength();
    }

    protected AlgorithmParameters engineGenerateParameters() {
        if (this.a == null) {
            this.a = SecRandom.getDefault();
        }
        byte[] byArray = new byte[this.b];
        this.a.nextBytes(byArray);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray);
        try {
            AlgorithmParameters algorithmParameters = IaikSecurity.getAlgorithmParametersInstance("IV", IAIK.getInstance());
            algorithmParameters.init(ivParameterSpec);
            return algorithmParameters;
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new RuntimeException(invalidParameterSpecException.toString());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException(noSuchAlgorithmException.toString());
        }
    }
}

