/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.security.cipher.GCMParameterSpec;
import iaik.utils.Util;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Locale;
import javax.crypto.spec.IvParameterSpec;

public class GCMParameters
extends AlgorithmParametersSpi {
    private static boolean c = false;
    private static boolean d = false;
    private static boolean e = true;
    private static boolean f = false;
    private byte[] g;
    private int h;
    private byte[] i;
    private byte[] j;
    private boolean k;
    static Class a;
    static Class b;

    public static void setIncludeDefaultMacLengthInEncding(boolean bl) {
        f = bl;
    }

    public static void disableJava7ApiSupport(boolean bl) {
        c = bl;
    }

    static boolean a() {
        return c;
    }

    public static void setUseJava7ApiByDefault(boolean bl) {
        d = true;
        c = false;
    }

    static boolean b() {
        return d;
    }

    public static void checkKeyAndNonceReuse(boolean bl) {
        e = bl;
    }

    static boolean c() {
        return e;
    }

    static byte[] a(Object object) throws Exception {
        byte[] byArray = null;
        Method method = object.getClass().getDeclaredMethod("getIV", new Class[0]);
        byArray = (byte[])method.invoke(object, null);
        return byArray;
    }

    static int b(Object object) throws Exception {
        int n2 = -1;
        Method method = object.getClass().getDeclaredMethod("getTLen", new Class[0]);
        n2 = (Integer)method.invoke(object, null) / 8;
        return n2;
    }

    static AlgorithmParameterSpec a(Class clazz, byte[] byArray, int n2) throws Exception {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        Constructor constructor = clazz.getConstructor(Integer.TYPE, a == null ? (a = GCMParameters.class$("[B")) : a);
        algorithmParameterSpec = (AlgorithmParameterSpec)constructor.newInstance(new Integer(n2 * 8), byArray);
        return algorithmParameterSpec;
    }

    public GCMParameters() throws InvalidAlgorithmParameterException {
        this(null, null, null, -1);
    }

    public GCMParameters(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) throws InvalidAlgorithmParameterException {
        this.g = byArray2;
        this.h = n2;
        this.i = byArray;
        this.j = byArray3;
        if ((this.j == null || this.j.length == 0) && n2 == -1) {
            n2 = 12;
        } else {
            if (n2 == -1) {
                n2 = this.j.length;
            }
            if ((n2 < 12 || n2 > 16) && n2 != 4 && n2 != 8) {
                throw new InvalidAlgorithmParameterException("Invalid MAC length - valid length values: 4,8,12,13,14,15,16 bytes!");
            }
        }
        this.k = f;
    }

    protected byte[] engineGetEncoded() throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new OCTET_STRING(this.g));
        if (this.h != 12 || this.k) {
            sEQUENCE.addComponent(new INTEGER(this.h));
        }
        return DerCoder.encode(sEQUENCE);
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if ((b == null ? (b = GCMParameters.class$("iaik.security.cipher.GCMParameterSpec")) : b).isAssignableFrom(clazz)) {
            try {
                if (this.j == null) {
                    algorithmParameterSpec = new GCMParameterSpec(this.i, this.g, this.h);
                }
                algorithmParameterSpec = new GCMParameterSpec(this.i, this.g, this.j);
            }
            catch (Exception exception) {
                throw new InvalidParameterSpecException(exception.toString());
            }
        } else if (!c && "javax.crypto.spec.GCMParameterSpec".equals(clazz.getName())) {
            try {
                algorithmParameterSpec = GCMParameters.a(clazz, this.g, this.h);
            }
            catch (Exception exception) {
                throw new InvalidParameterSpecException("Can not convert to class javax.crypto.spec.GCMParameterSpec: " + exception.toString());
            }
        } else {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return algorithmParameterSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof GCMParameterSpec) {
            GCMParameterSpec gCMParameterSpec = (GCMParameterSpec)algorithmParameterSpec;
            this.g = gCMParameterSpec.getNonce();
            this.h = gCMParameterSpec.getMacLength();
            this.i = gCMParameterSpec.getAAD();
            this.j = gCMParameterSpec.getMac();
        } else if (!c && "javax.crypto.spec.GCMParameterSpec".equals(algorithmParameterSpec.getClass().getName())) {
            try {
                this.g = GCMParameters.a(algorithmParameterSpec);
                this.h = GCMParameters.b(algorithmParameterSpec);
            }
            catch (Exception exception) {
                throw new InvalidParameterSpecException("Error initiailizing from javax.crypto.spec.GCMParameterSpec: " + exception.toString());
            }
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            this.g = ((IvParameterSpec)algorithmParameterSpec).getIV();
        } else {
            throw new InvalidParameterSpecException("Can not initialize from class " + algorithmParameterSpec.getClass().getName());
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        block8: {
            this.k = false;
            try {
                ASN1Object aSN1Object = DerCoder.decode(byArray);
                if (aSN1Object.isA(ASN.SEQUENCE)) {
                    this.g = (byte[])aSN1Object.getComponentAt(0).getValue();
                    int n2 = aSN1Object.countComponents();
                    this.h = 12;
                    if (n2 == 2) {
                        this.h = ((BigInteger)aSN1Object.getComponentAt(1).getValue()).intValue();
                        if (this.h == 12) {
                            this.k = true;
                        }
                    } else if (n2 != 1) {
                        throw new IOException("Invalid number (" + n2 + ") of GCM parameter components. Must be 1 or 2!");
                    }
                    if ((this.h < 12 || this.h > 16) && this.h != 4 && this.h != 8) {
                        throw new IOException("Invalid MAC length - valid length values: 4,8,12,13,14,15,16 bytes!");
                    }
                    break block8;
                }
                throw new IOException("Cannot decode GCM params. Invalid ASN.1 type!");
            }
            catch (CodingException codingException) {
                throw new IOException("DER decoding error. " + codingException.toString());
            }
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AAD: " + (this.i != null ? Util.toString(this.i) : "null") + "\n");
        stringBuffer.append("nonce: " + (this.g != null ? Util.toString(this.g) : "null") + "\n");
        stringBuffer.append("macLength: " + this.h + "\n");
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            c = !System.getProperty("iaikjce.disableJava7GCMApiSupport", "false").toLowerCase(Locale.US).equals("false");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

