/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;

public class GCMParameterSpec
implements AlgorithmParameterSpec {
    private byte[] a;
    private byte[] b;
    private int c;
    private byte[] d;

    private static void a(int n2) throws InvalidAlgorithmParameterException {
        if ((n2 < 12 || n2 > 16) && n2 != 4 && n2 != 8) {
            throw new InvalidAlgorithmParameterException("Invalid MAC length - valid length values: 4,8,12,13,14,15,16 bytes!");
        }
    }

    public GCMParameterSpec(byte[] byArray, byte[] byArray2, int n2) throws InvalidAlgorithmParameterException {
        this(byArray, byArray2, null, n2);
    }

    public GCMParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3) throws InvalidAlgorithmParameterException {
        this(byArray, byArray2, byArray3, -1);
    }

    public GCMParameterSpec(byte[] byArray, byte[] byArray2) throws InvalidAlgorithmParameterException {
        this(byArray, byArray2, null, -1);
    }

    public GCMParameterSpec() throws InvalidAlgorithmParameterException {
        this(null, null, null, -1);
    }

    private GCMParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) throws InvalidAlgorithmParameterException {
        this.a = byArray;
        this.b = byArray2;
        this.d = byArray3;
        this.c = n2;
        if ((this.d == null || this.d.length == 0) && this.c == -1) {
            this.c = 12;
        } else {
            if (this.c == -1) {
                this.c = this.d.length;
            }
            GCMParameterSpec.a(this.c);
        }
    }

    public void setMacLength(int n2) throws InvalidAlgorithmParameterException {
        GCMParameterSpec.a(n2);
        this.c = n2;
    }

    void setMac(byte[] byArray) {
        if ((byArray == null || byArray.length == 0) && this.c == -1) {
            this.c = 12;
        } else if (this.c == -1) {
            int n2 = byArray.length;
            try {
                GCMParameterSpec.a(n2);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
            }
            this.c = n2;
        }
        this.d = byArray;
    }

    public byte[] getAAD() {
        return this.a;
    }

    public int getMacLength() {
        return this.c;
    }

    public byte[] getNonce() {
        return this.b;
    }

    public byte[] getMac() {
        return this.d;
    }
}

