/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.security.cipher.ChaCha20ParameterSpec;
import iaik.security.cipher.ChaCha20Poly1305CMSParameterSpec;
import iaik.security.cipher.ChaCha20Poly1305ParameterSpec;
import iaik.utils.Util;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class ChaCha20Poly1305Parameters
extends AlgorithmParametersSpi {
    byte[] a;
    byte[] b;
    int c;
    private byte[] h;
    static Class d;
    static Class e;
    static Class f;
    static Class g;

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof ChaCha20Poly1305ParameterSpec) {
            this.a = ((ChaCha20Poly1305ParameterSpec)algorithmParameterSpec).getAAD();
            this.b = ((ChaCha20Poly1305ParameterSpec)algorithmParameterSpec).getIV();
            this.c = ((ChaCha20ParameterSpec)algorithmParameterSpec).getBlockCounter();
            if (algorithmParameterSpec instanceof ChaCha20Poly1305CMSParameterSpec) {
                this.h = ((ChaCha20Poly1305CMSParameterSpec)algorithmParameterSpec).getMac();
            }
        } else if (algorithmParameterSpec instanceof ChaCha20ParameterSpec) {
            this.b = ((ChaCha20ParameterSpec)algorithmParameterSpec).getIV();
            this.c = ((ChaCha20ParameterSpec)algorithmParameterSpec).getBlockCounter();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            IvParameterSpec ivParameterSpec = (IvParameterSpec)algorithmParameterSpec;
            this.b = ivParameterSpec.getIV();
        } else {
            throw new InvalidParameterSpecException("Can not initialize from class " + algorithmParameterSpec.getClass().getName());
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        block4: {
            try {
                ASN1Object aSN1Object = DerCoder.decode(byArray);
                if (aSN1Object.isA(ASN.OCTET_STRING)) {
                    this.b = (byte[])aSN1Object.getValue();
                    if (this.b.length != 12) {
                        throw new IOException("Invalid nonce length - must be 12 bytes!");
                    }
                    break block4;
                }
                throw new IOException("Cannot decode ChaCha20Poly1305 params. Invalid ASN.1 type!");
            }
            catch (CodingException codingException) {
                throw new IOException("DER decoding error. " + codingException.toString());
            }
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        void var2_7;
        Object var2_2 = null;
        if ((d == null ? (d = ChaCha20Poly1305Parameters.class$("iaik.security.cipher.ChaCha20Poly1305CMSParameterSpec")) : d).isAssignableFrom(clazz)) {
            try {
                ChaCha20Poly1305CMSParameterSpec chaCha20Poly1305CMSParameterSpec = new ChaCha20Poly1305CMSParameterSpec(this.a, this.b);
                if (this.c > 0) {
                    ((ChaCha20Poly1305ParameterSpec)chaCha20Poly1305CMSParameterSpec).a(this.c);
                }
                if (this.h == null) return var2_7;
                chaCha20Poly1305CMSParameterSpec.setMac(this.h);
                return var2_7;
            }
            catch (Exception exception) {
                throw new InvalidParameterSpecException(exception.toString());
            }
        } else if ((e == null ? (e = ChaCha20Poly1305Parameters.class$("iaik.security.cipher.ChaCha20Poly1305ParameterSpec")) : e).isAssignableFrom(clazz)) {
            try {
                ChaCha20Poly1305ParameterSpec chaCha20Poly1305ParameterSpec = new ChaCha20Poly1305ParameterSpec(this.a, this.b);
                if (this.c <= 0) return var2_7;
                chaCha20Poly1305ParameterSpec.a(this.c);
                return var2_7;
            }
            catch (Exception exception) {
                throw new InvalidParameterSpecException(exception.toString());
            }
        } else if ((f == null ? (f = ChaCha20Poly1305Parameters.class$("iaik.security.cipher.ChaCha20ParameterSpec")) : f).isAssignableFrom(clazz)) {
            try {
                ChaCha20ParameterSpec chaCha20ParameterSpec = new ChaCha20ParameterSpec(this.b);
                if (this.c <= 0) return var2_7;
                chaCha20ParameterSpec.a(this.c);
                return var2_7;
            }
            catch (Exception exception) {
                throw new InvalidParameterSpecException(exception.toString());
            }
        } else {
            if (!(g == null ? (g = ChaCha20Poly1305Parameters.class$("javax.crypto.spec.IvParameterSpec")) : g).isAssignableFrom(clazz)) return var2_7;
            IvParameterSpec ivParameterSpec = new IvParameterSpec(this.b);
        }
        return var2_7;
    }

    protected byte[] engineGetEncoded() throws IOException {
        OCTET_STRING oCTET_STRING = new OCTET_STRING(this.b);
        return DerCoder.encode(oCTET_STRING);
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("aad: " + (this.a != null ? Util.toString(this.a) : "null") + "\n");
        stringBuffer.append("nonce: " + (this.b != null ? Util.toString(this.b) : "null") + "\n");
        stringBuffer.append("blockCounter: " + this.c + "\n");
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

