/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.security.cipher.CCMParameterSpec;
import iaik.utils.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class CCMParameters
extends AlgorithmParametersSpi {
    private static boolean a = true;
    private static boolean b = false;
    private byte[] c;
    private int d;
    private byte[] e;
    private boolean f;

    public static void setIncludeDefaultMacLengthInEncding(boolean bl) {
        b = bl;
    }

    public static void checkKeyAndNonceReuse(boolean bl) {
        a = bl;
    }

    static boolean a() {
        return a;
    }

    public CCMParameters() throws InvalidAlgorithmParameterException {
        this(null, null, -1);
    }

    public CCMParameters(byte[] byArray, byte[] byArray2, int n2) throws InvalidAlgorithmParameterException {
        this.c = byArray2;
        this.d = n2;
        this.e = byArray;
        if (n2 == -1) {
            n2 = 12;
        }
        if (n2 < 4 || n2 > 16) {
            throw new InvalidAlgorithmParameterException("Specified MAC-length not between 4 and 16 bytes!");
        }
        this.f = b;
    }

    protected byte[] engineGetEncoded() throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new OCTET_STRING(this.c));
        if (this.d != 12 || this.f) {
            sEQUENCE.addComponent(new INTEGER(this.d));
        }
        return DerCoder.encode(sEQUENCE);
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        CCMParameterSpec cCMParameterSpec;
        try {
            cCMParameterSpec = new CCMParameterSpec(-1L, this.e, this.c, this.d);
        }
        catch (Exception exception) {
            throw new InvalidParameterSpecException(exception.toString());
        }
        if (!cCMParameterSpec.getClass().isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return cCMParameterSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof CCMParameterSpec) {
            CCMParameterSpec cCMParameterSpec = (CCMParameterSpec)algorithmParameterSpec;
            this.c = cCMParameterSpec.getNonce();
            this.d = cCMParameterSpec.getMacLength();
            this.e = cCMParameterSpec.getAssociatedData();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            this.c = ((IvParameterSpec)algorithmParameterSpec).getIV();
            if (this.c.length < 7 || this.c.length > 13) {
                throw new InvalidParameterSpecException("nonce length not between 7 and 13 bytes!");
            }
        } else {
            throw new InvalidParameterSpecException("Can not initialize from class " + algorithmParameterSpec.getClass().getName());
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        block9: {
            try {
                ASN1Object aSN1Object = DerCoder.decode(byArray);
                if (aSN1Object.isA(ASN.SEQUENCE)) {
                    this.c = (byte[])aSN1Object.getComponentAt(0).getValue();
                    if (this.c.length < 7 || this.c.length > 13) {
                        throw new IOException("nonce length not between 7 and 13 bytes!");
                    }
                    int n2 = aSN1Object.countComponents();
                    this.d = 12;
                    if (n2 == 2) {
                        this.d = ((BigInteger)aSN1Object.getComponentAt(1).getValue()).intValue();
                        if (this.d == 12) {
                            this.f = true;
                        }
                    } else if (n2 != 1) {
                        throw new IOException("Invalid number (" + n2 + ") of CCM parameter components. Must be 1 or 2!");
                    }
                    if (this.d < 4 || this.d > 16) {
                        throw new IOException("Specified MAC-length not between 4 and 16 bytes!");
                    }
                    break block9;
                }
                throw new IOException("Cannot decode CCM params. Invalid ASN.1 type!");
            }
            catch (CodingException codingException) {
                throw new IOException("DER decoding error. " + codingException.toString());
            }
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("associatedData: " + (this.e != null ? Util.toString(this.e) : "null") + "\n");
        stringBuffer.append("nonce: " + (this.c != null ? Util.toString(this.c) : "null") + "\n");
        stringBuffer.append("macLength: " + this.d + "\n");
        return stringBuffer.toString();
    }
}

