/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.security.random.SecRandom;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class CCMParameterSpec
implements AlgorithmParameterSpec {
    private byte[] a;
    private byte[] b;
    private int c;
    private long d;

    public CCMParameterSpec(long l2, byte[] byArray, byte[] byArray2, int n2) throws InvalidAlgorithmParameterException {
        this.a = byArray;
        this.b = byArray2;
        this.c = n2;
        this.d = l2;
        if (this.b == null || this.b.length == 0) {
            this.b = this.d > -1L ? (this.d < Integer.MAX_VALUE ? new byte[11] : new byte[7]) : new byte[7];
            SecureRandom secureRandom = SecRandom.getDefault();
            secureRandom.nextBytes(this.b);
        } else if (this.b.length < 7 || this.b.length > 13) {
            throw new InvalidAlgorithmParameterException("nonce length not between 7 and 13 bytes!");
        }
        if (this.d != -1L) {
            if (this.d < -1L) {
                throw new InvalidAlgorithmParameterException("invalid value for inputLength");
            }
            long l3 = (long)(Math.pow(2.0, 8 * (15 - this.b.length)) - 1.0);
            if (this.d - (long)this.c > l3) {
                throw new InvalidAlgorithmParameterException("parameter inputLength or nonce too long");
            }
        }
        if (this.c == -1) {
            this.c = 12;
        } else if (this.c < 4 || this.c > 16) {
            throw new InvalidAlgorithmParameterException("Specified MAC-length not between 4 and 16 bytes!");
        }
    }

    public CCMParameterSpec(long l2, byte[] byArray, byte[] byArray2) throws Exception {
        this(l2, byArray, byArray2, -1);
    }

    public CCMParameterSpec(byte[] byArray, byte[] byArray2, int n2) throws Exception {
        this(-1L, byArray, byArray2, n2);
    }

    public CCMParameterSpec(byte[] byArray, byte[] byArray2) throws Exception {
        this(-1L, byArray, byArray2, -1);
    }

    public CCMParameterSpec() throws Exception {
        this(-1L, null, null, -1);
    }

    public void setInputLength(long l2) throws InvalidAlgorithmParameterException {
        this.d = l2;
        if (l2 < 0L) {
            throw new InvalidAlgorithmParameterException("invalid value for inputLength");
        }
        long l3 = (long)(Math.pow(2.0, 8 * (15 - this.b.length)) - 1.0);
        if (l2 - (long)this.c > l3) {
            throw new InvalidAlgorithmParameterException("parameter inputLength or nonce too long");
        }
    }

    public void setMacLength(int n2) throws InvalidAlgorithmParameterException {
        this.c = n2;
        if (n2 < 4 || n2 > 16) {
            throw new InvalidAlgorithmParameterException("Specified MAC-length not between 4 and 16 bytes!");
        }
    }

    public byte[] getAssociatedData() {
        return this.a;
    }

    public int getMacLength() {
        return this.c;
    }

    public byte[] getNonce() {
        return this.b;
    }

    public long getInputLength() {
        return this.d;
    }
}

