/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.security.cipher.CBCCMacParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class CBCCMacParameters
extends AlgorithmParametersSpi {
    private CBCCMacParameterSpec c;
    static Class a;
    static Class b;

    protected byte[] engineGetEncoded() throws IOException {
        if (this.c == null) {
            throw new IOException("Parameters not intialized yet!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new OCTET_STRING(this.c.getIV()));
        int n2 = this.c.getMacLength();
        if (n2 != 16) {
            sEQUENCE.addComponent(new INTEGER(n2));
        }
        return DerCoder.encode(sEQUENCE);
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        CBCCMacParameterSpec cBCCMacParameterSpec = null;
        if (!(a == null ? (a = CBCCMacParameters.class$("iaik.security.cipher.CBCCMacParameterSpec")) : a).isAssignableFrom(clazz) && !(b == null ? (b = CBCCMacParameters.class$("javax.crypto.spec.IvParameterSpec")) : b).isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        cBCCMacParameterSpec = this.c;
        return cBCCMacParameterSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (algorithmParameterSpec instanceof CBCCMacParameterSpec) {
            this.c = (CBCCMacParameterSpec)algorithmParameterSpec;
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            try {
                this.c = new CBCCMacParameterSpec(null, ((IvParameterSpec)algorithmParameterSpec).getIV());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidParameterSpecException(invalidAlgorithmParameterException.getMessage());
            }
        } else {
            throw new InvalidParameterSpecException("Can not initialize from class " + algorithmParameterSpec.getClass().getName());
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        block9: {
            try {
                ASN1Object aSN1Object = DerCoder.decode(byArray);
                if (aSN1Object.isA(ASN.SEQUENCE)) {
                    byte[] byArray2 = (byte[])aSN1Object.getComponentAt(0).getValue();
                    int n2 = 16;
                    int n3 = aSN1Object.countComponents();
                    if (n3 == 2) {
                        n2 = ((BigInteger)aSN1Object.getComponentAt(1).getValue()).intValue();
                    } else if (n3 != 1) {
                        throw new IOException("Invalid number (" + n3 + ") of AES-CBC-CMAC parameter components. Must be 1 or 2!");
                    }
                    if (n2 < 12 || n2 > 16) {
                        throw new IOException("Invalid MAC length - valid length values: 12,13,14,15,16 bytes!");
                    }
                    try {
                        this.c = new CBCCMacParameterSpec(byArray2, n2);
                        break block9;
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        throw new IOException(invalidAlgorithmParameterException.getMessage());
                    }
                }
                throw new IOException("Cannot decode AES-CBC-CMAC params. Invalid ASN.1 type!");
            }
            catch (CodingException codingException) {
                throw new IOException("DER decoding error. " + codingException.toString());
            }
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return this.c == null ? "" : this.c.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

