/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.utils.Util;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import javax.crypto.spec.IvParameterSpec;

public class CBCCMacParameterSpec
extends IvParameterSpec {
    private byte[] a;
    private int b;
    private byte[] c;

    public CBCCMacParameterSpec(byte[] byArray, int n2) throws InvalidAlgorithmParameterException {
        this(byArray, null, n2);
    }

    public CBCCMacParameterSpec(byte[] byArray, byte[] byArray2) throws InvalidAlgorithmParameterException {
        this(byArray, byArray2, -1);
    }

    public CBCCMacParameterSpec(byte[] byArray) throws InvalidAlgorithmParameterException {
        this(byArray, null, -1);
    }

    public CBCCMacParameterSpec() throws InvalidAlgorithmParameterException {
        this(null, null, -1);
    }

    private CBCCMacParameterSpec(byte[] byArray, byte[] byArray2, int n2) throws InvalidAlgorithmParameterException {
        super(byArray == null ? new byte[16] : byArray);
        this.c = byArray2;
        if ((this.c == null || this.c.length == 0) && n2 == -1) {
            this.b = 16;
        } else {
            if (n2 == -1) {
                n2 = this.c.length;
            }
            this.setMacLength(n2);
        }
    }

    public void setMacLength(int n2) throws InvalidAlgorithmParameterException {
        if (n2 < 12 || n2 > 16) {
            throw new InvalidAlgorithmParameterException("Invalid MAC length - valid length values: 12,13,14,15,16 bytes!");
        }
        this.b = n2;
    }

    public void setMac(byte[] byArray) {
        if ((byArray == null || byArray.length == 0) && this.b == -1) {
            this.b = 16;
        } else if (this.b == -1) {
            try {
                this.setMacLength(this.c.length);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidParameterException(invalidAlgorithmParameterException.getMessage());
            }
        }
        this.c = byArray;
    }

    public void setAAD(byte[] byArray) {
        this.a = byArray;
    }

    public byte[] getAAD() {
        return this.a;
    }

    public int getMacLength() {
        return this.b;
    }

    public byte[] getMac() {
        return this.c;
    }

    protected String engineToString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("AAD: " + Util.toString(this.a) + "\n");
        }
        byte[] byArray = this.getIV();
        stringBuffer.append("iv: " + Util.toString(byArray) + "\n");
        if (this.c != null) {
            stringBuffer.append("mac: (" + this.b + " bytes): " + Util.toString(this.c) + "\n");
        } else {
            stringBuffer.append("macLength: " + this.b + "\n");
        }
        return stringBuffer.toString();
    }
}

