/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs9;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AttributeValue;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.X509ExtensionInitException;
import iaik.x509.X509Extensions;
import java.util.Enumeration;
import java.util.Set;

public class ExtensionRequest
extends AttributeValue {
    private X509Extensions a;
    public static final ObjectID oid = ObjectID.extensionRequest;

    public ExtensionRequest() {
    }

    public ExtensionRequest(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            this.a = new X509Extensions(aSN1Object);
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CodingException("Error decoding extensions: " + x509ExtensionException.toString());
        }
    }

    public ASN1Object toASN1Object() throws CodingException {
        if (this.a == null || this.a.countExtensions() == 0) {
            throw new CodingException("Extensions SEQUENCE is not allowed to be empty.");
        }
        try {
            return this.a.toASN1Object();
        }
        catch (X509ExtensionException x509ExtensionException) {
            throw new CodingException("Error encoding extensions: " + x509ExtensionException.toString());
        }
    }

    public ObjectID getAttributeType() {
        return oid;
    }

    public Set getCriticalExtensionOIDs() {
        return this.a == null ? null : this.a.getCriticalExtensionOIDs();
    }

    public Set getNonCriticalExtensionOIDs() {
        return this.a == null ? null : this.a.getNonCriticalExtensionOIDs();
    }

    public byte[] getExtensionValue(String string) {
        return this.a == null ? null : this.a.getExtensionValue(string);
    }

    public byte[] getRawExtensionValue(String string) {
        return this.a == null ? null : this.a.getRawExtensionValue(string);
    }

    public void addExtension(V3Extension v3Extension) throws X509ExtensionException {
        if (this.a == null) {
            this.a = new X509Extensions(4, 4);
        }
        this.a.addExtension(v3Extension);
    }

    public boolean removeExtension(ObjectID objectID) {
        return this.a == null ? false : this.a.removeExtension(objectID);
    }

    public void removeAllExtensions() {
        if (this.a != null) {
            this.a.removeAllExtensions();
        }
        this.a = null;
    }

    public Enumeration listExtensions() {
        return this.a == null ? null : this.a.listExtensions();
    }

    public boolean hasExtensions() {
        return this.a == null ? false : this.a.hasExtensions();
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.a == null ? false : this.a.hasUnsupportedCriticalExtension();
    }

    public int countExtensions() {
        return this.a == null ? 0 : this.a.countExtensions();
    }

    public V3Extension getExtension(ObjectID objectID) throws X509ExtensionInitException {
        return this.a == null ? null : this.a.getExtension(objectID);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append(this.a);
        }
        return stringBuffer.toString();
    }
}

