/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs8;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs8.RawPrivateKey;
import iaik.security.provider.IAIK;
import iaik.utils.CryptoUtils;
import iaik.utils.IaikSecurity;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;

public abstract class PrivateKeyInfo
implements ASN1Type,
Cloneable,
PrivateKey {
    private static final long serialVersionUID = -4061451773521226425L;
    int a = 0;
    ASN1 b;
    private PublicKey c;
    private Attribute[] d;
    protected AlgorithmID private_key_algorithm;
    static Class m;

    protected PrivateKeyInfo() {
    }

    public PrivateKeyInfo(ASN1Object aSN1Object) throws InvalidKeyException {
        try {
            this.b = new ASN1(aSN1Object);
            this.a();
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + codingException.toString());
        }
    }

    public PrivateKeyInfo(InputStream inputStream) throws InvalidKeyException, IOException {
        try {
            this.b = new ASN1(inputStream);
            this.a();
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("No PrivateKeyInfo: " + codingException.toString());
        }
    }

    public PrivateKeyInfo(byte[] byArray) throws InvalidKeyException {
        try {
            this.b = new ASN1(byArray);
            this.a();
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("Error parsing PrivateKeyInfo: " + codingException.toString());
        }
    }

    protected abstract void decode(byte[] var1) throws InvalidKeyException;

    protected abstract byte[] encode();

    public abstract String getAlgorithm();

    public AlgorithmID getAlgorithmID() {
        return this.private_key_algorithm;
    }

    public void setAttributes(Attribute[] attributeArray) {
        boolean bl = this.d == null && attributeArray != null || this.d != null && attributeArray == null;
        this.d = attributeArray;
        if (bl) {
            this.createPrivateKeyInfo();
        }
    }

    public Attribute[] getAttributes() {
        return this.d;
    }

    public void setPubKey(PublicKey publicKey) throws InvalidKeyException {
        boolean bl = this.c == null && publicKey != null || this.c != null && publicKey == null;
        this.c = publicKey;
        if (publicKey != null) {
            String string = publicKey.getAlgorithm();
            if (!string.equals(this.getAlgorithm())) {
                throw new InvalidKeyException("Invalid public key algorithm (" + string + ". Expected " + this.getAlgorithm() + "!");
            }
            this.a = 1;
        } else {
            this.a = 0;
        }
        if (bl) {
            this.createPrivateKeyInfo();
        }
    }

    public PublicKey getPubKey() {
        return this.c;
    }

    public Object clone() {
        PrivateKeyInfo privateKeyInfo = null;
        try {
            privateKeyInfo = (PrivateKeyInfo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return privateKeyInfo;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.b = new ASN1(aSN1Object);
        try {
            this.a();
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CodingException(invalidKeyException.toString());
        }
    }

    private void a() throws InvalidKeyException {
        try {
            int n2 = this.b.countComponents();
            if (n2 < 3 || n2 > 5) {
                throw new InvalidKeyException("ASN.1 representation of key contains invalid number of components (" + n2 + ")! Must be 3, 4, or 5.");
            }
            ASN1Object aSN1Object = this.b.getComponentAt(0);
            if (!aSN1Object.isA(ASN.INTEGER)) {
                throw new InvalidKeyException("version component must be ASN.1 INTEGER!");
            }
            this.a = ((BigInteger)aSN1Object.getValue()).intValue();
            if (this.a != 0 && this.a != 1) {
                throw new InvalidKeyException("Invalid version number (" + this.a + "). Must be 0 or 1!");
            }
            this.private_key_algorithm = new AlgorithmID(this.b.getComponentAt(1));
            byte[] byArray = (byte[])this.b.getComponentAt(2).getValue();
            if (n2 > 3) {
                for (int i2 = 3; i2 < n2; ++i2) {
                    Object object;
                    ASN1Object aSN1Object2 = this.b.getComponentAt(i2);
                    if (!aSN1Object2.isA(ASN.CON_SPEC)) {
                        throw new InvalidKeyException("Invalid optional component. Must be CON_SPEC!");
                    }
                    CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object2;
                    int n3 = cON_SPEC.getAsnType().getTag();
                    if (n3 == 0) {
                        if (this.c != null) {
                            throw new InvalidKeyException("attributes field must be before publicKey field!");
                        }
                        object = cON_SPEC.getValue();
                        if (!(object instanceof ASN1Object) || !((ASN1Object)object).isA(ASN.SET)) {
                            cON_SPEC.forceImplicitlyTagged(ASN.SET);
                        }
                        if (!(aSN1Object2 = (ASN1Object)cON_SPEC.getValue()).isA(ASN.SET)) {
                            throw new InvalidKeyException("attributes must be ASN.1 SET!");
                        }
                        this.d = (Attribute[])ASN.parseSequenceOf(aSN1Object2, m == null ? PrivateKeyInfo.class$("iaik.asn1.structures.Attribute") : m);
                        continue;
                    }
                    if (n3 == 1) {
                        object = cON_SPEC.getValue();
                        if (!(object instanceof ASN1Object) || !((ASN1Object)object).isA(ASN.BIT_STRING)) {
                            cON_SPEC.forceImplicitlyTagged(ASN.BIT_STRING);
                        }
                        if (!(aSN1Object2 = (ASN1Object)cON_SPEC.getValue()).isA(ASN.BIT_STRING)) {
                            throw new InvalidKeyException("publicKey must be ASN.1 BIT_STRING!");
                        }
                        SEQUENCE sEQUENCE = new SEQUENCE();
                        sEQUENCE.addComponent(this.private_key_algorithm.toASN1Object());
                        sEQUENCE.addComponent(aSN1Object2);
                        this.c = PublicKeyInfo.getPublicKey(sEQUENCE);
                        continue;
                    }
                    throw new PKCSParsingException("Unsupported context specific tag: " + n3 + ". Must be 0 or 1!");
                }
            }
            this.decode(byArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Invalid PrivateKeyInfo: " + exception.toString());
        }
        if (this.a == 1) {
            if (this.c == null) {
                throw new InvalidKeyException("Invalid PrivateKeyInfo: version 1 but publicKey not included!");
            }
        } else if (this.c != null) {
            throw new InvalidKeyException("Invalid PrivateKeyInfo: version 0 but publicKey included!");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.getEncoded());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.b = new ASN1(objectInputStream);
            this.a();
        }
        catch (CodingException codingException) {
            throw new IOException("Unable to restore PrivateKeyInfo: " + codingException.toString());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new IOException("Unable to restore PrivateKeyInfo: " + invalidKeyException.toString());
        }
    }

    protected void createPrivateKeyInfo() {
        SEQUENCE sEQUENCE = null;
        try {
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.a));
            sEQUENCE.addComponent(this.private_key_algorithm.toASN1Object());
            sEQUENCE.addComponent(new OCTET_STRING(this.encode()));
            if (this.d != null) {
                sEQUENCE.addComponent(new CON_SPEC(0, ASN.createSetOf(this.d), true));
            }
            if (this.c != null) {
                SEQUENCE sEQUENCE2 = null;
                sEQUENCE2 = this.c instanceof PublicKeyInfo ? (SEQUENCE)((PublicKeyInfo)this.c).toASN1Object() : (SEQUENCE)DerCoder.decode(this.c.getEncoded());
                sEQUENCE.addComponent(new CON_SPEC(1, sEQUENCE2.getComponentAt(1), true));
            }
            this.b = new ASN1(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException("CodingException!");
        }
    }

    public static PrivateKey getPrivateKey(ASN1Object aSN1Object) throws InvalidKeyException {
        return PrivateKeyInfo.a(aSN1Object, null, null);
    }

    public static PrivateKey getPrivateKey(ASN1Object aSN1Object, String string) throws InvalidKeyException {
        return PrivateKeyInfo.a(aSN1Object, string, null);
    }

    public static PrivateKey getPrivateKey(ASN1Object aSN1Object, Provider provider) throws InvalidKeyException {
        return PrivateKeyInfo.a(aSN1Object, null, provider);
    }

    private static PrivateKey a(ASN1Object aSN1Object, String string, Provider provider) throws InvalidKeyException {
        boolean bl;
        AlgorithmID algorithmID = null;
        PrivateKey privateKey = null;
        boolean bl2 = bl = string == null && provider == null && IaikSecurity.getTryIAIKProviderFirst();
        if (bl) {
            provider = IAIK.getInstance();
        }
        try {
            if (!aSN1Object.isA(ASN.SEQUENCE)) {
                throw new InvalidKeyException("PublicKeyInfo must be ASN.1 SEQUENCE!");
            }
            int n2 = aSN1Object.countComponents();
            if (n2 < 3) {
                throw new InvalidKeyException("Invalid number (" + n2 + "). Must be at least 3!");
            }
            algorithmID = new AlgorithmID(aSN1Object.getComponentAt(1));
            KeyFactory keyFactory = null;
            try {
                keyFactory = provider != null ? algorithmID.getKeyFactoryInstance(provider) : algorithmID.getKeyFactoryInstance(string);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (bl) {
                    keyFactory = algorithmID.getKeyFactoryInstance(string);
                }
                throw noSuchAlgorithmException;
            }
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(DerCoder.encode(aSN1Object));
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            privateKey = new RawPrivateKey(aSN1Object);
        }
        catch (Exception exception) {
            throw new InvalidKeyException("Cannot parse PrivateKeyInfo: " + exception.toString(), exception){
                private static final long serialVersionUID = 7538788305199067976L;
                private final Exception a;
                {
                    this.a = exception;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
        return privateKey;
    }

    public static PrivateKey getPrivateKey(byte[] byArray) throws InvalidKeyException {
        return PrivateKeyInfo.getPrivateKey(byArray, (String)null);
    }

    public static PrivateKey getPrivateKey(byte[] byArray, String string) throws InvalidKeyException {
        try {
            return PrivateKeyInfo.getPrivateKey(DerCoder.decode(byArray), string);
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("Can't parse PrivateKeyInfo: " + codingException.toString());
        }
    }

    public static PrivateKey getPrivateKey(byte[] byArray, Provider provider) throws InvalidKeyException {
        try {
            return PrivateKeyInfo.getPrivateKey(DerCoder.decode(byArray), provider);
        }
        catch (CodingException codingException) {
            throw new InvalidKeyException("Can't parse PrivateKeyInfo: " + codingException.toString());
        }
    }

    public ASN1Object toASN1Object() {
        return this.b.toASN1Object();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PrivateKey)) {
            return false;
        }
        return CryptoUtils.secureEqualsBlock(this.getEncoded(), ((PrivateKey)object).getEncoded());
    }

    public int hashCode() {
        return Util.calculateHashCode(this.getEncoded());
    }

    public byte[] getEncoded() {
        return this.b.toByteArray(true);
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.b.writeTo(outputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("This PrivateKeyInfo contains a ");
        stringBuffer.append(this.private_key_algorithm.getName() + " key.");
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

