/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs8;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.SEQUENCE;
import iaik.pkcs.pkcs8.PrivateKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AsymmetricKeyPackage
implements ASN1Type {
    private List a = new ArrayList();

    private AsymmetricKeyPackage() {
    }

    public AsymmetricKeyPackage(PrivateKey privateKey) throws InvalidKeyException {
        this();
        if (privateKey == null) {
            throw new NullPointerException("key must not be null!");
        }
        this.addKey(privateKey);
    }

    public AsymmetricKeyPackage(PrivateKey[] privateKeyArray) throws InvalidKeyException {
        this();
        if (privateKeyArray == null) {
            throw new NullPointerException("key must not be null!");
        }
        this.addKeys(privateKeyArray);
    }

    public AsymmetricKeyPackage(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public AsymmetricKeyPackage(InputStream inputStream) throws CodingException, IOException {
        this();
        ASN1 aSN1 = new ASN1(inputStream);
        this.decode(aSN1.toASN1Object());
    }

    public AsymmetricKeyPackage(byte[] byArray) throws CodingException {
        this();
        ASN1 aSN1 = new ASN1(byArray);
        this.decode(aSN1.toASN1Object());
    }

    public void addKey(PrivateKey privateKey) throws InvalidKeyException {
        if (privateKey != null) {
            String string = privateKey.getFormat();
            if (!"PKCS#8".equals(string)) {
                throw new InvalidKeyException("Invalid key format (" + string + ". Expected " + "PKCS#8");
            }
            this.a.add(privateKey);
        }
    }

    public void addKeys(PrivateKey[] privateKeyArray) throws InvalidKeyException {
        if (privateKeyArray != null) {
            for (int i2 = 0; i2 < privateKeyArray.length; ++i2) {
                this.addKey(privateKeyArray[i2]);
            }
        }
    }

    public PrivateKey[] getKeys() {
        return this.a.toArray(new PrivateKey[0]);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("ASN.1 AsymmetricKeyPackage must be SEQUENCE OF!");
        }
        int n2 = aSN1Object.countComponents();
        if (n2 < 1) {
            throw new CodingException("AsymmetricKeyPackage must not be empty!");
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            ASN1Object aSN1Object2 = aSN1Object.getComponentAt(i2);
            if (!aSN1Object2.isA(ASN.SEQUENCE)) {
                throw new CodingException("ASN.1 OneAsymmetricKey/PrivateKeyInfo must be SEQUENCE!");
            }
            try {
                PrivateKey privateKey = PrivateKeyInfo.getPrivateKey(aSN1Object2);
                this.a.add(privateKey);
                continue;
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CodingException(invalidKeyException.toString());
            }
        }
    }

    public ASN1Object toASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a.isEmpty()) {
            throw new CodingException("Empty key list!");
        }
        Iterator iterator = this.a.iterator();
        while (iterator.hasNext()) {
            PrivateKey privateKey = (PrivateKey)iterator.next();
            if (privateKey instanceof PrivateKeyInfo) {
                ((ASN1Object)sEQUENCE).addComponent(((PrivateKeyInfo)privateKey).toASN1Object());
                continue;
            }
            byte[] byArray = privateKey.getEncoded();
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            ((ASN1Object)sEQUENCE).addComponent(aSN1Object);
        }
        return sEQUENCE;
    }

    public byte[] getEncoded() throws CodingException {
        return DerCoder.encode(this.toASN1Object());
    }

    public void writeTo(OutputStream outputStream) throws IOException, CodingException {
        outputStream.write(this.getEncoded());
    }

    public String toString() {
        return "This AsymmetricKeyPackage contains " + this.a.size() + " keys.";
    }
}

