/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.EncryptedContentInfoStream;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.pkcs.pkcs7.SignedDataStream;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.security.provider.IAIK;
import iaik.utils.CryptoUtils;
import iaik.utils.IaikSecurity;
import iaik.utils.NotifyEOFInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SignedAndEnvelopedDataStream
extends SignedDataStream {
    RecipientInfo[] a;
    EncryptedContentInfoStream b;
    SecretKey c;
    static Class d;
    static Class e;

    protected SignedAndEnvelopedDataStream() {
        this.version = 1;
    }

    public SignedAndEnvelopedDataStream(InputStream inputStream, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        this(inputStream, algorithmID, -1);
    }

    public SignedAndEnvelopedDataStream(InputStream inputStream, AlgorithmID algorithmID, int n2) throws NoSuchAlgorithmException {
        this();
        this.input_stream = inputStream;
        this.b = new EncryptedContentInfoStream(ObjectID.pkcs7_data, this.input_stream);
        this.c = this.b.setupCipher(algorithmID, n2);
    }

    public SignedAndEnvelopedDataStream(InputStream inputStream) throws PKCSParsingException, IOException {
        this();
        this.decode(inputStream);
    }

    public void decode(InputStream inputStream) throws IOException, PKCSParsingException {
        this.i = false;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        this.this_object = ((DerInputStream)inputStream).readSequence();
        this.version = this.this_object.readInteger().intValue();
        try {
            this.a = (RecipientInfo[])ASN.parseSequenceOf(DerCoder.decode(this.this_object), d == null ? (d = SignedAndEnvelopedDataStream.class$("iaik.pkcs.pkcs7.RecipientInfo")) : d);
            this.h.a((AlgorithmID[])ASN.parseSequenceOf(DerCoder.decode(this.this_object), e == null ? (e = SignedAndEnvelopedDataStream.class$("iaik.asn1.structures.AlgorithmID")) : e));
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException("Error parsing recipient infos!");
        }
        this.b = new EncryptedContentInfoStream(this.this_object);
        this.content_type = this.b.getContentType();
        if (!this.b.hasContent()) {
            this.notifyEOF();
            return;
        }
    }

    public void setupCipher(PrivateKey privateKey, int n2) throws PKCSException, NoSuchAlgorithmException, InvalidKeyException {
        this.c = this.a[n2].decryptKey(privateKey);
        this.b.setupCipher(this.c);
        this.input_stream = this.b.getInputStream();
        this.input_stream = this.h.a(this.input_stream, true);
        this.input_stream = new NotifyEOFInputStream(this.input_stream);
        ((NotifyEOFInputStream)this.input_stream).addEOFListener(this);
    }

    public ObjectID getContentType() {
        return ObjectID.pkcs7_signedAndEnvelopedData;
    }

    public void setRecipientInfos(RecipientInfo[] recipientInfoArray) {
        this.a = recipientInfoArray;
    }

    public void addRecipientInfo(RecipientInfo recipientInfo) {
        if (recipientInfo == null) {
            return;
        }
        if (this.a == null) {
            this.a = new RecipientInfo[]{recipientInfo};
            return;
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[this.a.length + 1];
        System.arraycopy(this.a, 0, recipientInfoArray, 0, this.a.length);
        recipientInfoArray[this.a.length] = recipientInfo;
        this.a = recipientInfoArray;
    }

    public void verify(PublicKey publicKey, int n2) throws SignatureException {
        if (n2 < 0 || n2 >= this.signer_infos.size()) {
            throw new SignatureException("SignerInfo does not exist. Wrong index.");
        }
        SignerInfo signerInfo = (SignerInfo)this.signer_infos.elementAt(n2);
        ASN1Type[] aSN1TypeArray = signerInfo.getAuthenticatedAttributes();
        try {
            Object object;
            Object object2;
            byte[] byArray;
            AlgorithmID algorithmID = signerInfo.getDigestAlgorithm();
            byte[] byArray2 = this.getMessageDigest(algorithmID);
            if (aSN1TypeArray != null) {
                byArray = this.getSignedDigest(n2);
                if (!CryptoUtils.secureEqualsBlock(byArray2, byArray)) {
                    throw new SignatureException("Signature verification error!");
                }
                object2 = null;
                if (IaikSecurity.getTryIAIKProviderFirst()) {
                    try {
                        object2 = algorithmID.getMessageDigestInstance(IAIK.getInstance());
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        // empty catch block
                    }
                }
                if (object2 == null) {
                    object2 = algorithmID.getMessageDigestInstance();
                }
                byArray2 = object2.digest(DerCoder.encode(ASN.createSetOf(aSN1TypeArray)));
            }
            object2 = signerInfo.g;
            AlgorithmID algorithmID2 = this.b.getContentEncryptionAlgorithm();
            AlgorithmParameterSpec algorithmParameterSpec = null;
            if (IaikSecurity.getTryIAIKProviderFirst()) {
                try {
                    algorithmParameterSpec = algorithmID2.getAlgorithmParameterSpec(IAIK.getInstance());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    // empty catch block
                }
            }
            if (algorithmParameterSpec == null) {
                try {
                    algorithmParameterSpec = algorithmID2.getAlgorithmParameterSpec();
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    // empty catch block
                }
            }
            if (algorithmParameterSpec == null && (object = algorithmID2.getParameter()) != null && ((ASN1Object)object).isA(ASN.OCTET_STRING)) {
                algorithmParameterSpec = new IvParameterSpec((byte[])((ASN1Object)object).getValue());
            }
            object = EncryptedContentInfoStream.a(algorithmID2, 2, (Key)this.c, algorithmParameterSpec);
            signerInfo.g = ((Cipher)object).doFinal(signerInfo.g);
            byArray = signerInfo.getDigest(publicKey);
            signerInfo.g = object2;
            if (!CryptoUtils.secureEqualsBlock(byArray2, byArray)) {
                throw new SignatureException("Signature verification error!");
            }
        }
        catch (Exception exception) {
            throw new SignatureException("Error verifying the signature: " + exception.getMessage());
        }
    }

    public RecipientInfo[] getRecipientInfos() {
        return this.a;
    }

    public EncryptedContentInfoStream getEncryptedContentInfo() {
        return this.b;
    }

    public ASN1Object toASN1Object() throws PKCSException {
        return this.toASN1Object(-1);
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2].encryptKey(this.c);
        }
        if (this.signer_infos == null) {
            throw new PKCSException("No SignerInfo specified!");
        }
        if (this.mode == 1) {
            try {
                this.input_stream = this.h.a(this.input_stream, true);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new PKCSException("No implementation for hash algorithm: " + noSuchAlgorithmException.getMessage());
            }
        }
        this.b.f = this.input_stream;
        this.b.i = n2;
        SEQUENCE sEQUENCE = new SEQUENCE(true);
        try {
            ASN1Object aSN1Object;
            sEQUENCE.addComponent(new INTEGER(this.version));
            sEQUENCE.addComponent(ASN.createSetOf(this.a));
            sEQUENCE.addComponent(ASN.createSetOf(this.h.a()));
            sEQUENCE.addComponent(this.b.toASN1Object());
            if (this.certificates != null) {
                aSN1Object = ASN.createSetOf(this.certificates);
                sEQUENCE.addComponent(new CON_SPEC(0, aSN1Object, true));
            }
            if (this.crls != null) {
                aSN1Object = ASN.createSetOf(this.crls);
                sEQUENCE.addComponent(new CON_SPEC(1, aSN1Object, true));
            }
            sEQUENCE.addComponent(ASN.createSetOf(this.signer_infos));
        }
        catch (CodingException codingException) {
            throw new PKCSException(codingException.toString());
        }
        return sEQUENCE;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        int n2;
        AlgorithmID[] algorithmIDArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version + "\n");
        if (this.a.length > 0) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                stringBuffer.append("\nRecipientInfo " + (i2 + 1) + ":{\n");
                stringBuffer.append(this.a[i2].toString());
                stringBuffer.append("\n}");
            }
        }
        if ((algorithmIDArray = this.h.a()).length > 0) {
            stringBuffer.append("digestAlgorithms: ");
            for (n2 = 0; n2 < algorithmIDArray.length; ++n2) {
                stringBuffer.append(algorithmIDArray[n2].getName() + ",");
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nEncryptedContentInfo: {\n");
        stringBuffer.append(this.b.toString() + "}");
        stringBuffer.append("\n\n");
        if (this.certificates != null) {
            stringBuffer.append("certificates: " + this.certificates.length + "\n");
        }
        if (this.crls != null) {
            stringBuffer.append("crls: " + this.crls.length + "\n");
        }
        if (bl) {
            n2 = 1;
            Enumeration enumeration = this.signer_infos.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("signerInfo " + n2 + ": {\n");
                stringBuffer.append(((SignerInfo)enumeration.nextElement()).toString(true) + "}");
                ++n2;
            }
        } else {
            stringBuffer.append("signerInfos: " + this.signer_infos.size() + "\n");
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

