/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.EncryptedContentInfo;
import iaik.pkcs.pkcs7.EncryptedContentInfoStream;
import iaik.pkcs.pkcs7.RecipientInfo;
import iaik.pkcs.pkcs7.SignedData;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.security.provider.IAIK;
import iaik.utils.CryptoUtils;
import iaik.utils.IaikSecurity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class SignedAndEnvelopedData
extends SignedData {
    RecipientInfo[] a;
    EncryptedContentInfo b;
    SecretKey c;
    static Class d;
    static Class e;

    protected SignedAndEnvelopedData() {
        this.version = 1;
    }

    public SignedAndEnvelopedData(byte[] byArray, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        this();
        this.f = byArray;
        this.content_type = ObjectID.pkcs7_data;
        this.b = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
        this.c = this.b.setupCipher(algorithmID);
    }

    public SignedAndEnvelopedData(byte[] byArray, AlgorithmID algorithmID, int n2) throws NoSuchAlgorithmException {
        this(byArray, algorithmID, n2 == -1 || n2 > 2 ? n2 : -1, n2 == 1 || n2 == 2 ? n2 : 1);
    }

    public SignedAndEnvelopedData(byte[] byArray, AlgorithmID algorithmID, int n2, int n3) throws NoSuchAlgorithmException {
        this();
        this.f = byArray;
        this.content_type = ObjectID.pkcs7_data;
        this.b = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
        if (n3 == 2) {
            this.version = 2;
            this.b.c = 1;
        } else if (n3 != 1) {
            throw new IllegalArgumentException("Invalid version number: " + n3);
        }
        this.c = this.b.setupCipher(algorithmID, n2);
    }

    public SignedAndEnvelopedData(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.decode(aSN1Object);
    }

    public SignedAndEnvelopedData(InputStream inputStream) throws PKCSParsingException, IOException {
        this();
        this.decode(inputStream);
    }

    public void decode(ASN1Object aSN1Object) throws PKCSParsingException {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode(aSN1Object)));
        }
        catch (IOException iOException) {
            throw new PKCSParsingException(iOException.getMessage());
        }
    }

    public void decode(InputStream inputStream) throws IOException, PKCSParsingException {
        this.i = false;
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        this.this_object = ((DerInputStream)inputStream).readSequence();
        this.version = this.this_object.readInteger().intValue();
        try {
            this.a = (RecipientInfo[])ASN.parseSequenceOf(DerCoder.decode(this.this_object), d == null ? (d = SignedAndEnvelopedData.class$("iaik.pkcs.pkcs7.RecipientInfo")) : d);
            this.h.a((AlgorithmID[])ASN.parseSequenceOf(DerCoder.decode(this.this_object), e == null ? (e = SignedAndEnvelopedData.class$("iaik.asn1.structures.AlgorithmID")) : e));
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException("Error parsing recipient infos!");
        }
        this.b = new EncryptedContentInfo();
        this.b.c = this.version - 1;
        this.b.decode(this.this_object);
        this.content_type = this.b.getContentType();
        this.notifyEOF();
    }

    public void setupCipher(PrivateKey privateKey, int n2) throws PKCSException, NoSuchAlgorithmException, InvalidKeyException {
        this.c = this.a[n2].decryptKey(privateKey);
        this.b.setupCipher(this.c);
        this.f = this.b.getContent();
        this.setupMessageDigests();
    }

    public ObjectID getContentType() {
        return ObjectID.pkcs7_signedAndEnvelopedData;
    }

    public void setRecipientInfos(RecipientInfo[] recipientInfoArray) {
        this.a = recipientInfoArray;
    }

    public void addRecipientInfo(RecipientInfo recipientInfo) {
        if (recipientInfo == null) {
            return;
        }
        if (this.a == null) {
            this.a = new RecipientInfo[]{recipientInfo};
            return;
        }
        RecipientInfo[] recipientInfoArray = new RecipientInfo[this.a.length + 1];
        System.arraycopy(this.a, 0, recipientInfoArray, 0, this.a.length);
        recipientInfoArray[this.a.length] = recipientInfo;
        this.a = recipientInfoArray;
    }

    public void verify(PublicKey publicKey, int n2) throws SignatureException {
        if (n2 < 0 || n2 >= this.signer_infos.size()) {
            throw new SignatureException("SignerInfo does not exist. Wrong index.");
        }
        SignerInfo signerInfo = (SignerInfo)this.signer_infos.elementAt(n2);
        ASN1Type[] aSN1TypeArray = signerInfo.getAuthenticatedAttributes();
        try {
            Object object;
            Object object2;
            byte[] byArray;
            AlgorithmID algorithmID = signerInfo.getDigestAlgorithm();
            byte[] byArray2 = this.getMessageDigest(algorithmID);
            if (aSN1TypeArray != null) {
                byArray = this.getSignedDigest(n2);
                if (!CryptoUtils.secureEqualsBlock(byArray2, byArray)) {
                    throw new SignatureException("Signature verification error!");
                }
                object2 = null;
                if (IaikSecurity.getTryIAIKProviderFirst()) {
                    try {
                        object2 = algorithmID.getMessageDigestInstance(IAIK.getInstance());
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        // empty catch block
                    }
                }
                if (object2 == null) {
                    object2 = algorithmID.getMessageDigestInstance();
                }
                byArray2 = object2.digest(DerCoder.encode(ASN.createSetOf(aSN1TypeArray)));
            }
            object2 = signerInfo.g;
            AlgorithmID algorithmID2 = this.b.getContentEncryptionAlgorithm();
            AlgorithmParameterSpec algorithmParameterSpec = null;
            if (IaikSecurity.getTryIAIKProviderFirst()) {
                try {
                    algorithmParameterSpec = algorithmID2.getAlgorithmParameterSpec(IAIK.getInstance());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    // empty catch block
                }
            }
            if (algorithmParameterSpec == null) {
                try {
                    algorithmParameterSpec = algorithmID2.getAlgorithmParameterSpec();
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    // empty catch block
                }
            }
            if (algorithmParameterSpec == null && (object = algorithmID2.getParameter()) != null && ((ASN1Object)object).isA(ASN.OCTET_STRING)) {
                algorithmParameterSpec = new IvParameterSpec((byte[])((ASN1Object)object).getValue());
            }
            object = EncryptedContentInfoStream.a(algorithmID2, 2, (Key)this.c, algorithmParameterSpec);
            signerInfo.g = ((Cipher)object).doFinal(signerInfo.g);
            byArray = signerInfo.getDigest(publicKey);
            signerInfo.g = object2;
            if (!CryptoUtils.secureEqualsBlock(byArray2, byArray)) {
                throw new SignatureException("Signature verification error!");
            }
        }
        catch (Exception exception) {
            throw new SignatureException("Error verifying the signature: " + exception.getMessage());
        }
    }

    public RecipientInfo[] getRecipientInfos() {
        return this.a;
    }

    public InputStream getInputStream() {
        return this.b.getInputStream();
    }

    public byte[] getContent() {
        return this.b.getContent();
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.b;
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.a[i2].encryptKey(this.c);
        }
        if (this.signer_infos == null) {
            throw new PKCSException("No SignerInfo specified!");
        }
        this.b.setBlockSize(n2);
        SEQUENCE sEQUENCE = new SEQUENCE(n2 > 0);
        try {
            sEQUENCE.addComponent(new INTEGER(this.version));
            if (this.version == 2) {
                Object object;
                sEQUENCE.addComponent(ASN.createSequenceOf(this.a));
                sEQUENCE.addComponent(ASN.createSequenceOf(this.h.a()));
                sEQUENCE.addComponent(this.b.toASN1Object());
                if (this.certificates != null) {
                    object = ASN.createSequenceOf(this.certificates);
                    sEQUENCE.addComponent(new CON_SPEC(2, (ASN1Object)object, true));
                }
                if (this.crls != null) {
                    object = ASN.createSequenceOf(this.crls);
                    sEQUENCE.addComponent(new CON_SPEC(3, (ASN1Object)object, true));
                }
                object = this.signer_infos.elements();
                while (object.hasMoreElements()) {
                    ((SignerInfo)object.nextElement()).b = 2;
                }
                sEQUENCE.addComponent(ASN.createSequenceOf(this.signer_infos));
            } else {
                ASN1Object aSN1Object;
                sEQUENCE.addComponent(ASN.createSetOf(this.a));
                sEQUENCE.addComponent(ASN.createSetOf(this.h.a()));
                sEQUENCE.addComponent(this.b.toASN1Object());
                if (this.certificates != null) {
                    aSN1Object = ASN.createSetOf(this.certificates);
                    sEQUENCE.addComponent(new CON_SPEC(0, aSN1Object, true));
                }
                if (this.crls != null) {
                    aSN1Object = ASN.createSetOf(this.crls);
                    sEQUENCE.addComponent(new CON_SPEC(1, aSN1Object, true));
                }
                sEQUENCE.addComponent(ASN.createSetOf(this.signer_infos));
            }
        }
        catch (CodingException codingException) {
            throw new PKCSException(codingException.toString());
        }
        return sEQUENCE;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        int n2;
        AlgorithmID[] algorithmIDArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version + "\n");
        if (this.a.length > 0) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                stringBuffer.append("\nRecipientInfo " + (i2 + 1) + ":{\n");
                stringBuffer.append(this.a[i2].toString());
                stringBuffer.append("\n}");
            }
        }
        if ((algorithmIDArray = this.h.a()).length > 0) {
            stringBuffer.append("digestAlgorithms: ");
            for (n2 = 0; n2 < algorithmIDArray.length; ++n2) {
                stringBuffer.append(algorithmIDArray[n2].getName() + ",");
            }
            stringBuffer.setLength(stringBuffer.length() - 1);
            stringBuffer.append("\n");
        }
        stringBuffer.append("\nEncryptedContentInfo: {\n");
        stringBuffer.append(this.b.toString() + "}");
        stringBuffer.append("\n\n");
        if (this.certificates != null) {
            stringBuffer.append("certificates: " + this.certificates.length + "\n");
        }
        if (this.crls != null) {
            stringBuffer.append("crls: " + this.crls.length + "\n");
        }
        if (bl) {
            n2 = 1;
            Enumeration enumeration = this.signer_infos.elements();
            while (enumeration.hasMoreElements()) {
                stringBuffer.append("signerInfo " + n2 + ": {\n");
                stringBuffer.append(((SignerInfo)enumeration.nextElement()).toString(true) + "}");
                ++n2;
            }
        } else {
            stringBuffer.append("signerInfos: " + this.signer_infos.size() + "\n");
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

