/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.RSACipherProvider;
import iaik.security.cipher.SecretKey;
import iaik.utils.Util;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class RecipientInfo
implements ASN1Type {
    int a = 0;
    IssuerAndSerialNumber b;
    AlgorithmID c;
    PublicKey d;
    byte[] e;
    RSACipherProvider f = RSACipherProvider.getDefault();

    public RecipientInfo() {
    }

    public RecipientInfo(IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmID algorithmID, byte[] byArray) {
        this();
        this.b = issuerAndSerialNumber;
        this.c = algorithmID;
        this.e = byArray;
    }

    public RecipientInfo(X509Certificate x509Certificate, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        this();
        this.d = x509Certificate.getPublicKey();
        this.b = new IssuerAndSerialNumber(x509Certificate);
        this.c = algorithmID;
    }

    public RecipientInfo(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.a = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
        this.b = new IssuerAndSerialNumber(aSN1Object.getComponentAt(1));
        this.c = new AlgorithmID(aSN1Object.getComponentAt(2));
        this.e = (byte[])aSN1Object.getComponentAt(3).getValue();
    }

    public ASN1Object toASN1Object() {
        if (this.b == null) {
            throw new NullPointerException("issuerAndSerialNumber field of this RecipientInfo not set!");
        }
        if (this.c == null) {
            throw new NullPointerException("keyEncryptionAlgorithm field of this RecipientInfo not set!");
        }
        if (this.e == null) {
            throw new NullPointerException("encryptedKey field of this RecipientInfo not set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new INTEGER(this.a));
        sEQUENCE.addComponent(this.b.toASN1Object());
        sEQUENCE.addComponent(this.c.toASN1Object());
        sEQUENCE.addComponent(new OCTET_STRING(this.e));
        return sEQUENCE;
    }

    public javax.crypto.SecretKey decryptKey(PrivateKey privateKey) throws PKCSException, InvalidKeyException {
        return this.decryptKey(privateKey, "RAW");
    }

    public javax.crypto.SecretKey decryptKey(PrivateKey privateKey, String string) throws PKCSException, InvalidKeyException {
        byte[] byArray = null;
        try {
            byArray = this.f.cipher(2, privateKey, this.e);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException("No implementation for \"RSA/ECB/PKCS1Padding\"");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new PKCSException(noSuchProviderException.toString());
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PKCSException(generalSecurityException.toString());
        }
        return new SecretKey(byArray, string);
    }

    public void encryptKey(javax.crypto.SecretKey secretKey) throws PKCSException {
        if (this.c == null) {
            throw new PKCSException("Unable to encrypt symmetric key. Content-encryption algorithm is not set!");
        }
        if (this.d == null) {
            throw new PKCSException("Unable to encrypt symmetric key. Public key is not set!");
        }
        try {
            this.e = this.f.cipher(1, this.d, secretKey.getEncoded());
        }
        catch (Exception exception) {
            throw new PKCSException("Unable to encrypt the symmetric key: " + exception.toString());
        }
    }

    public int getVersion() {
        return this.a;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.b;
    }

    public AlgorithmID getKeyEncryptionAlgorithm() {
        return this.c;
    }

    public byte[] getEncryptedKey() {
        return this.e;
    }

    public void setRSACipherProvider(RSACipherProvider rSACipherProvider) {
        if (rSACipherProvider == null) {
            throw new IllegalArgumentException("Provider is not alloed tp be null!");
        }
        this.f = rSACipherProvider;
    }

    public RSACipherProvider getRSACipherProvider() {
        return this.f;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.a + "\n");
        stringBuffer.append(this.b);
        stringBuffer.append("keyEncryptionAlgorithm: " + this.c + "\n");
        stringBuffer.append("encryptedKey: " + (this.e == null ? "not set" : Util.toString(this.e, 0, 5)) + "...");
        return stringBuffer.toString();
    }
}

