/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentStream;
import iaik.pkcs.pkcs7.EncryptedContentInfoStream;
import iaik.security.cipher.PBEKey;
import iaik.security.cipher.PBEKeyBMP;
import iaik.security.pbe.PBEGenParameterSpec;
import iaik.security.provider.IAIK;
import iaik.utils.IaikSecurity;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class EncryptedDataStream
implements ContentStream {
    protected int version = 0;
    protected int block_size = 2048;
    private EncryptedContentInfoStream a;
    static Class b;

    protected EncryptedDataStream() {
    }

    public EncryptedDataStream(EncryptedContentInfoStream encryptedContentInfoStream) {
        this();
        this.a = encryptedContentInfoStream;
    }

    public EncryptedDataStream(InputStream inputStream, int n2) {
        this();
        this.a = new EncryptedContentInfoStream(ObjectID.pkcs7_data, inputStream);
        this.block_size = n2;
    }

    public EncryptedDataStream(InputStream inputStream) throws IOException, PKCSParsingException {
        this();
        this.decode(inputStream);
    }

    public void setBlockSize(int n2) {
        this.block_size = n2;
    }

    public int getBlockSize() {
        return this.block_size;
    }

    public void decode(InputStream inputStream) throws IOException, PKCSParsingException {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = ((DerInputStream)inputStream).readSequence();
        this.version = derInputStream.readInteger().intValue();
        this.a = new EncryptedContentInfoStream(derInputStream);
    }

    public void setupCipher(AlgorithmID algorithmID, char[] cArray) throws NoSuchAlgorithmException, InvalidKeyException {
        this.setupCipher(algorithmID, cArray, 2000);
    }

    public void setupCipher(AlgorithmID algorithmID, char[] cArray, int n2) throws NoSuchAlgorithmException, InvalidKeyException {
        try {
            AlgorithmParameterSpec algorithmParameterSpec = this.a(algorithmID, n2);
            Key key = this.a(cArray, algorithmID);
            this.a.setupCipher(algorithmID, key, algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InternalErrorException(invalidAlgorithmParameterException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InternalErrorException(invalidParameterSpecException);
        }
    }

    public void setupCipher(char[] cArray) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidParameterSpecException, InvalidKeyException {
        AlgorithmID algorithmID = this.a.getContentEncryptionAlgorithm();
        AlgorithmParameters algorithmParameters = null;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                algorithmParameters = algorithmID.getAlgorithmParameters("PBE", IAIK.getInstance());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        if (algorithmParameters == null) {
            algorithmParameters = algorithmID.getAlgorithmParameters("PBE");
        }
        Object t2 = algorithmParameters.getParameterSpec(b == null ? (b = EncryptedDataStream.class$("javax.crypto.spec.PBEParameterSpec")) : b);
        Key key = this.a(cArray, this.a.getContentEncryptionAlgorithm());
        this.a.setupCipher(key, (AlgorithmParameterSpec)t2);
    }

    AlgorithmParameterSpec a(AlgorithmID algorithmID, int n2) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidParameterSpecException {
        PBEGenParameterSpec pBEGenParameterSpec = new PBEGenParameterSpec(8, n2);
        AlgorithmParameterGenerator algorithmParameterGenerator = null;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                algorithmParameterGenerator = IaikSecurity.getAlgorithmParameterGeneratorInstance("PBE", IAIK.getInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (algorithmParameterGenerator == null) {
            algorithmParameterGenerator = AlgorithmParameterGenerator.getInstance("PBE");
        }
        algorithmParameterGenerator.init(pBEGenParameterSpec);
        AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
        Object t2 = algorithmParameters.getParameterSpec(b == null ? (b = EncryptedDataStream.class$("javax.crypto.spec.PBEParameterSpec")) : b);
        algorithmID.setAlgorithmParameters(algorithmParameters);
        return t2;
    }

    Key a(char[] cArray, AlgorithmID algorithmID) {
        if (algorithmID.equals(AlgorithmID.pbeWithMD5AndDES_CBC)) {
            return new PBEKey(cArray);
        }
        return new PBEKeyBMP(cArray);
    }

    public ObjectID getContentType() {
        return ObjectID.pkcs7_encryptedData;
    }

    public int getVersion() {
        return this.version;
    }

    public InputStream getInputStream() {
        return this.a.getInputStream();
    }

    public ASN1Object toASN1Object() throws PKCSException {
        return this.toASN1Object(-1);
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        this.a.setBlockSize(n2);
        SEQUENCE sEQUENCE = new SEQUENCE(true);
        sEQUENCE.addComponent(new INTEGER(this.version));
        sEQUENCE.addComponent(this.a.toASN1Object());
        return sEQUENCE;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        try {
            DerCoder.encodeTo(this.toASN1Object(), outputStream);
        }
        catch (PKCSException pKCSException) {
            throw new IOException(pKCSException.toString());
        }
    }

    public void writeTo(OutputStream outputStream, int n2) throws IOException {
        try {
            DerCoder.encodeTo(this.toASN1Object(n2), outputStream);
        }
        catch (PKCSException pKCSException) {
            throw new IOException(pKCSException.toString());
        }
    }

    public Object getEncryptedContentInfo() {
        return this.a;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version + "\n");
        stringBuffer.append("EncryptedContentInfo:\n");
        stringBuffer.append(this.a.toString());
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

