/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.EncryptedContentInfo;
import iaik.pkcs.pkcs7.EncryptedDataStream;
import iaik.security.provider.IAIK;
import iaik.utils.IaikSecurity;
import iaik.utils.InternalErrorException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class EncryptedData
extends EncryptedDataStream
implements Content {
    private EncryptedContentInfo c;
    static Class a;

    protected EncryptedData() {
        this.block_size = -1;
    }

    public EncryptedData(EncryptedContentInfo encryptedContentInfo) {
        this();
        this.c = encryptedContentInfo;
    }

    public EncryptedData(byte[] byArray) {
        this();
        this.c = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
    }

    public EncryptedData(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.decode(aSN1Object);
    }

    public EncryptedData(InputStream inputStream) throws IOException, PKCSParsingException {
        this();
        this.decode(inputStream);
    }

    public void decode(ASN1Object aSN1Object) throws PKCSParsingException {
        try {
            this.decode(new ByteArrayInputStream(DerCoder.encode(aSN1Object)));
        }
        catch (IOException iOException) {
            throw new PKCSParsingException(iOException.getMessage());
        }
    }

    public void decode(InputStream inputStream) throws IOException, PKCSParsingException {
        if (!(inputStream instanceof DerInputStream)) {
            inputStream = new DerInputStream(inputStream);
        }
        DerInputStream derInputStream = ((DerInputStream)inputStream).readSequence();
        this.version = derInputStream.readInteger().intValue();
        this.c = new EncryptedContentInfo();
        this.c.decode(derInputStream);
    }

    public void setupCipher(AlgorithmID algorithmID, char[] cArray, int n2) throws NoSuchAlgorithmException, InvalidKeyException {
        try {
            AlgorithmParameterSpec algorithmParameterSpec = this.a(algorithmID, n2);
            Key key = this.a(cArray, algorithmID);
            this.c.setupCipher(algorithmID, key, algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InternalErrorException(invalidAlgorithmParameterException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new InternalErrorException(invalidParameterSpecException);
        }
    }

    public void setupCipher(char[] cArray) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidParameterSpecException, InvalidKeyException {
        AlgorithmID algorithmID = this.c.getContentEncryptionAlgorithm();
        AlgorithmParameters algorithmParameters = null;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                algorithmParameters = algorithmID.getAlgorithmParameters("PBE", IAIK.getInstance());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
        }
        if (algorithmParameters == null) {
            algorithmParameters = algorithmID.getAlgorithmParameters("PBE");
        }
        Object t2 = algorithmParameters.getParameterSpec(a == null ? (a = EncryptedData.class$("javax.crypto.spec.PBEParameterSpec")) : a);
        Key key = this.a(cArray, this.c.getContentEncryptionAlgorithm());
        this.c.setupCipher(key, (AlgorithmParameterSpec)t2);
    }

    public InputStream getInputStream() {
        return this.c.getInputStream();
    }

    public byte[] getContent() {
        return this.c.getContent();
    }

    protected ASN1Object toASN1Object(int n2) throws PKCSException {
        if (n2 <= 0) {
            n2 = this.block_size;
        }
        this.c.setBlockSize(n2);
        SEQUENCE sEQUENCE = new SEQUENCE(n2 > 0);
        sEQUENCE.addComponent(new INTEGER(this.version));
        sEQUENCE.addComponent(this.c.toASN1Object());
        return sEQUENCE;
    }

    public Object getEncryptedContentInfo() {
        return this.c;
    }

    public byte[] getEncoded() throws PKCSException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DerCoder.encodeTo(this.toASN1Object(), byteArrayOutputStream);
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new PKCSException(iOException.getMessage());
        }
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.version + "\n");
        stringBuffer.append("EncryptedContentInfo:\n");
        stringBuffer.append(this.c.toString());
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

