/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.DerCoder;
import iaik.asn1.DerInputStream;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.security.provider.IAIK;
import iaik.utils.CipherInputStream;
import iaik.utils.IaikSecurity;
import iaik.utils.InternalErrorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptedContentInfoStream {
    ObjectID d;
    AlgorithmID e;
    InputStream f;
    Cipher g;
    int h = -1;
    int i = 2048;

    static Cipher a(AlgorithmID algorithmID, int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = null;
        InvalidKeyException invalidKeyException = null;
        InvalidAlgorithmParameterException invalidAlgorithmParameterException = null;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                cipher = algorithmID.getCipherInstance(IAIK.getInstance());
                cipher.init(n2, key, algorithmParameterSpec, null);
            }
            catch (InvalidKeyException invalidKeyException2) {
                invalidKeyException = invalidKeyException2;
                cipher = null;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException2) {
                invalidAlgorithmParameterException = invalidAlgorithmParameterException2;
                cipher = null;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                cipher = null;
            }
        }
        if (cipher == null) {
            boolean bl;
            block14: {
                bl = invalidKeyException != null || invalidAlgorithmParameterException != null;
                cipher = algorithmID.getCipherInstance();
                try {
                    if ("RAW".equals(key.getAlgorithm())) {
                        key = new SecretKeySpec(key.getEncoded(), algorithmID.getRawImplementationName());
                    }
                    cipher.init(n2, key, algorithmParameterSpec);
                    bl = false;
                }
                catch (InvalidKeyException invalidKeyException3) {
                    if (!bl) {
                        throw invalidKeyException3;
                    }
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException3) {
                    if (bl) break block14;
                    throw invalidAlgorithmParameterException3;
                }
            }
            if (bl) {
                if (invalidKeyException != null) {
                    throw invalidKeyException;
                }
                if (invalidAlgorithmParameterException != null) {
                    throw invalidAlgorithmParameterException;
                }
            }
        }
        return cipher;
    }

    static Cipher a(AlgorithmID algorithmID, int n2, Key key, AlgorithmParameters algorithmParameters) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = null;
        InvalidKeyException invalidKeyException = null;
        InvalidAlgorithmParameterException invalidAlgorithmParameterException = null;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                cipher = algorithmID.getCipherInstance(IAIK.getInstance());
                cipher.init(n2, key, algorithmParameters, null);
            }
            catch (InvalidKeyException invalidKeyException2) {
                invalidKeyException = invalidKeyException2;
                cipher = null;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException2) {
                invalidAlgorithmParameterException = invalidAlgorithmParameterException2;
                cipher = null;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                cipher = null;
            }
        }
        if (cipher == null) {
            boolean bl;
            block14: {
                bl = invalidKeyException != null || invalidAlgorithmParameterException != null;
                cipher = algorithmID.getCipherInstance();
                try {
                    if ("RAW".equals(key.getAlgorithm())) {
                        key = new SecretKeySpec(key.getEncoded(), algorithmID.getRawImplementationName());
                    }
                    cipher.init(n2, key, algorithmParameters);
                    bl = false;
                }
                catch (InvalidKeyException invalidKeyException3) {
                    if (!bl) {
                        throw invalidKeyException3;
                    }
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException3) {
                    if (bl) break block14;
                    throw invalidAlgorithmParameterException3;
                }
            }
            if (bl) {
                if (invalidKeyException != null) {
                    throw invalidKeyException;
                }
                if (invalidAlgorithmParameterException != null) {
                    throw invalidAlgorithmParameterException;
                }
            }
        }
        return cipher;
    }

    protected EncryptedContentInfoStream() {
    }

    public EncryptedContentInfoStream(ObjectID objectID, InputStream inputStream) {
        this();
        this.f = inputStream;
        this.d = objectID;
        this.h = 1;
    }

    public EncryptedContentInfoStream(ObjectID objectID, AlgorithmID algorithmID) {
        this();
        this.d = objectID;
        this.e = algorithmID;
    }

    public EncryptedContentInfoStream(InputStream inputStream) throws IOException, PKCSParsingException {
        this();
        this.decode(inputStream);
    }

    protected void decode(InputStream inputStream) throws IOException, PKCSParsingException {
        this.h = 2;
        DerInputStream derInputStream = inputStream instanceof DerInputStream ? ((DerInputStream)inputStream).readSequence() : new DerInputStream(inputStream).readSequence();
        this.d = derInputStream.readObjectID();
        this.e = new AlgorithmID(derInputStream);
        if (derInputStream.nextTag() == -1) {
            return;
        }
        if (derInputStream.readContextSpecific(4) != 0) {
            throw new IOException("Error parsing encrypted content!");
        }
        this.f = derInputStream.readOctetString();
    }

    public void setupCipher(AlgorithmID algorithmID, Key key, AlgorithmParameterSpec algorithmParameterSpec) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        block12: {
            byte[] byArray;
            Object object;
            this.e = (AlgorithmID)algorithmID.clone();
            ASN1Object aSN1Object = algorithmID.getParameter();
            if (algorithmParameterSpec != null && aSN1Object == null) {
                if (algorithmParameterSpec instanceof IvParameterSpec) {
                    object = (IvParameterSpec)algorithmParameterSpec;
                    aSN1Object = new OCTET_STRING(((IvParameterSpec)object).getIV());
                    this.e.setParameter(aSN1Object);
                }
            } else if (algorithmParameterSpec == null && aSN1Object != null && aSN1Object instanceof OCTET_STRING) {
                object = (OCTET_STRING)aSN1Object;
                byArray = null;
                try {
                    byArray = ((OCTET_STRING)object).getWholeValue();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (byArray != null) {
                    algorithmParameterSpec = new IvParameterSpec(byArray);
                }
            }
            this.g = EncryptedContentInfoStream.a(this.e, 1, key, algorithmParameterSpec);
            try {
                object = this.g.getParameters();
                if (object != null) {
                    this.e.setAlgorithmParameters((AlgorithmParameters)object);
                } else {
                    byArray = this.g.getIV();
                    if (byArray != null) {
                        this.e.setParameter(new OCTET_STRING(byArray));
                    }
                }
            }
            catch (Exception exception) {
                if (aSN1Object == null) break block12;
                this.e.setParameter(aSN1Object);
            }
        }
    }

    public SecretKey setupCipher(AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        return this.setupCipher(algorithmID, -1);
    }

    public SecretKey setupCipher(AlgorithmID algorithmID, int n2) throws NoSuchAlgorithmException {
        String string = algorithmID.getImplementationName();
        int n3 = string.indexOf(47);
        if (n3 == -1) {
            throw new NoSuchAlgorithmException("Algorithm " + string + " cannot be used with this method. " + "Please try another setup method!");
        }
        String string2 = string.substring(0, n3);
        KeyGenerator keyGenerator = null;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                keyGenerator = IaikSecurity.getKeyGeneratorInstance(string2, IAIK.getInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (keyGenerator == null) {
            keyGenerator = KeyGenerator.getInstance(string2);
        }
        if (n2 == -1) {
            if (algorithmID.equals(AlgorithmID.aes256_CBC)) {
                n2 = 256;
            } else if (algorithmID.equals(AlgorithmID.aes192_CBC)) {
                n2 = 192;
            } else if (algorithmID.equals(AlgorithmID.aes128_CBC)) {
                n2 = 128;
            }
        }
        if (n2 < 0) {
            keyGenerator.init((SecureRandom)null);
        } else {
            keyGenerator.init(n2);
        }
        SecretKey secretKey = keyGenerator.generateKey();
        try {
            this.setupCipher(algorithmID, secretKey, null);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InternalErrorException("Internal Key problem.");
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InternalErrorException("We don't set an AlgorithmParameter.");
        }
        return secretKey;
    }

    public void setupCipher(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        if (this.h == -1) {
            throw new InternalErrorException("Object not configured for en/decrypting!");
        }
        this.g = EncryptedContentInfoStream.a(this.e, this.h, key, algorithmParameterSpec);
    }

    public void setupCipher(Key key) throws NoSuchAlgorithmException, InvalidKeyException, PKCSException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        try {
            if (IaikSecurity.getTryIAIKProviderFirst()) {
                try {
                    algorithmParameterSpec = this.e.getAlgorithmParameterSpec(IAIK.getInstance());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    // empty catch block
                }
            }
            if (algorithmParameterSpec == null) {
                algorithmParameterSpec = this.e.getAlgorithmParameterSpec();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (algorithmParameterSpec == null) {
            try {
                ASN1Object aSN1Object = this.e.getParameter();
                if (aSN1Object != null && aSN1Object.isA(ASN.OCTET_STRING)) {
                    algorithmParameterSpec = new IvParameterSpec((byte[])aSN1Object.getValue());
                }
            }
            catch (Exception exception) {
                throw new PKCSException("Unable to get algorithm parameter!");
            }
        }
        try {
            this.setupCipher(key, algorithmParameterSpec);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new PKCSException("Wrong algorithm parameter!");
        }
    }

    public void setBlockSize(int n2) {
        this.i = n2;
    }

    public int getBlockSize() {
        return this.i;
    }

    public ASN1Object toASN1Object() throws PKCSException {
        if (this.e == null) {
            throw new PKCSException("contentEncryptionAlgorithm field not set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE(true);
        sEQUENCE.addComponent(this.d);
        sEQUENCE.addComponent(this.e.toASN1Object());
        try {
            if (this.f != null) {
                OCTET_STRING oCTET_STRING = null;
                if (this.g == null) {
                    throw new PKCSException("Cipher not initialized!");
                }
                this.f = new CipherInputStream(this.f, this.g, this.i);
                oCTET_STRING = new OCTET_STRING(this.f, this.i);
                CON_SPEC cON_SPEC = new CON_SPEC(0, oCTET_STRING, true);
                sEQUENCE.addComponent(cON_SPEC);
            }
        }
        catch (Exception exception) {
            throw new PKCSException(exception.getMessage());
        }
        return sEQUENCE;
    }

    public void writeTo(OutputStream outputStream) throws IOException, PKCSException {
        DerCoder.encodeTo(this.toASN1Object(), outputStream);
    }

    public ObjectID getContentType() {
        return this.d;
    }

    public AlgorithmID getContentEncryptionAlgorithm() {
        return this.e;
    }

    public InputStream getInputStream() {
        if (this.g == null) {
            throw new InternalErrorException("Cipher yet not initialized!");
        }
        if (this.f == null) {
            return null;
        }
        return new CipherInputStream(this.f, this.g);
    }

    public boolean hasContent() {
        return this.f != null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ContentType: " + this.d.getName() + "\n");
        stringBuffer.append("contentEncryptionAlgorithm: " + this.e + "\n");
        return stringBuffer.toString();
    }
}

