/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs5;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs5.PBMAC1ParameterSpec;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class PBMAC1Parameters
extends AlgorithmParametersSpi {
    private PBMAC1ParameterSpec b;
    static Class a;

    protected byte[] engineGetEncoded() throws IOException {
        if (this.b == null) {
            throw new IllegalStateException("PBMAC1Parameters not initialized yet!");
        }
        if (!(this.b instanceof PBMAC1ParameterSpec)) {
            throw new IllegalStateException("PBMAC1Parameters not initialized with a PBMAC1ParameterSpec!");
        }
        PBMAC1ParameterSpec pBMAC1ParameterSpec = this.b;
        SEQUENCE sEQUENCE = new SEQUENCE();
        AlgorithmID algorithmID = pBMAC1ParameterSpec.getKeyDerivationFunction();
        AlgorithmID algorithmID2 = pBMAC1ParameterSpec.getMessageAuthScheme();
        sEQUENCE.addComponent(algorithmID.toASN1Object());
        sEQUENCE.addComponent(algorithmID2.toASN1Object());
        return DerCoder.encode(sEQUENCE);
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (this.b == null) {
            throw new IllegalStateException("PBMAC1Parameters not initialized yet!");
        }
        boolean bl = (a == null ? (a = PBMAC1Parameters.class$("iaik.pkcs.pkcs5.PBMAC1ParameterSpec")) : a).isAssignableFrom(clazz);
        if (!bl) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName() + ". Must be a PBMAC1ParameterSpec!");
        }
        return this.b;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBMAC1ParameterSpec)) {
            throw new InvalidParameterSpecException("paramSpec must be PBMAC1ParameterSpec.");
        }
        this.b = (PBMAC1ParameterSpec)algorithmParameterSpec;
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            if (!aSN1Object.isA(ASN.SEQUENCE)) {
                throw new CodingException("PBMAC1 parameters must be ASN.1 SEQUENCE!");
            }
            int n2 = aSN1Object.countComponents();
            if (n2 != 2) {
                throw new CodingException("Invalid number of PBMAC1 parameter components (" + n2 + "). Must be 2!");
            }
            AlgorithmID algorithmID = new AlgorithmID(aSN1Object.getComponentAt(0));
            if (!AlgorithmID.pbkdf2.equals(algorithmID)) {
                throw new IOException("Unsupported KDF (" + algorithmID.getAlgorithm() + "). Only PBKDF2 supported!");
            }
            AlgorithmID algorithmID2 = new AlgorithmID(aSN1Object.getComponentAt(1));
            this.b = new PBMAC1ParameterSpec(algorithmID, algorithmID2);
        }
        catch (CodingException codingException) {
            throw new IOException("Error decoding PBMAC1 parameters: " + codingException.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return this.b == null ? "PBMAC1" : this.b.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

