/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs5;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs5.PBKDF2;
import iaik.utils.Util;
import javax.crypto.spec.PBEParameterSpec;

public class PBKDF2ParameterSpec
extends PBEParameterSpec
implements Cloneable {
    private byte[] a;
    private int b;
    private int c;
    private AlgorithmID d;

    public PBKDF2ParameterSpec(byte[] byArray, int n2, int n3) {
        super(byArray, n2);
        if (byArray == null || byArray.length == 0) {
            throw new IllegalArgumentException("salt must not be null!");
        }
        this.a = (byte[])byArray.clone();
        if (n2 < 1) {
            throw new IllegalArgumentException("iterationCount must be >= 1!");
        }
        this.b = n2;
        if (n3 < 1) {
            throw new IllegalArgumentException("derivedKeyLength must be >= 1!");
        }
        this.c = n3;
        this.d = (AlgorithmID)PBKDF2.a.clone();
    }

    public void setPrf(AlgorithmID algorithmID) {
        if (algorithmID == null) {
            this.d = (AlgorithmID)PBKDF2.a.clone();
        }
        this.d = algorithmID;
    }

    public AlgorithmID getPrf() {
        return this.d;
    }

    public int getIterationCount() {
        return this.b;
    }

    public final int getDerivedKeyLength() {
        return this.c;
    }

    public final byte[] getSalt() {
        return (byte[])this.a.clone();
    }

    public Object clone() {
        PBKDF2ParameterSpec pBKDF2ParameterSpec = null;
        try {
            pBKDF2ParameterSpec = (PBKDF2ParameterSpec)super.clone();
            if (this.a != null) {
                pBKDF2ParameterSpec.a = (byte[])this.a.clone();
            }
            pBKDF2ParameterSpec.b = this.b;
            pBKDF2ParameterSpec.c = this.c;
            if (this.d != null) {
                pBKDF2ParameterSpec.d = (AlgorithmID)this.d.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return pBKDF2ParameterSpec;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("salt: " + Util.toString(this.a) + "\n");
        stringBuffer.append("iterationCount: " + this.b + "\n");
        stringBuffer.append("keyLength: " + this.c + "\n");
        if (this.d != null) {
            stringBuffer.append("prf: " + this.d + "\n");
        }
        return stringBuffer.toString();
    }
}

