/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs5;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs5.PBKDF2KeyAndParameterSpec;
import iaik.security.cipher.SecretKey;
import iaik.security.provider.IAIK;
import iaik.security.spec.PBEKeyAndParameterSpec;
import iaik.utils.IaikSecurity;
import iaik.utils.InternalErrorException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.Mac;

public class PBKDF2
extends KeyGeneratorSpi {
    static final AlgorithmID a = (AlgorithmID)AlgorithmID.hMAC_SHA1_.clone();
    private int b = 32;
    private int c = 2000;
    private byte[] d;
    private byte[] e;
    private AlgorithmID f;

    public PBKDF2() {
        this(a);
    }

    PBKDF2(AlgorithmID algorithmID) {
        this.f = (AlgorithmID)algorithmID.clone();
    }

    private byte[] a(int n2) {
        byte[] byArray = new byte[4];
        for (int i2 = 3; i2 >= 0; --i2) {
            byArray[i2] = (byte)(n2 & 0xFF);
            n2 >>>= 8;
        }
        return byArray;
    }

    private byte[] a() {
        Mac mac = null;
        try {
            mac = PBKDF2.a(this.f);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalErrorException("Cannot get Mac implementation: " + noSuchAlgorithmException.toString());
        }
        int n2 = mac.getMacLength();
        SecretKey secretKey = new SecretKey(this.e, mac.getAlgorithm());
        try {
            mac.init(secretKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException("Mac initialization failed: " + invalidKeyException.toString());
        }
        int n3 = this.b % n2;
        int n4 = n3 == 0 ? this.b / n2 : (this.b - n3) / n2 + 1;
        byte[] byArray = new byte[n2 * n4];
        for (int i2 = 1; i2 <= n4; ++i2) {
            byte[] byArray2 = new byte[this.d.length + 4];
            byte[] byArray3 = this.a(i2);
            System.arraycopy(this.d, 0, byArray2, 0, this.d.length);
            System.arraycopy(byArray3, 0, byArray2, this.d.length, 4);
            byte[] byArray4 = mac.doFinal(byArray2);
            byte[] byArray5 = new byte[n2];
            System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
            for (int i3 = 1; i3 < this.c; ++i3) {
                byArray4 = mac.doFinal(byArray4);
                for (int i4 = 0; i4 < n2; ++i4) {
                    int n5 = i4;
                    byArray5[n5] = (byte)(byArray5[n5] ^ byArray4[i4]);
                }
            }
            System.arraycopy(byArray5, 0, byArray, (i2 - 1) * n2, n2);
        }
        byte[] byArray6 = new byte[this.b];
        System.arraycopy(byArray, 0, byArray6, 0, this.b);
        return byArray6;
    }

    public javax.crypto.SecretKey engineGenerateKey() {
        if (this.e == null || this.d == null) {
            throw new IllegalStateException("PBKDF2 is not initialized yet. ");
        }
        byte[] byArray = this.a();
        return new SecretKey(byArray, "RAW");
    }

    public void engineInit(int n2, SecureRandom secureRandom) {
        throw new RuntimeException("iaik.pkcs.pkcs5.pBKDF2.engineInit(int, SecureRandom) method is not implemented. ");
    }

    public void engineInit(SecureRandom secureRandom) {
        throw new RuntimeException("iaik.pkcs.pkcs5.pBKDF2.engineInit(SecureRandom) method is not implemented. ");
    }

    public void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        AlgorithmID algorithmID;
        if (!(algorithmParameterSpec instanceof PBEKeyAndParameterSpec)) {
            throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec must be an instance of iaik.security.PBEKeyAndParameterSpec");
        }
        this.e = ((PBEKeyAndParameterSpec)algorithmParameterSpec).getPassword();
        if (this.e == null) {
            throw new InvalidAlgorithmParameterException("PBEKeyAndParameterSpec does not contain a valid password. ");
        }
        this.d = ((PBEKeyAndParameterSpec)algorithmParameterSpec).getSalt();
        if (this.d == null) {
            throw new InvalidAlgorithmParameterException("PBEKeyAndParameterSpec does not contain a valid salt. ");
        }
        int n2 = ((PBEKeyAndParameterSpec)algorithmParameterSpec).getIterationCount();
        if (n2 < 1) {
            throw new InvalidAlgorithmParameterException("PBEKeyAndParameterSpec does not contain a valid iterationCount. ");
        }
        this.c = n2;
        int n3 = ((PBEKeyAndParameterSpec)algorithmParameterSpec).getDerivedKeyLength();
        if (n3 < 1) {
            throw new InvalidAlgorithmParameterException("PBEKeyAndParameterSpec does not contain a valid dKLength. ");
        }
        this.b = n3;
        if (algorithmParameterSpec instanceof PBKDF2KeyAndParameterSpec && (algorithmID = ((PBKDF2KeyAndParameterSpec)algorithmParameterSpec).getPrf()) != null) {
            String string = this.getClass().getName();
            if (!string.endsWith("PBKDF2") && !algorithmID.equals(this.f)) {
                if (a.equals(algorithmID)) {
                    algorithmID = this.f;
                } else {
                    throw new InvalidAlgorithmParameterException("Illegal prf (" + algorithmID.getAlgorithm().getName() + "). Only " + this.f.getAlgorithm().getName() + " allowed by this engine!");
                }
            }
            try {
                PBKDF2.a(algorithmID);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidAlgorithmParameterException("Cannot get Mac implementation: " + noSuchAlgorithmException.toString());
            }
            this.f = (AlgorithmID)algorithmID.clone();
        }
    }

    private static final Mac a(AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        Mac mac = null;
        NoSuchAlgorithmException noSuchAlgorithmException = null;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                mac = algorithmID.getMacInstance(IAIK.getInstance());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                noSuchAlgorithmException = noSuchAlgorithmException2;
            }
        }
        if (mac == null) {
            try {
                mac = algorithmID.getMacInstance();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException3) {
                throw noSuchAlgorithmException;
            }
        }
        return mac;
    }

    public static final class PBKDF2WithHmacSHA512
    extends PBKDF2 {
        public PBKDF2WithHmacSHA512() {
            super(AlgorithmID.hMAC_SHA512);
        }
    }

    public static final class PBKDF2WithHmacSHA384
    extends PBKDF2 {
        public PBKDF2WithHmacSHA384() {
            super(AlgorithmID.hMAC_SHA384);
        }
    }

    public static final class PBKDF2WithHmacSHA256
    extends PBKDF2 {
        public PBKDF2WithHmacSHA256() {
            super(AlgorithmID.hMAC_SHA256);
        }
    }

    public static final class PBKDF2WithHmacSHA224
    extends PBKDF2 {
        public PBKDF2WithHmacSHA224() {
            super(AlgorithmID.hMAC_SHA224);
        }
    }

    public static final class PBKDF2WithHmacSHA1
    extends PBKDF2 {
        public PBKDF2WithHmacSHA1() {
            super(AlgorithmID.hMAC_SHA1_);
        }
    }
}

