/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.pkcs.pkcs12.SafeBag;

public class SafeContentsBag
extends SafeBag {
    protected SafeBag[] bags;

    protected SafeContentsBag() {
        this.f = ObjectID.pkcs12_safeContentsBag;
    }

    public SafeContentsBag(SafeBag[] safeBagArray) {
        if (safeBagArray == null) {
            throw new NullPointerException("Argument \"bags\" must not be null.");
        }
        this.bags = safeBagArray;
        this.f = ObjectID.pkcs12_safeContentsBag;
    }

    public SafeContentsBag(SafeBag[] safeBagArray, String string, byte[] byArray) {
        super(string, byArray);
        if (safeBagArray == null) {
            throw new NullPointerException("Argument \"bags\" must not be null.");
        }
        this.bags = safeBagArray;
        this.f = ObjectID.pkcs12_safeContentsBag;
    }

    public SafeBag[] getSafeBags() {
        return this.bags;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.bags = SafeBag.parseSafeContents(aSN1Object);
    }

    public ASN1Object toASN1Object() throws CodingException {
        return SafeBag.encodeSafeContentsAsASN1Object(this.bags);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        for (int i2 = 0; i2 < this.bags.length; ++i2) {
            stringBuffer.append("Safe bag #" + i2 + "\n");
            stringBuffer.append(this.bags[i2].toString());
        }
        return stringBuffer.toString();
    }
}

