/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs12.PKCS12PbeAlgorithm;
import iaik.pkcs.pkcs5.PBES2ParameterSpec;
import iaik.pkcs.pkcs5.PBKDF2ParameterSpec;
import iaik.security.provider.IAIK;
import iaik.security.random.SecRandom;
import iaik.utils.IaikSecurity;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Locale;

public class PKCS12Pbes2Algorithm
extends PKCS12PbeAlgorithm {
    public static final PKCS12Pbes2Algorithm PBES2WithHmacSHA256AndAES256 = new PKCS12Pbes2Algorithm((AlgorithmID)AlgorithmID.pbes2.clone(), "PBES2WithHmacSHA256AndAES256", 32, 10000, (AlgorithmID)AlgorithmID.hMAC_SHA256.clone(), (AlgorithmID)AlgorithmID.aes256_CBC.clone(), 32, false);
    public static final PKCS12Pbes2Algorithm PBES2WithHmacSHA256AndAES = new PKCS12Pbes2Algorithm((AlgorithmID)AlgorithmID.pbes2.clone(), "PBES2WithHmacSHA256AndAES", 32, 10000, (AlgorithmID)AlgorithmID.hMAC_SHA256.clone(), (AlgorithmID)AlgorithmID.aes128_CBC.clone(), 16, false);
    public static final PKCS12Pbes2Algorithm PBES2WithHmacSHA1AndAES = new PKCS12Pbes2Algorithm((AlgorithmID)AlgorithmID.pbes2.clone(), "PBES2WithHmacSHA1AndAES", 20, 10000, (AlgorithmID)AlgorithmID.hMAC_SHA1_.clone(), (AlgorithmID)AlgorithmID.aes128_CBC.clone(), 16, false);
    public static final PKCS12Pbes2Algorithm PBES2WithHmacSHA1AndAES256 = new PKCS12Pbes2Algorithm((AlgorithmID)AlgorithmID.pbes2.clone(), "PBES2WithHmacSHA1AndAES256", 20, 10000, (AlgorithmID)AlgorithmID.hMAC_SHA1_.clone(), (AlgorithmID)AlgorithmID.aes256_CBC.clone(), 32, false);
    public static final PKCS12Pbes2Algorithm PBES2WithHmacSHA224AndAES = new PKCS12Pbes2Algorithm((AlgorithmID)AlgorithmID.pbes2.clone(), "PBES2WithHmacSHA224AndAES", 28, 10000, (AlgorithmID)AlgorithmID.hMAC_SHA224.clone(), (AlgorithmID)AlgorithmID.aes128_CBC.clone(), 16, false);
    public static final PKCS12Pbes2Algorithm PBES2WithHmacSHA224AndAES256 = new PKCS12Pbes2Algorithm((AlgorithmID)AlgorithmID.pbes2.clone(), "PBES2WithHmacSHA224AndAES256", 28, 10000, (AlgorithmID)AlgorithmID.hMAC_SHA224.clone(), (AlgorithmID)AlgorithmID.aes256_CBC.clone(), 32, false);
    public static final PKCS12Pbes2Algorithm PBES2WithHmacSHA384AndAES = new PKCS12Pbes2Algorithm((AlgorithmID)AlgorithmID.pbes2.clone(), "PBES2WithHmacSHA384AndAES", 48, 10000, (AlgorithmID)AlgorithmID.hMAC_SHA384.clone(), (AlgorithmID)AlgorithmID.aes128_CBC.clone(), 16, false);
    public static final PKCS12Pbes2Algorithm PBES2WithHmacSHA384AndAES192 = new PKCS12Pbes2Algorithm((AlgorithmID)AlgorithmID.pbes2.clone(), "PBES2WithHmacSHA384AndAES192", 48, 10000, (AlgorithmID)AlgorithmID.hMAC_SHA384.clone(), (AlgorithmID)AlgorithmID.aes192_CBC.clone(), 24, false);
    public static final PKCS12Pbes2Algorithm PBES2WithHmacSHA384AndAES256 = new PKCS12Pbes2Algorithm((AlgorithmID)AlgorithmID.pbes2.clone(), "PBES2WithHmacSHA384AndAES256", 48, 10000, (AlgorithmID)AlgorithmID.hMAC_SHA384.clone(), (AlgorithmID)AlgorithmID.aes256_CBC.clone(), 32, false);
    public static final PKCS12Pbes2Algorithm PBES2WithHmacSHA512AndAES = new PKCS12Pbes2Algorithm((AlgorithmID)AlgorithmID.pbes2.clone(), "PBES2WithHmacSHA512AndAES", 64, 10000, (AlgorithmID)AlgorithmID.hMAC_SHA512.clone(), (AlgorithmID)AlgorithmID.aes128_CBC.clone(), 16, false);
    public static final PKCS12Pbes2Algorithm PBES2WithHmacSHA512AndAES256 = new PKCS12Pbes2Algorithm((AlgorithmID)AlgorithmID.pbes2.clone(), "PBES2WithHmacSHA512AndAES256", 64, 10000, (AlgorithmID)AlgorithmID.hMAC_SHA512.clone(), (AlgorithmID)AlgorithmID.aes256_CBC.clone(), 32, false);
    private AlgorithmID i;
    private AlgorithmID j;
    private int k;
    static Class h;

    public static final PKCS12Pbes2Algorithm getPKCS12Pbes2Algorithm(String string) {
        PKCS12Pbes2Algorithm pKCS12Pbes2Algorithm = null;
        if (string != null) {
            if ((string = string.toUpperCase(Locale.US)).equals("PBES2WITHHMACSHA256ANDAES256") || string.equals("PBEWITHHMACSHA256ANDAES_256")) {
                pKCS12Pbes2Algorithm = PBES2WithHmacSHA256AndAES256;
            } else if (string.equals("PBES2WITHHMACSHA256ANDAES") || string.equals("PBEWITHHMACSHA256ANDAES")) {
                pKCS12Pbes2Algorithm = PBES2WithHmacSHA256AndAES;
            } else if (string.equals("PBES2WITHHMACSHA1ANDAES") || string.equals("PBEWITHHMACSHA1ANDAES")) {
                pKCS12Pbes2Algorithm = PBES2WithHmacSHA1AndAES;
            } else if (string.equals("PBES2WITHHMACSHA1ANDAES256") || string.equals("PBEWITHHMACSHA1ANDAES_256")) {
                pKCS12Pbes2Algorithm = PBES2WithHmacSHA1AndAES256;
            } else if (string.equals("PBES2WITHHMACSHA224ANDAES") || string.equals("PBEWITHHMACSHA224ANDAES")) {
                pKCS12Pbes2Algorithm = PBES2WithHmacSHA224AndAES;
            } else if (string.equals("PBES2WITHHMACSHA224ANDAES256") || string.equals("PBEWITHHMACSHA224ANDAES_256")) {
                pKCS12Pbes2Algorithm = PBES2WithHmacSHA224AndAES256;
            } else if (string.equals("PBES2WITHHMACSHA384ANDAES") || string.equals("PBEWITHHMACSHA384ANDAES")) {
                pKCS12Pbes2Algorithm = PBES2WithHmacSHA384AndAES;
            } else if (string.equals("PBES2WITHHMACSHA384ANDAES192") || string.equals("PBEWITHHMACSHA384ANDAES_192")) {
                pKCS12Pbes2Algorithm = PBES2WithHmacSHA384AndAES192;
            } else if (string.equals("PBES2WITHHMACSHA384ANDAES256") || string.equals("PBEWITHHMACSHA384ANDAES_256")) {
                pKCS12Pbes2Algorithm = PBES2WithHmacSHA384AndAES256;
            } else if (string.equals("PBES2WITHHMACSHA512ANDAES") || string.equals("PBEWITHHMACSHA512ANDAES")) {
                pKCS12Pbes2Algorithm = PBES2WithHmacSHA512AndAES;
            } else if (string.equals("PBES2WITHHMACSHA512ANDAES256") || string.equals("PBEWITHHMACSHA512ANDAES_256")) {
                pKCS12Pbes2Algorithm = PBES2WithHmacSHA512AndAES256;
            }
        }
        if (pKCS12Pbes2Algorithm != null) {
            pKCS12Pbes2Algorithm = (PKCS12Pbes2Algorithm)pKCS12Pbes2Algorithm.clone();
        }
        return pKCS12Pbes2Algorithm;
    }

    PKCS12Pbes2Algorithm(AlgorithmID algorithmID) throws InvalidAlgorithmParameterException {
        super(algorithmID);
    }

    PKCS12Pbes2Algorithm(AlgorithmID algorithmID, String string, int n2, int n3, AlgorithmID algorithmID2, AlgorithmID algorithmID3, int n4) {
        this(algorithmID, string, n2, n3, algorithmID2, algorithmID3, n4, true);
    }

    PKCS12Pbes2Algorithm(AlgorithmID algorithmID, String string, int n2, int n3, AlgorithmID algorithmID2, AlgorithmID algorithmID3, int n4, boolean bl) {
        super(algorithmID, string, n2, n3, bl);
        this.i = algorithmID2;
        this.j = algorithmID3;
        this.k = n4;
    }

    AlgorithmParameterSpec d() throws InvalidAlgorithmParameterException {
        ASN1Object aSN1Object;
        AlgorithmParameterSpec algorithmParameterSpec = this.f;
        if (algorithmParameterSpec == null && this.a != null && (aSN1Object = this.a.getParameter()) != null && !aSN1Object.isA(ASN.NULL)) {
            if (IaikSecurity.getTryIAIKProviderFirst()) {
                try {
                    algorithmParameterSpec = this.a.getAlgorithmParameterSpec(h == null ? (h = PKCS12Pbes2Algorithm.class$("iaik.pkcs.pkcs5.PBES2ParameterSpec")) : h, IAIK.getInstance());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    // empty catch block
                }
            }
            if (algorithmParameterSpec == null) {
                algorithmParameterSpec = this.a.getAlgorithmParameterSpec();
            }
            if (algorithmParameterSpec != null) {
                PBES2ParameterSpec pBES2ParameterSpec = (PBES2ParameterSpec)algorithmParameterSpec;
                this.setIterationCount(pBES2ParameterSpec.getIterationCount());
                this.setSalt(pBES2ParameterSpec.getSalt());
                this.i = pBES2ParameterSpec.getPrf();
                this.j = pBES2ParameterSpec.getEncryptionScheme();
                this.k = pBES2ParameterSpec.getDerivedKeyLength();
            }
            this.f = algorithmParameterSpec;
        }
        return algorithmParameterSpec;
    }

    AlgorithmParameterSpec e() throws InvalidAlgorithmParameterException {
        Object object;
        if (this.c < 8) {
            if (this.c < 1) {
                this.c = 20;
            } else {
                throw new InvalidAlgorithmParameterException("Salt length not set. Must be 8 at least!");
            }
        }
        if (this.e < 1) {
            this.e = 10000;
        }
        if (this.i == null) {
            this.i = (AlgorithmID)AlgorithmID.hMAC_SHA256.clone();
        }
        if (this.j == null) {
            this.j = (AlgorithmID)AlgorithmID.aes256_CBC.clone();
            this.k = 32;
        }
        SecureRandom secureRandom = SecRandom.getDefault();
        byte[] byArray = new byte[this.c];
        secureRandom.nextBytes(byArray);
        AlgorithmID algorithmID = (AlgorithmID)this.i.clone();
        algorithmID.setParameter(null);
        AlgorithmID algorithmID2 = (AlgorithmID)this.j.clone();
        algorithmID2.setParameter(null);
        try {
            object = null;
            if (IaikSecurity.getTryIAIKProviderFirst()) {
                try {
                    object = algorithmID2.getAlgorithmParameterGeneratorInstance(IAIK.getInstance());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            if (object == null) {
                object = algorithmID2.getAlgorithmParameterGeneratorInstance();
            }
            if (object != null) {
                AlgorithmParameters algorithmParameters = ((AlgorithmParameterGenerator)object).generateParameters();
                algorithmID2.setAlgorithmParameters(algorithmParameters);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new PBES2ParameterSpec(byArray, this.e, this.k, algorithmID2);
        ((PBKDF2ParameterSpec)object).setPrf(algorithmID);
        return object;
    }

    AlgorithmID g() {
        return this.i;
    }

    AlgorithmID h() {
        return this.j;
    }

    public Object clone() {
        PKCS12Pbes2Algorithm pKCS12Pbes2Algorithm = null;
        pKCS12Pbes2Algorithm = (PKCS12Pbes2Algorithm)super.clone();
        if (this.i != null) {
            pKCS12Pbes2Algorithm.i = (AlgorithmID)this.i.clone();
        }
        if (this.j != null) {
            pKCS12Pbes2Algorithm.j = (AlgorithmID)this.j.clone();
        }
        pKCS12Pbes2Algorithm.k = this.k;
        return pKCS12Pbes2Algorithm;
    }

    public boolean equals(Object object) {
        boolean bl = super.equals(object);
        if (bl && object instanceof PKCS12Pbes2Algorithm) {
            PKCS12Pbes2Algorithm pKCS12Pbes2Algorithm = (PKCS12Pbes2Algorithm)object;
            if (this.i != null && pKCS12Pbes2Algorithm.i != null && !(bl = this.i.equals(pKCS12Pbes2Algorithm.i)) && (AlgorithmID.hMAC_SHA1.equals(this.i) || AlgorithmID.hMAC_SHA1_.equals(this.i))) {
                boolean bl2 = bl = AlgorithmID.hMAC_SHA1.equals(pKCS12Pbes2Algorithm.i) || AlgorithmID.hMAC_SHA1_.equals(pKCS12Pbes2Algorithm.i);
            }
            if (bl && this.j != null && pKCS12Pbes2Algorithm.j != null) {
                bl = this.j.equals(pKCS12Pbes2Algorithm.j);
            }
        }
        return bl;
    }

    public String toString() {
        String string = super.toString();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        if (this.j != null) {
            stringBuffer.append("\n  encryption scheme: " + this.j.getName());
        }
        if (this.i != null) {
            stringBuffer.append("\n  prf: " + this.i.getName());
        }
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

