/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs12.PKCS12Algorithm;
import iaik.pkcs.pkcs12.PKCS12Pbes2Algorithm;
import iaik.security.provider.IAIK;
import iaik.security.random.SecRandom;
import iaik.utils.IaikSecurity;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class PKCS12PbeAlgorithm
extends PKCS12Algorithm {
    public static final PKCS12PbeAlgorithm NONE = new PKCS12PbeAlgorithm();
    public static final PKCS12PbeAlgorithm PBEWithSHAAnd40BitRC2_CBC = new PKCS12PbeAlgorithm((AlgorithmID)AlgorithmID.pbeWithSHAAnd40BitRC2_CBC.clone(), "PBEWithSHA1AndRC2_40", 20, 10000, false);
    public static final PKCS12PbeAlgorithm PBEWithSHAAnd3_KeyTripleDES_CBC = new PKCS12PbeAlgorithm((AlgorithmID)AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC.clone(), "PBEWithSHA1AndDESede", 20, 10000, false);

    public static final PKCS12PbeAlgorithm getPKCS12PbeAlgorithm(String string) {
        PKCS12PbeAlgorithm pKCS12PbeAlgorithm = null;
        if (string != null) {
            if ((string = string.toUpperCase(Locale.US)).equals("PBEWITHSHA1ANDRC2_40") || string.equals("PBEWITHSHAAND40BITRC2-CBC")) {
                pKCS12PbeAlgorithm = PBEWithSHAAnd40BitRC2_CBC;
            } else if (string.equals("PBEWITHSHA1ANDDESEDE") || string.equals("PBEWITHSHAAND3-KEYTRIPLEDES-CBC")) {
                pKCS12PbeAlgorithm = PBEWithSHAAnd3_KeyTripleDES_CBC;
            } else if (string.equals("NONE")) {
                pKCS12PbeAlgorithm = NONE;
            }
        }
        if (pKCS12PbeAlgorithm != null) {
            pKCS12PbeAlgorithm = (PKCS12PbeAlgorithm)pKCS12PbeAlgorithm.clone();
        }
        return pKCS12PbeAlgorithm;
    }

    static final PKCS12PbeAlgorithm a(AlgorithmID algorithmID) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        PKCS12PbeAlgorithm pKCS12PbeAlgorithm = null;
        if (AlgorithmID.pbes2.equals(algorithmID)) {
            pKCS12PbeAlgorithm = new PKCS12Pbes2Algorithm(algorithmID);
        } else {
            if (!algorithmID.equals(AlgorithmID.pbeWithSHAAnd40BitRC2_CBC) && !algorithmID.equals(AlgorithmID.pbeWithSHAAnd3_KeyTripleDES_CBC)) {
                throw new NoSuchAlgorithmException("Algorithm " + algorithmID.getName() + " not supported!");
            }
            pKCS12PbeAlgorithm = new PKCS12PbeAlgorithm(algorithmID);
        }
        return pKCS12PbeAlgorithm;
    }

    private PKCS12PbeAlgorithm() {
        super("NONE");
    }

    PKCS12PbeAlgorithm(AlgorithmID algorithmID) throws InvalidAlgorithmParameterException {
        super(algorithmID);
        this.d();
    }

    PKCS12PbeAlgorithm(AlgorithmID algorithmID, String string, int n2, int n3, boolean bl) {
        super(algorithmID, string, n2, n3, bl);
    }

    AlgorithmParameterSpec d() throws InvalidAlgorithmParameterException {
        ASN1Object aSN1Object;
        AlgorithmParameterSpec algorithmParameterSpec = this.f;
        if (algorithmParameterSpec == null && this.a != null && (aSN1Object = this.a.getParameter()) != null && !aSN1Object.isA(ASN.NULL)) {
            if (IaikSecurity.getTryIAIKProviderFirst()) {
                try {
                    algorithmParameterSpec = this.a.getAlgorithmParameterSpec(IAIK.getInstance());
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    // empty catch block
                }
            }
            if (algorithmParameterSpec == null) {
                algorithmParameterSpec = this.a.getAlgorithmParameterSpec();
            }
            if (algorithmParameterSpec != null && algorithmParameterSpec instanceof PBEParameterSpec) {
                PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
                this.setIterationCount(pBEParameterSpec.getIterationCount());
                this.setSalt(pBEParameterSpec.getSalt());
            }
            this.f = algorithmParameterSpec;
        }
        return algorithmParameterSpec;
    }

    AlgorithmParameterSpec e() throws InvalidAlgorithmParameterException {
        if (this.c < 8) {
            if (this.c < 1) {
                this.c = 20;
            } else {
                throw new InvalidAlgorithmParameterException("Salt length not set. Must be 8 at least!");
            }
        }
        if (this.e < 1) {
            this.e = 10000;
        }
        SecureRandom secureRandom = SecRandom.getDefault();
        byte[] byArray = new byte[this.c];
        secureRandom.nextBytes(byArray);
        return new PBEParameterSpec(byArray, this.e);
    }

    AlgorithmID f() throws InvalidAlgorithmParameterException {
        if (this.a == null) {
            throw new InvalidAlgorithmParameterException("AlgorithmID not set!");
        }
        AlgorithmID algorithmID = (AlgorithmID)this.a.clone();
        AlgorithmParameterSpec algorithmParameterSpec = this.e();
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                algorithmID.setAlgorithmParameterSpec(algorithmParameterSpec, IAIK.getInstance());
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                algorithmID.setAlgorithmParameterSpec(algorithmParameterSpec);
            }
        }
        return algorithmID;
    }

    SecretKey a(char[] cArray) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (this.a == null) {
            throw new NoSuchAlgorithmException("AlgorithmID not set!");
        }
        PBEKeySpec pBEKeySpec = new PBEKeySpec(cArray);
        SecretKeyFactory secretKeyFactory = this.a.getSecretKeyFactoryInstance(IAIK.getInstance());
        SecretKey secretKey = secretKeyFactory.generateSecret(pBEKeySpec);
        return secretKey;
    }

    public Object clone() {
        PKCS12PbeAlgorithm pKCS12PbeAlgorithm = null;
        pKCS12PbeAlgorithm = (PKCS12PbeAlgorithm)super.clone();
        return pKCS12PbeAlgorithm;
    }
}

