/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.pkcs.pkcs12.PKCS12Algorithm;
import iaik.pkcs.pkcs12.f;
import iaik.security.cipher.PBEKeyBMP;
import iaik.security.provider.IAIK;
import iaik.security.random.SecRandom;
import iaik.security.spec.PBEKeyAndParameterSpec;
import iaik.utils.CryptoUtils;
import iaik.utils.IaikSecurity;
import java.io.Serializable;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public class PKCS12MacAlgorithm
extends PKCS12Algorithm {
    public static final PKCS12MacAlgorithm NONE = new PKCS12MacAlgorithm();
    public static final PKCS12MacAlgorithm HMAC_SHA1 = new PKCS12MacAlgorithm(AlgorithmID.sha1, "SHA1", 20, 20, 10000, false);
    public static final PKCS12MacAlgorithm HMAC_SHA224 = new PKCS12MacAlgorithm((AlgorithmID)AlgorithmID.sha224.clone(), "SHA224", 28, 28, 10000, false);
    public static final PKCS12MacAlgorithm HMAC_SHA256 = new PKCS12MacAlgorithm(AlgorithmID.sha256, "SHA256", 32, 32, 10000, false);
    public static final PKCS12MacAlgorithm HMAC_SHA384 = new PKCS12MacAlgorithm((AlgorithmID)AlgorithmID.sha384.clone(), "SHA384", 48, 48, 10000, false);
    public static final PKCS12MacAlgorithm HMAC_SHA512 = new PKCS12MacAlgorithm((AlgorithmID)AlgorithmID.sha512.clone(), "SHA512", 64, 64, 10000, false);
    private String i;
    String h;
    private int j;

    public static final PKCS12MacAlgorithm getPKCS12MacAlgorithm(String string) {
        PKCS12MacAlgorithm pKCS12MacAlgorithm = null;
        if (string != null) {
            if ((string = string.toUpperCase(Locale.US)).equals("HMACSHA256") || string.equals("HMACPBESHA256")) {
                pKCS12MacAlgorithm = HMAC_SHA256;
            } else if (string.equals("HMACSHA512") || string.equals("HMACPBESHA512")) {
                pKCS12MacAlgorithm = HMAC_SHA512;
            } else if (string.equals("HMACSHA384") || string.equals("HMACPBESHA384")) {
                pKCS12MacAlgorithm = HMAC_SHA384;
            } else if (string.equals("HMACSHA224") || string.equals("HMACPBESHA224")) {
                pKCS12MacAlgorithm = HMAC_SHA224;
            } else if (string.equals("HMACSHA1") || string.equals("HMACPBESHA1")) {
                pKCS12MacAlgorithm = HMAC_SHA1;
            } else if (string.equals("PBMAC1WITHPBKDF2ANDHMACSHA224")) {
                pKCS12MacAlgorithm = iaik.pkcs.pkcs12.f.i;
            } else if (string.equals("PBMAC1WITHPBKDF2ANDHMACSHA256")) {
                pKCS12MacAlgorithm = iaik.pkcs.pkcs12.f.j;
            } else if (string.equals("PBMAC1WITHPBKDF2ANDHMACSHA384")) {
                pKCS12MacAlgorithm = iaik.pkcs.pkcs12.f.k;
            } else if (string.equals("PBMAC1WITHPBKDF2ANDHMACSHA512")) {
                pKCS12MacAlgorithm = iaik.pkcs.pkcs12.f.l;
            } else if (string.equals("NONE")) {
                pKCS12MacAlgorithm = NONE;
            }
        }
        if (pKCS12MacAlgorithm != null) {
            pKCS12MacAlgorithm = (PKCS12MacAlgorithm)pKCS12MacAlgorithm.clone();
        }
        return pKCS12MacAlgorithm;
    }

    static final PKCS12MacAlgorithm a(AlgorithmID algorithmID, String string, int n2, int n3, int n4) {
        PKCS12MacAlgorithm pKCS12MacAlgorithm = null;
        pKCS12MacAlgorithm = !algorithmID.equals(AlgorithmID.pbmac1) ? new PKCS12MacAlgorithm(algorithmID, string, n2, n3, n4) : new f(algorithmID, n2, n3, n4);
        return pKCS12MacAlgorithm;
    }

    private PKCS12MacAlgorithm() {
        super("NONE");
    }

    PKCS12MacAlgorithm(AlgorithmID algorithmID, String string, int n2, int n3, int n4) {
        this(algorithmID, string, n2, n3, n4, true);
    }

    PKCS12MacAlgorithm(AlgorithmID algorithmID, String string, int n2, int n3, int n4, boolean bl) {
        super(algorithmID, "Hmac" + string, n3, n4, bl);
        this.i = string;
        this.j = n2;
        this.d();
    }

    void d() {
        this.h = "PKCS#12-MAC-" + this.i;
    }

    void a(int n2) {
        if (n2 < 16) {
            throw new IllegalArgumentException("macLength must be 16 at least!");
        }
        this.j = n2;
    }

    byte[] a(byte[] byArray, char[] cArray) throws PKCSException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        Serializable serializable;
        if (this.d == null) {
            serializable = SecRandom.getDefault();
            this.d = new byte[this.c];
            ((SecureRandom)serializable).nextBytes(this.d);
        }
        PKCS12.a(this.d);
        serializable = this.a(cArray);
        byte[] byArray2 = this.a(byArray, (SecretKey)serializable);
        return byArray2;
    }

    boolean a(byte[] byArray, char[] cArray, byte[] byArray2) throws PKCSException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        SecretKey secretKey = this.a(cArray);
        byte[] byArray3 = this.a(byArray, secretKey);
        return CryptoUtils.secureEqualsBlock(byArray3, byArray2);
    }

    SecretKey a(char[] cArray) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        PBEKeyAndParameterSpec pBEKeyAndParameterSpec = new PBEKeyAndParameterSpec(PBEKeyBMP.getEncoded(cArray), this.d, this.e, this.j);
        KeyGenerator keyGenerator = null;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                keyGenerator = IaikSecurity.getKeyGeneratorInstance(this.h, IAIK.getInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (keyGenerator == null) {
            keyGenerator = KeyGenerator.getInstance(this.h);
        }
        keyGenerator.init(pBEKeyAndParameterSpec);
        SecretKey secretKey = keyGenerator.generateKey();
        return secretKey;
    }

    byte[] a(byte[] byArray, SecretKey secretKey) throws PKCSException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        String string = this.b;
        Mac mac = null;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                mac = IaikSecurity.getMacInstance(string, IAIK.getInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (mac == null) {
            mac = Mac.getInstance(string);
        }
        mac.init(secretKey);
        byte[] byArray2 = mac.doFinal(byArray);
        return byArray2;
    }

    public Object clone() {
        PKCS12MacAlgorithm pKCS12MacAlgorithm = null;
        pKCS12MacAlgorithm = (PKCS12MacAlgorithm)super.clone();
        pKCS12MacAlgorithm.i = this.i;
        pKCS12MacAlgorithm.h = this.h;
        pKCS12MacAlgorithm.j = this.j;
        return pKCS12MacAlgorithm;
    }
}

