/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs12.Attributes;
import iaik.pkcs.pkcs12.AuthenticatedSafe;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.pkcs.pkcs12.PKCS12Algorithm;
import iaik.pkcs.pkcs12.PKCS12Algorithms;
import iaik.pkcs.pkcs12.PKCS12MacAlgorithm;
import iaik.pkcs.pkcs12.PKCS12ParsingException;
import iaik.pkcs.pkcs12.PKCS12PbeAlgorithm;
import iaik.pkcs.pkcs12.PKCS12Pbes2Algorithm;
import iaik.pkcs.pkcs12.PKCS8ShroudedKeyBag;
import iaik.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.SubjectKeyIdentifier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Set;
import java.util.Vector;

public class PKCS12KeyStore
extends KeyStoreSpi {
    private static boolean c;
    private static boolean d;
    private Hashtable e = new Hashtable();
    private Hashtable f = new Hashtable();
    PKCS12Algorithms a;
    int b;

    public static final void setUseJKSFallBack(boolean bl) {
        d = bl;
    }

    public static final boolean getUseJKSFallBack() {
        return d;
    }

    public static void addSunTrustedKeyUsageAttributeToCertificateBags(boolean bl) {
        c = bl;
    }

    static boolean a() {
        return c;
    }

    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        this.e.clear();
        this.f.clear();
        if (inputStream != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n2;
            ASN1Type[] aSN1TypeArray;
            Object object5;
            PKCS12 pKCS12;
            try {
                pKCS12 = new PKCS12(inputStream);
                if (pKCS12.containsMacData() && !pKCS12.verify(cArray)) {
                    throw new IOException(this, "PKCS12 verification error, incorrect password"){
                        private static final long serialVersionUID = -6777747744926386667L;
                        private final PKCS12KeyStore a;
                        {
                            this.a = pKCS12KeyStore;
                        }

                        public Throwable getCause() {
                            return new UnrecoverableKeyException("PKCS12 verification error, incorrect password");
                        }
                    };
                }
                this.a = pKCS12.b();
            }
            catch (PKCSException pKCSException) {
                throw new PKCS12ParsingException(pKCSException.toString());
            }
            AuthenticatedSafe[] authenticatedSafeArray = pKCS12.getAuthenticatedSafes();
            Vector<Object> vector = new Vector<Object>();
            Vector<Object> vector2 = new Vector<Object>();
            boolean bl = false;
            boolean bl2 = false;
            for (int i2 = 0; i2 < authenticatedSafeArray.length; ++i2) {
                if (authenticatedSafeArray[i2].b() == 2) {
                    try {
                        authenticatedSafeArray[i2].decrypt(cArray);
                    }
                    catch (Exception exception) {
                        throw new CertificateException("Decryption error: " + exception.toString());
                    }
                    bl = true;
                    object5 = authenticatedSafeArray[i2].c();
                    if (object5 != null) {
                        if (this.a == null) {
                            this.a = new PKCS12Algorithms();
                        }
                        this.a.setAuthSafesCipherAlg((PKCS12PbeAlgorithm)object5);
                    }
                    aSN1TypeArray = authenticatedSafeArray[i2].getSafeBags();
                    for (n2 = 0; n2 < aSN1TypeArray.length; ++n2) {
                        if (aSN1TypeArray[n2] instanceof CertificateBag) {
                            vector2.addElement(aSN1TypeArray[n2]);
                            continue;
                        }
                        if (!(aSN1TypeArray[n2] instanceof PKCS8ShroudedKeyBag)) continue;
                        try {
                            ((PKCS8ShroudedKeyBag)aSN1TypeArray[n2]).decrypt(cArray);
                            object4 = ((PKCS8ShroudedKeyBag)aSN1TypeArray[n2]).toASN1Object();
                            object3 = new PKCS8ShroudedKeyBag();
                            ((PKCS8ShroudedKeyBag)object3).decode((ASN1Object)object4);
                            ((Attributes)object3).setFriendlyName(((Attributes)((Object)aSN1TypeArray[n2])).getFriendlyName());
                            ((Attributes)object3).setLocalKeyID(((Attributes)((Object)aSN1TypeArray[n2])).getLocalKeyID());
                            vector.addElement(object3);
                            object2 = ((PKCS8ShroudedKeyBag)object3).b();
                            if (object2 == null) continue;
                            if (this.a == null) {
                                this.a = new PKCS12Algorithms();
                            }
                            this.a.setKeyBagCipherAlg((PKCS12PbeAlgorithm)object2);
                            continue;
                        }
                        catch (CodingException codingException) {
                            throw new CertificateException(codingException.toString());
                        }
                        catch (GeneralSecurityException generalSecurityException) {
                            throw new CertificateException(generalSecurityException.toString());
                        }
                    }
                    continue;
                }
                object5 = authenticatedSafeArray[i2].getSafeBags();
                for (int i3 = 0; i3 < ((Object[])object5).length; ++i3) {
                    if (object5[i3] instanceof KeyBag) {
                        PKCS12PbeAlgorithm pKCS12PbeAlgorithm;
                        if (object5[i3] instanceof PKCS8ShroudedKeyBag && (pKCS12PbeAlgorithm = ((PKCS8ShroudedKeyBag)object5[i3]).b()) != null) {
                            if (this.a == null) {
                                this.a = new PKCS12Algorithms();
                            }
                            this.a.setKeyBagCipherAlg(pKCS12PbeAlgorithm);
                        }
                        vector.addElement(object5[i3]);
                        continue;
                    }
                    if (!(object5[i3] instanceof CertificateBag)) continue;
                    vector2.addElement(object5[i3]);
                    if (!bl) {
                        if (this.a == null) {
                            this.a = new PKCS12Algorithms();
                        }
                        this.a.setAuthSafesCipherAlg(PKCS12PbeAlgorithm.NONE);
                    }
                    if (!c || bl2 || !((CertificateBag)object5[i3]).b()) continue;
                    bl2 = true;
                }
            }
            Object[] objectArray = new KeyBag[vector.size()];
            vector.copyInto(objectArray);
            object5 = new CertificateBag[vector2.size()];
            vector2.copyInto((Object[])object5);
            aSN1TypeArray = CertificateBag.getCertificates((CertificateBag[])object5);
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                ASN1Type[] aSN1TypeArray2;
                String string;
                Object object6;
                block49: {
                    object4 = objectArray[n2];
                    object3 = null;
                    object2 = null;
                    object = ((Attributes)object4).getLocalKeyID();
                    try {
                        String string2;
                        boolean bl3 = false;
                        if (object != null) {
                            for (int i4 = 0; i4 < ((Object[])object5).length; ++i4) {
                                object6 = ((Attributes)object5[i4]).getLocalKeyID();
                                if (object6 == null || !CryptoUtils.equalsBlock(object6, object)) continue;
                                object3 = object5[i4];
                                object2 = ((CertificateBag)object3).getCertificate();
                                string = ((Attributes)object4).getFriendlyName();
                                if (string != null) {
                                    for (int i5 = 0; i5 < ((Object[])object5).length; ++i5) {
                                        String string3 = ((Attributes)object5[i5]).getFriendlyName();
                                        if (string3 == null || !string.equals(string3) || (object6 = ((Attributes)object5[i5]).getLocalKeyID()) == null || !CryptoUtils.equalsBlock(object6, object)) continue;
                                        object3 = object5[i5];
                                        object2 = ((CertificateBag)object3).getCertificate();
                                        break;
                                    }
                                }
                                bl3 = true;
                                break;
                            }
                        }
                        if (!bl3 && (string2 = ((Attributes)object4).getFriendlyName()) != null) {
                            for (int i6 = 0; i6 < ((Object[])object5).length; ++i6) {
                                string = ((Attributes)object5[i6]).getFriendlyName();
                                if (string == null || !string2.equals(string)) continue;
                                object3 = object5[i6];
                                object2 = ((CertificateBag)object3).getCertificate();
                                bl3 = true;
                                break;
                            }
                        }
                        if (!bl3) {
                            throw new Exception("No localKeyID or friendlyName match!");
                        }
                    }
                    catch (Exception exception) {
                        throw new CertificateException(exception.toString());
                    }
                    aSN1TypeArray2 = null;
                    if (object2 != null) {
                        try {
                            aSN1TypeArray2 = Util.createCertificateChain((X509Certificate)object2, (Certificate[])aSN1TypeArray);
                        }
                        catch (Exception exception) {
                            try {
                                aSN1TypeArray2 = Util.arrangeCertificateChain((X509Certificate[])aSN1TypeArray, false);
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            if (aSN1TypeArray2 != null) break block49;
                            aSN1TypeArray2 = aSN1TypeArray;
                        }
                    }
                }
                b b2 = new b((KeyBag)object4, (X509Certificate[])aSN1TypeArray2, (byte[])object);
                object6 = ((Attributes)object4).getFriendlyName();
                if (object6 == null && object3 != null) {
                    Principal principal;
                    string = ((Attributes)object3).getFriendlyName();
                    if (string != null) {
                        object6 = string;
                    } else if (object2 != null && (principal = ((X509Certificate)object2).getSubjectDN()) != null) {
                        object6 = principal.getName();
                    }
                }
                if (object6 == null || this.e.containsKey(object6)) {
                    object6 = Integer.toString(n2);
                    for (int i7 = n2; this.e.containsKey(object6) && i7 < Integer.MAX_VALUE; ++i7) {
                        object6 = Integer.toString(i7);
                    }
                }
                this.e.put(object6, b2);
            }
            for (n2 = 0; n2 < ((Object[])object5).length; ++n2) {
                boolean bl4 = false;
                object3 = object5[n2];
                object2 = ((CertificateBag)object3).getCertificate();
                object = ((Attributes)object3).getFriendlyName();
                if (bl2) {
                    if (((CertificateBag)object3).b()) {
                        bl4 = true;
                        if (object == null) {
                            object = Attributes.a((X509Certificate)object2);
                        }
                    }
                } else if (object != null && !this.e.containsKey(object)) {
                    bl4 = true;
                }
                if (!bl4 || object == null) continue;
                this.f.put(object, new a(((CertificateBag)object3).getCertificate()));
            }
        }
    }

    public Enumeration engineAliases() {
        Vector vector = new Vector(this.e.size() + this.f.size());
        Set set = this.e.keySet();
        vector.addAll(set);
        Set set2 = this.f.keySet();
        vector.addAll(set2);
        return vector.elements();
    }

    public boolean engineContainsAlias(String string) {
        boolean bl = false;
        if (string != null) {
            bl = this.e.containsKey(string) || this.f.containsKey(string);
        }
        return bl;
    }

    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (string != null) {
            this.e.remove(string);
            this.f.remove(string);
        }
    }

    public Certificate engineGetCertificate(String string) {
        X509Certificate x509Certificate = null;
        if (string != null) {
            X509Certificate[] x509CertificateArray;
            b b2;
            a a2 = (a)this.f.get(string);
            if (a2 != null) {
                x509Certificate = a2.a();
            }
            if (x509Certificate == null && (b2 = (b)this.e.get(string)) != null && (x509CertificateArray = b2.b()) != null && x509CertificateArray.length > 0) {
                x509Certificate = x509CertificateArray[0];
            }
        }
        return x509Certificate;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Object object;
        String string;
        Enumeration enumeration = this.e.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.engineGetCertificateChain(string);
            if (((Certificate[])object).length <= 0 || !object[0].equals(certificate)) continue;
            return string;
        }
        enumeration = this.f.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            object = this.engineGetCertificate(string);
            if (object == null || !((Certificate)object).equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        b b2;
        X509Certificate[] x509CertificateArray = null;
        if (string != null && (b2 = (b)this.e.get(string)) != null) {
            x509CertificateArray = b2.b();
        }
        return x509CertificateArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Date engineGetCreationDate(String string) {
        Date date = null;
        if (!this.engineContainsAlias(string)) return date;
        b b2 = (b)this.e.get(string);
        if (b2 != null) {
            byte[] byArray = b2.c();
            try {
                String string2 = new String(byArray, "ASCII");
                return new Date(Long.parseLong(string2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ProviderException(unsupportedEncodingException.toString());
            }
            catch (NumberFormatException numberFormatException) {
                X509Certificate[] x509CertificateArray = b2.b();
                if (x509CertificateArray == null) return date;
                if (x509CertificateArray.length <= 0) return date;
                return x509CertificateArray[0].getNotBefore();
            }
        }
        a a2 = (a)this.f.get(string);
        return a2.a().getNotBefore();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        PrivateKey privateKey = null;
        if (string == null) return privateKey;
        b b2 = (b)this.e.get(string);
        if (b2 == null) return privateKey;
        KeyBag keyBag = b2.a();
        if (!(keyBag instanceof PKCS8ShroudedKeyBag)) return keyBag.getPrivateKey();
        try {
            PKCS8ShroudedKeyBag pKCS8ShroudedKeyBag = (PKCS8ShroudedKeyBag)keyBag;
            ASN1Object aSN1Object = pKCS8ShroudedKeyBag.toASN1Object();
            PKCS8ShroudedKeyBag pKCS8ShroudedKeyBag2 = new PKCS8ShroudedKeyBag();
            pKCS8ShroudedKeyBag2.decode(aSN1Object);
            pKCS8ShroudedKeyBag2.decrypt(cArray);
            privateKey = pKCS8ShroudedKeyBag2.getPrivateKey();
            PKCS12PbeAlgorithm pKCS12PbeAlgorithm = pKCS8ShroudedKeyBag2.b();
            if (pKCS12PbeAlgorithm == null) return privateKey;
            if (this.a == null) {
                this.a = new PKCS12Algorithms();
            }
            this.a.setKeyBagCipherAlg(pKCS12PbeAlgorithm);
            return privateKey;
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new UnrecoverableKeyException(generalSecurityException.toString());
        }
        catch (CodingException codingException) {
            throw new UnrecoverableKeyException(codingException.toString());
        }
    }

    public boolean engineIsCertificateEntry(String string) {
        return string != null ? this.f.containsKey(string) : false;
    }

    public boolean engineIsKeyEntry(String string) {
        return string != null ? this.e.containsKey(string) : false;
    }

    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        if (string == null) {
            throw new NullPointerException("alias must not be null");
        }
        if (certificate == null) {
            throw new NullPointerException("cert must not be null");
        }
        if (this.e.get(string) != null) {
            throw new KeyStoreException("Alias \"" + string + "\" already used for KeyEntry!");
        }
        this.f.put(string, new a((X509Certificate)certificate));
    }

    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        X509Certificate[] x509CertificateArray;
        PKCS8ShroudedKeyBag pKCS8ShroudedKeyBag;
        Object object;
        if (string == null) {
            throw new NullPointerException("alias must not be null");
        }
        if (byArray == null) {
            throw new NullPointerException("key must not be null");
        }
        if (certificateArray == null) {
            throw new NullPointerException("chain must not be null");
        }
        if (certificateArray.length == 0) {
            throw new NullPointerException("chain must not be empty");
        }
        if (this.f.get(string) != null) {
            throw new KeyStoreException("Alias \"" + string + "\" already used for CertEntry!");
        }
        byte[] byArray2 = this.a(certificateArray[0], string);
        try {
            object = new EncryptedPrivateKeyInfo(byArray);
            ASN1Object aSN1Object = ((EncryptedPrivateKeyInfo)object).toASN1Object();
            pKCS8ShroudedKeyBag = new PKCS8ShroudedKeyBag();
            pKCS8ShroudedKeyBag.decode(aSN1Object);
            pKCS8ShroudedKeyBag.setFriendlyName(string);
            pKCS8ShroudedKeyBag.setLocalKeyID(byArray2);
            x509CertificateArray = Util.convertCertificateChain(certificateArray);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new KeyStoreException(invalidKeyException.toString());
        }
        catch (CodingException codingException) {
            throw new KeyStoreException(codingException.toString());
        }
        catch (CertificateException certificateException) {
            throw new KeyStoreException(certificateException.toString());
        }
        object = new b(pKCS8ShroudedKeyBag, x509CertificateArray, byArray2);
        this.e.put(string, object);
    }

    private byte[] a(Certificate certificate, String string) {
        byte[] byArray = null;
        try {
            long l2 = System.currentTimeMillis();
            String string2 = Long.toString(l2);
            byArray = string2.getBytes("ASCII");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray == null) {
            try {
                byArray = new SubjectKeyIdentifier(certificate.getPublicKey()).get();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (byArray == null && string != null) {
            try {
                byArray = string.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    byArray = string.getBytes("UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    byArray = string.getBytes();
                }
            }
        }
        if (byArray == null) {
            Random random = new Random();
            byArray = new byte[10];
            random.nextBytes(byArray);
        }
        return byArray;
    }

    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        X509Certificate[] x509CertificateArray;
        Object object;
        if (string == null) {
            throw new NullPointerException("alias must not be null!");
        }
        if (key == null) {
            throw new NullPointerException("key must not be null!");
        }
        if (certificateArray == null) {
            throw new NullPointerException("chain must not be null!");
        }
        if (!(key instanceof PrivateKey)) {
            throw new KeyStoreException("Only PrivateKey entries supported!");
        }
        if (this.f.get(string) != null) {
            throw new KeyStoreException("Alias \"" + string + "\" already used for CertEntry!");
        }
        byte[] byArray = this.a(certificateArray[0], string);
        KeyBag keyBag = null;
        try {
            object = this.a;
            if (object == null || PKCS12Algorithms.a()) {
                object = PKCS12Algorithms.getDefault();
            }
            PKCS12PbeAlgorithm pKCS12PbeAlgorithm = ((PKCS12Algorithms)object).getKeyBagCipherAlg();
            keyBag = new KeyBag((PrivateKey)key, string, byArray);
            keyBag.setLocalKeyID(byArray);
            if (!PKCS12PbeAlgorithm.NONE.equals(pKCS12PbeAlgorithm)) {
                AlgorithmID algorithmID = pKCS12PbeAlgorithm.f();
                PKCS8ShroudedKeyBag pKCS8ShroudedKeyBag = new PKCS8ShroudedKeyBag(keyBag);
                pKCS8ShroudedKeyBag.encrypt(cArray, algorithmID, pKCS12PbeAlgorithm.getIterationCount());
                keyBag = pKCS8ShroudedKeyBag;
                PKCS12.a(algorithmID, pKCS12PbeAlgorithm instanceof PKCS12Pbes2Algorithm);
                pKCS12PbeAlgorithm = pKCS8ShroudedKeyBag.b();
            } else if (!PKCS12Algorithms.b()) {
                throw new PKCSException("NONE encryption for KeyBags not supported!");
            }
            x509CertificateArray = Util.convertCertificateChain(certificateArray);
            if (pKCS12PbeAlgorithm != null) {
                if (this.a == null) {
                    this.a = new PKCS12Algorithms();
                }
                this.a.setKeyBagCipherAlg(pKCS12PbeAlgorithm);
            }
        }
        catch (Exception exception) {
            throw new KeyStoreException(this, exception.getMessage(), exception){
                private final Exception a;
                private final PKCS12KeyStore b;
                {
                    this.b = pKCS12KeyStore;
                    this.a = exception;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
        object = new b(keyBag, x509CertificateArray, byArray);
        this.e.put(string, object);
    }

    public int engineSize() {
        return this.e.size() + this.f.size();
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Object object;
        Object object2;
        Object object3;
        Object[] objectArray;
        Object[] objectArray2;
        Vector<KeyBag> vector = new Vector<KeyBag>(2);
        Vector<Object> vector2 = new Vector<Object>(4);
        Enumeration enumeration = this.e.keys();
        while (enumeration.hasMoreElements()) {
            objectArray2 = (Object[])enumeration.nextElement();
            objectArray = (b)this.e.get(objectArray2);
            object3 = objectArray.a();
            vector.addElement((KeyBag)object3);
            object2 = objectArray.b();
            object = new CertificateBag(object2[0], (String)objectArray2, objectArray.c());
            vector2.addElement(object);
            for (int i2 = 1; i2 < ((Object)object2).length; ++i2) {
                object = new CertificateBag((X509Certificate)object2[i2]);
                vector2.addElement(object);
            }
        }
        enumeration = this.f.keys();
        while (enumeration.hasMoreElements()) {
            objectArray2 = (String)enumeration.nextElement();
            objectArray = (a)this.f.get(objectArray2);
            object3 = objectArray.a();
            object2 = new CertificateBag((X509Certificate)object3);
            ((Attributes)object2).setFriendlyName((String)objectArray2);
            if (c) {
                ((CertificateBag)object2).a();
            }
            vector2.addElement(object2);
        }
        objectArray2 = new KeyBag[vector.size()];
        vector.copyInto(objectArray2);
        objectArray = new CertificateBag[vector2.size()];
        vector2.copyInto(objectArray);
        try {
            object3 = this.a;
            if (object3 == null || PKCS12Algorithms.a()) {
                object3 = PKCS12Algorithms.getDefault();
            }
            object2 = ((PKCS12Algorithms)object3).getAuthSafesCipherAlg();
            object = ((PKCS12Algorithms)object3).getKeyBagCipherAlg();
            PKCS12MacAlgorithm pKCS12MacAlgorithm = ((PKCS12Algorithms)object3).getMacAlg();
            int n2 = ((PKCS12Algorithm)object2).equals(PKCS12PbeAlgorithm.NONE) ? 1 : 2;
            PKCS12 pKCS12 = new PKCS12((KeyBag[])objectArray2, (CertificateBag[])objectArray, n2, true);
            pKCS12.setBlockSize(this.b);
            pKCS12.a(pKCS12MacAlgorithm);
            boolean bl = !PKCS12Algorithms.a();
            pKCS12.a(cArray, (PKCS12PbeAlgorithm)object2, (PKCS12PbeAlgorithm)object, bl, bl);
            pKCS12.writeTo(outputStream);
        }
        catch (PKCSException pKCSException) {
            throw new CertificateException(pKCSException.toString());
        }
    }

    static {
        d = true;
    }

    private static class a {
        private X509Certificate a;

        a(X509Certificate x509Certificate) {
            this.a = x509Certificate;
        }

        public X509Certificate a() {
            return this.a;
        }
    }

    private static class b {
        private KeyBag a;
        private X509Certificate[] b;
        private byte[] c;

        b(KeyBag keyBag, X509Certificate[] x509CertificateArray, byte[] byArray) {
            this.a = keyBag;
            this.b = x509CertificateArray;
            this.c = byArray;
        }

        public KeyBag a() {
            return this.a;
        }

        public X509Certificate[] b() {
            return this.b;
        }

        public byte[] c() {
            return this.c;
        }
    }
}

