/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.structures.AlgorithmID;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public abstract class PKCS12Algorithm
implements Cloneable {
    AlgorithmID a;
    String b;
    int c;
    byte[] d;
    int e;
    AlgorithmParameterSpec f;
    boolean g;

    PKCS12Algorithm(String string) {
        this.b = string;
        this.g = true;
    }

    PKCS12Algorithm(AlgorithmID algorithmID) {
        this.a = algorithmID;
        try {
            this.b = algorithmID.getJcaStandardName();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            try {
                this.b = algorithmID.getImplementationName();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                this.b = algorithmID.getName();
            }
        }
        this.g = true;
    }

    PKCS12Algorithm(AlgorithmID algorithmID, String string, int n2, int n3, boolean bl) {
        this.a = algorithmID;
        this.b = string;
        if (!AlgorithmID.pbmac1.equals(algorithmID)) {
            if (n2 < 8) {
                throw new IllegalArgumentException("saltLength must 8 at least!");
            }
            if (n3 < 1) {
                throw new IllegalArgumentException("iterationCount must be positive!");
            }
        }
        this.c = n2;
        this.e = n3;
        this.g = bl;
    }

    AlgorithmID a() {
        return this.a;
    }

    String b() {
        return this.b;
    }

    public void setIterationCount(int n2) {
        if (!this.g) {
            throw new IllegalArgumentException("Changing of default iteration count not allowed. Use a PKCS12Algorithm clone!");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("iterationCount must be positive!");
        }
        this.e = n2;
    }

    public int getIterationCount() {
        return this.e;
    }

    public void setSaltLength(int n2) {
        if (!this.g) {
            throw new IllegalArgumentException("Changing of default salt length not allowed. Use a PKCS12Algorithm clone!");
        }
        if (n2 < 8) {
            throw new IllegalArgumentException("saltLength must 8 at least!");
        }
        this.c = n2;
    }

    public int getSaltLength() {
        return this.c;
    }

    public void setSalt(byte[] byArray) {
        if (byArray != null) {
            this.setSaltLength(byArray.length);
        }
        this.d = byArray;
    }

    byte[] c() {
        return this.d;
    }

    void a(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec != null) {
            if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidAlgorithmParameterException("paramSpec must be a PbeParameterSpec!");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            this.setIterationCount(pBEParameterSpec.getIterationCount());
            this.setSalt(pBEParameterSpec.getSalt());
        }
        this.f = algorithmParameterSpec;
    }

    public Object clone() {
        PKCS12Algorithm pKCS12Algorithm = null;
        try {
            pKCS12Algorithm = (PKCS12Algorithm)super.clone();
            if (this.a != null) {
                pKCS12Algorithm.a = (AlgorithmID)this.a.clone();
            }
            pKCS12Algorithm.b = this.b;
            pKCS12Algorithm.e = this.e;
            pKCS12Algorithm.c = this.c;
            if (this.d != null) {
                pKCS12Algorithm.d = (byte[])this.d.clone();
            }
            pKCS12Algorithm.g = true;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return pKCS12Algorithm;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        }
        if (object instanceof PKCS12Algorithm) {
            PKCS12Algorithm pKCS12Algorithm = (PKCS12Algorithm)object;
            if (this.a != null && pKCS12Algorithm.a != null) {
                bl = this.a.equals(pKCS12Algorithm.a);
            } else if (this.b != null && pKCS12Algorithm.b != null) {
                bl = this.b.equals(pKCS12Algorithm.b);
            }
            if (bl) {
                boolean bl2 = bl = this.c == pKCS12Algorithm.c;
                if (bl) {
                    bl = this.e == pKCS12Algorithm.e;
                }
            }
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.b;
        if (string == null && this.a != null) {
            string = this.a.getName();
        }
        if (string == null) {
            string = "";
        }
        stringBuffer.append(string);
        if (!string.equals("NONE")) {
            stringBuffer.append("\n  salt length: " + this.c);
            stringBuffer.append("\n  iteration count: " + this.e);
        }
        return stringBuffer.toString();
    }
}

