/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs12.Attributes;
import iaik.pkcs.pkcs12.AuthenticatedSafe;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12Algorithm;
import iaik.pkcs.pkcs12.PKCS12Algorithms;
import iaik.pkcs.pkcs12.PKCS12MacAlgorithm;
import iaik.pkcs.pkcs12.PKCS12PbeAlgorithm;
import iaik.pkcs.pkcs12.PKCS12Pbes2Algorithm;
import iaik.pkcs.pkcs12.PKCS8ShroudedKeyBag;
import iaik.pkcs.pkcs12.SafeBag;
import iaik.pkcs.pkcs5.PBES2ParameterSpec;
import iaik.pkcs.pkcs7.ContentInfo;
import iaik.pkcs.pkcs7.Data;
import iaik.pkcs.pkcs7.DigestInfo;
import iaik.pkcs.pkcs8.EncryptedPrivateKeyInfo;
import iaik.security.random.SecRandom;
import iaik.utils.ComparableByteArray;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class PKCS12 {
    public static final int PUBLIC_KEY_INTEGRITY_MODE = 1;
    public static final int PASSWORD_INTEGRITY_MODE = 2;
    static int a = 1024;
    private static List h;
    protected AuthenticatedSafe[] authenticated_safes;
    protected int mode = 0;
    private int i = 3;
    PKCS12Algorithms b;
    SEQUENCE c = null;
    ASN1Object d = null;
    byte[] e;
    KeyBag[] f;
    boolean g = true;
    private int j = a;

    static void a(boolean bl) {
        if (bl) {
            if (h == null) {
                h = new ArrayList();
            }
        } else if (h != null) {
            h.clear();
            h = null;
        }
    }

    static void a(byte[] byArray) throws PKCSException {
        if (h != null) {
            ComparableByteArray comparableByteArray = new ComparableByteArray(byArray);
            if (h.contains(comparableByteArray)) {
                throw new PKCSException("Duplicate Salt/Iv value detected!");
            }
            h.add(comparableByteArray);
        }
    }

    static void a(AlgorithmID algorithmID, boolean bl) throws PKCSException {
        if (h != null) {
            PKCS12PbeAlgorithm pKCS12PbeAlgorithm = null;
            try {
                pKCS12PbeAlgorithm = bl ? new PKCS12Pbes2Algorithm(algorithmID) : new PKCS12PbeAlgorithm(algorithmID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (pKCS12PbeAlgorithm != null) {
                PKCS12.a(pKCS12PbeAlgorithm);
            }
        }
    }

    static void a(PKCS12Algorithm pKCS12Algorithm) throws PKCSException {
        if (h != null) {
            if (pKCS12Algorithm instanceof PKCS12PbeAlgorithm) {
                AlgorithmParameterSpec algorithmParameterSpec = null;
                try {
                    algorithmParameterSpec = ((PKCS12PbeAlgorithm)pKCS12Algorithm).d();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (algorithmParameterSpec instanceof PBEParameterSpec) {
                    PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
                    byte[] byArray = pBEParameterSpec.getSalt();
                    if (byArray != null) {
                        PKCS12.a(byArray);
                    }
                    if (algorithmParameterSpec instanceof PBES2ParameterSpec) {
                        byte[] byArray2;
                        PBES2ParameterSpec pBES2ParameterSpec = (PBES2ParameterSpec)algorithmParameterSpec;
                        AlgorithmParameterSpec algorithmParameterSpec2 = null;
                        try {
                            algorithmParameterSpec2 = pBES2ParameterSpec.getEncryptionSchemeParameters();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (algorithmParameterSpec2 instanceof IvParameterSpec && (byArray2 = ((IvParameterSpec)algorithmParameterSpec2).getIV()) != null) {
                            PKCS12.a(byArray2);
                        }
                    }
                }
            } else {
                byte[] byArray = pKCS12Algorithm.c();
                if (byArray != null) {
                    PKCS12.a(byArray);
                }
            }
        }
    }

    public static void setDefaultBlockSize(int n2) {
        a = n2;
    }

    static int a() {
        return a;
    }

    private PKCS12() {
    }

    public PKCS12(KeyBag keyBag, CertificateBag[] certificateBagArray) throws PKCSException {
        this(keyBag, certificateBagArray, true);
    }

    public PKCS12(KeyBag keyBag, CertificateBag[] certificateBagArray, boolean bl) throws PKCSException {
        this(new KeyBag[]{keyBag}, certificateBagArray, bl);
    }

    public PKCS12(KeyBag[] keyBagArray, CertificateBag[] certificateBagArray, boolean bl) throws PKCSException {
        this(keyBagArray, certificateBagArray, 2, bl);
    }

    PKCS12(KeyBag[] keyBagArray, CertificateBag[] certificateBagArray, int n2, boolean bl) throws PKCSException {
        this();
        this.authenticated_safes = new AuthenticatedSafe[2];
        if (keyBagArray != null && keyBagArray.length > 0) {
            Vector<KeyBag> vector = new Vector<KeyBag>();
            boolean bl2 = false;
            for (int i2 = 0; i2 < keyBagArray.length; ++i2) {
                KeyBag keyBag = keyBagArray[i2];
                if (keyBag == null) continue;
                if (keyBag instanceof PKCS8ShroudedKeyBag) {
                    bl2 = true;
                    vector.addElement(keyBag);
                    continue;
                }
                if (PKCS12Algorithms.b()) {
                    if (bl2) {
                        throw new IllegalArgumentException("Mixing of encrypted and not encrypted KeyBags not supported!");
                    }
                    vector.addElement(keyBag);
                    continue;
                }
                vector.addElement(new PKCS8ShroudedKeyBag(keyBag));
            }
            this.f = new KeyBag[vector.size()];
            vector.copyInto(this.f);
        }
        if (certificateBagArray != null && certificateBagArray.length > 0) {
            this.authenticated_safes[1] = new AuthenticatedSafe(n2, certificateBagArray, this.j);
        }
        this.mode = 2;
        this.g = bl;
    }

    public PKCS12(InputStream inputStream) throws IOException, PKCSParsingException {
        this();
        try {
            this.d = DerCoder.decode(inputStream);
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException(codingException.getMessage());
        }
        this.decode();
    }

    public PKCS12(ASN1Object aSN1Object) throws PKCSParsingException {
        this();
        this.d = aSN1Object;
        this.decode();
    }

    protected void decode() throws PKCSParsingException {
        block11: {
            try {
                if (this.d.getComponentAt(0).isA(ASN.CON_SPEC)) {
                    throw new PKCSParsingException("Key format of Netscape 4.03 and earlier not supportet!");
                }
                this.i = ((BigInteger)this.d.getComponentAt(0).getValue()).intValue();
                ContentInfo contentInfo = new ContentInfo(this.d.getComponentAt(1));
                if (this.d.countComponents() == 3) {
                    this.c = (SEQUENCE)this.d.getComponentAt(2);
                } else {
                    if (this.b == null) {
                        this.b = new PKCS12Algorithms();
                    }
                    this.b.setMacAlg(PKCS12MacAlgorithm.NONE);
                }
                if (contentInfo.getContentType().equals(ObjectID.pkcs7_data)) {
                    this.mode = 2;
                    this.e = ((Data)contentInfo.getContent()).getData();
                    ASN1Object aSN1Object = DerCoder.decode(this.e);
                    this.authenticated_safes = new AuthenticatedSafe[aSN1Object.countComponents()];
                    for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                        this.authenticated_safes[i2] = new AuthenticatedSafe(aSN1Object.getComponentAt(i2));
                    }
                    break block11;
                }
                if (contentInfo.getContentType().equals(ObjectID.pkcs7_signedData)) {
                    this.mode = 1;
                    break block11;
                }
                throw new PKCSParsingException("PKCS#12: Unknown mode!");
            }
            catch (PKCSException pKCSException) {
                throw new PKCSParsingException(pKCSException.toString());
            }
            catch (CodingException codingException) {
                throw new PKCSParsingException(codingException.toString());
            }
            catch (ClassCastException classCastException) {
                throw new PKCSParsingException(classCastException.toString());
            }
        }
    }

    public void decrypt(char[] cArray) throws PKCSException {
        try {
            for (int i2 = 0; i2 < this.authenticated_safes.length; ++i2) {
                this.authenticated_safes[i2].decrypt(cArray);
                PKCS12PbeAlgorithm pKCS12PbeAlgorithm = this.authenticated_safes[i2].c();
                if (pKCS12PbeAlgorithm == null) continue;
                if (this.b == null) {
                    this.b = new PKCS12Algorithms();
                }
                if (this.authenticated_safes[i2].a() == 1) {
                    SafeBag[] safeBagArray = this.authenticated_safes[i2].getSafeBags();
                    if (safeBagArray != null && safeBagArray.length > 0 && safeBagArray[0] instanceof CertificateBag) {
                        this.b.setAuthSafesCipherAlg(pKCS12PbeAlgorithm);
                        continue;
                    }
                    this.b.setKeyBagCipherAlg(pKCS12PbeAlgorithm);
                    continue;
                }
                this.b.setAuthSafesCipherAlg(pKCS12PbeAlgorithm);
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new PKCSException(noSuchAlgorithmException.toString());
        }
    }

    public AuthenticatedSafe[] getAuthenticatedSafes() {
        return this.authenticated_safes;
    }

    public KeyBag getKeyBag() {
        for (int i2 = 0; i2 < this.authenticated_safes.length; ++i2) {
            SafeBag[] safeBagArray = this.authenticated_safes[i2].getSafeBags();
            for (int i3 = 0; i3 < safeBagArray.length; ++i3) {
                if (!(safeBagArray[i3] instanceof KeyBag)) continue;
                return (KeyBag)safeBagArray[i3];
            }
        }
        return null;
    }

    public KeyBag[] getKeyBags() {
        Vector<SafeBag> vector = new Vector<SafeBag>(2);
        for (int i2 = 0; i2 < this.authenticated_safes.length; ++i2) {
            SafeBag[] safeBagArray = this.authenticated_safes[i2].getSafeBags();
            for (int i3 = 0; i3 < safeBagArray.length; ++i3) {
                if (!(safeBagArray[i3] instanceof KeyBag)) continue;
                vector.addElement(safeBagArray[i3]);
            }
        }
        Object[] objectArray = new KeyBag[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public CertificateBag[] getCertificateBags() {
        Vector<SafeBag> vector = new Vector<SafeBag>();
        for (int i2 = 0; i2 < this.authenticated_safes.length; ++i2) {
            SafeBag[] safeBagArray = this.authenticated_safes[i2].getSafeBags();
            for (int i3 = 0; i3 < safeBagArray.length; ++i3) {
                if (!(safeBagArray[i3] instanceof CertificateBag)) continue;
                vector.addElement(safeBagArray[i3]);
            }
        }
        Object[] objectArray = new CertificateBag[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void setPKCS12Algorithms(PKCS12Algorithms pKCS12Algorithms) {
        this.b = pKCS12Algorithms;
    }

    PKCS12Algorithms b() {
        return this.b;
    }

    void a(PKCS12MacAlgorithm pKCS12MacAlgorithm) {
        if (this.b == null) {
            this.b = new PKCS12Algorithms();
        }
        this.b.setMacAlg(pKCS12MacAlgorithm);
    }

    PKCS12MacAlgorithm c() {
        PKCS12MacAlgorithm pKCS12MacAlgorithm = null;
        if (this.b == null) {
            this.b = PKCS12Algorithms.getDefault();
        }
        pKCS12MacAlgorithm = this.b.getMacAlg();
        return pKCS12MacAlgorithm;
    }

    public boolean containsMacData() {
        return this.c != null;
    }

    public boolean verify(char[] cArray) throws PKCSException {
        if (this.c == null) {
            throw new PKCSException("No MacData included!");
        }
        try {
            DigestInfo digestInfo = new DigestInfo(this.c.getComponentAt(0));
            AlgorithmID algorithmID = digestInfo.getDigestAlgorithm();
            String string = algorithmID.getName();
            if (string.startsWith("SHA-")) {
                string = "SHA".concat(string.substring(4));
            }
            byte[] byArray = digestInfo.getDigest();
            int n2 = byArray.length;
            byte[] byArray2 = (byte[])this.c.getComponentAt(1).getValue();
            int n3 = 1;
            if (this.c.countComponents() > 2) {
                n3 = ((BigInteger)this.c.getComponentAt(2).getValue()).intValue();
            }
            PKCS12MacAlgorithm pKCS12MacAlgorithm = PKCS12MacAlgorithm.a(algorithmID, string, n2, byArray2.length, n3);
            pKCS12MacAlgorithm.setSalt(byArray2);
            pKCS12MacAlgorithm.a(n2);
            boolean bl = pKCS12MacAlgorithm.a(this.e, cArray, byArray);
            if (bl) {
                pKCS12MacAlgorithm.setSalt(null);
                this.a(pKCS12MacAlgorithm);
            }
            return bl;
        }
        catch (Exception exception) {
            throw new PKCSException(this, exception.getMessage(), exception){
                private final Exception a;
                private final PKCS12 b;
                {
                    this.b = pKCS12;
                    this.a = exception;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
    }

    public void encrypt(char[] cArray) throws PKCSException {
        this.encrypt(cArray, null, null);
    }

    public void encrypt(char[] cArray, AlgorithmID algorithmID, AlgorithmID algorithmID2) throws PKCSException {
        PKCS12Algorithms pKCS12Algorithms = this.b;
        if (pKCS12Algorithms == null || PKCS12Algorithms.a()) {
            pKCS12Algorithms = PKCS12Algorithms.getDefault();
        }
        PKCS12PbeAlgorithm pKCS12PbeAlgorithm = null;
        PKCS12PbeAlgorithm pKCS12PbeAlgorithm2 = null;
        try {
            if (algorithmID == null) {
                pKCS12PbeAlgorithm = pKCS12Algorithms.getAuthSafesCipherAlg();
            } else {
                PKCS12PbeAlgorithm pKCS12PbeAlgorithm3 = pKCS12PbeAlgorithm = algorithmID.equals(AlgorithmID.pbes2) ? new PKCS12Pbes2Algorithm(algorithmID) : new PKCS12PbeAlgorithm(algorithmID);
            }
            pKCS12PbeAlgorithm2 = algorithmID2 == null ? pKCS12Algorithms.getKeyBagCipherAlg() : (algorithmID2.equals(AlgorithmID.pbes2) ? new PKCS12Pbes2Algorithm(algorithmID2) : new PKCS12PbeAlgorithm(algorithmID2));
            boolean bl = !PKCS12Algorithms.a() && algorithmID2 == null;
            boolean bl2 = !PKCS12Algorithms.a() && algorithmID2 == null;
            this.a(cArray, pKCS12PbeAlgorithm, pKCS12PbeAlgorithm2, bl, bl2);
        }
        catch (PKCSException pKCSException) {
            throw pKCSException;
        }
        catch (Exception exception) {
            throw new PKCSException(this, exception.getMessage(), exception){
                private final Exception a;
                private final PKCS12 b;
                {
                    this.b = pKCS12;
                    this.a = exception;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
    }

    void a(char[] cArray, PKCS12PbeAlgorithm pKCS12PbeAlgorithm, PKCS12PbeAlgorithm pKCS12PbeAlgorithm2, boolean bl, boolean bl2) throws PKCSException {
        try {
            Object object;
            int n2;
            SecureRandom secureRandom = SecRandom.getDefault();
            if (this.f != null && this.f.length > 0) {
                for (n2 = 0; n2 < this.f.length; ++n2) {
                    KeyBag keyBag = this.f[n2];
                    if (!(keyBag instanceof PKCS8ShroudedKeyBag)) {
                        if (PKCS12PbeAlgorithm.NONE.equals(pKCS12PbeAlgorithm2)) {
                            if (PKCS12Algorithms.b()) continue;
                            throw new PKCSException("NONE encryption for KeyBags not supported!");
                        }
                        this.f[n2] = keyBag = new PKCS8ShroudedKeyBag(keyBag);
                    }
                    object = (PKCS8ShroudedKeyBag)keyBag;
                    boolean bl3 = true;
                    EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = ((PKCS8ShroudedKeyBag)object).a();
                    PrivateKey privateKey = encryptedPrivateKeyInfo.getPrivateKeyInfo();
                    PKCS12PbeAlgorithm pKCS12PbeAlgorithm3 = ((PKCS8ShroudedKeyBag)object).b();
                    PKCS12PbeAlgorithm pKCS12PbeAlgorithm4 = null;
                    if (privateKey == null) {
                        bl3 = false;
                        if (!(pKCS12PbeAlgorithm3 == null || pKCS12PbeAlgorithm2.equals(pKCS12PbeAlgorithm3) || PKCS12PbeAlgorithm.NONE.equals(pKCS12PbeAlgorithm2) && !PKCS12Algorithms.b())) {
                            try {
                                encryptedPrivateKeyInfo.decrypt(cArray);
                                bl3 = true;
                            }
                            catch (Exception exception) {
                                bl3 = false;
                            }
                        }
                    } else if (bl2) {
                        pKCS12PbeAlgorithm4 = ((PKCS8ShroudedKeyBag)object).b();
                    }
                    if (!bl3) continue;
                    if (pKCS12PbeAlgorithm4 == null) {
                        pKCS12PbeAlgorithm4 = pKCS12PbeAlgorithm2;
                    }
                    if (PKCS12PbeAlgorithm.NONE.equals(pKCS12PbeAlgorithm4)) {
                        if (!PKCS12Algorithms.b()) {
                            throw new PKCSException("NONE encryption for KeyBags not supported!");
                        }
                        this.f[n2] = new KeyBag(encryptedPrivateKeyInfo.getPrivateKeyInfo());
                        this.f[n2].setAttributes(((Attributes)object).getAttributes());
                        continue;
                    }
                    AlgorithmID algorithmID = pKCS12PbeAlgorithm4.f();
                    int n3 = 1;
                    if (this.g) {
                        n3 = pKCS12PbeAlgorithm4.getIterationCount();
                    } else {
                        pKCS12PbeAlgorithm4 = (PKCS12PbeAlgorithm)pKCS12PbeAlgorithm4.clone();
                        pKCS12PbeAlgorithm4.setIterationCount(n3);
                        algorithmID = pKCS12PbeAlgorithm4.f();
                    }
                    ((PKCS8ShroudedKeyBag)object).encrypt(cArray, algorithmID, secureRandom, n3);
                    PKCS12.a(algorithmID, pKCS12PbeAlgorithm4 instanceof PKCS12Pbes2Algorithm);
                    ((PKCS8ShroudedKeyBag)object).a(pKCS12PbeAlgorithm4);
                    if (this.b == null) {
                        this.b = new PKCS12Algorithms();
                    }
                    this.b.setKeyBagCipherAlg(pKCS12PbeAlgorithm4);
                }
                this.authenticated_safes[0] = new AuthenticatedSafe(1, this.f, this.j);
            }
            for (n2 = 0; n2 < this.authenticated_safes.length; ++n2) {
                if (this.authenticated_safes[n2] == null) continue;
                int n4 = this.authenticated_safes[n2].a();
                if (n4 == 2) {
                    object = null;
                    if (bl) {
                        object = this.authenticated_safes[n2].c();
                    }
                    if (object == null) {
                        object = pKCS12PbeAlgorithm;
                    }
                    this.authenticated_safes[n2].setBlockSize(this.j);
                    if (PKCS12PbeAlgorithm.NONE.equals(object) && this.authenticated_safes[n2].a() == 2) {
                        throw new PKCSException("NONE encryption not allowed for AuthenticatedSafe mode PASSWORD_ENCRYPTED!");
                    }
                    this.authenticated_safes[n2].a(cArray, (PKCS12PbeAlgorithm)object);
                    if (this.b == null) {
                        this.b = new PKCS12Algorithms();
                    }
                    this.b.setAuthSafesCipherAlg((PKCS12PbeAlgorithm)object);
                    continue;
                }
                if (n4 != 3) continue;
                throw new PKCSException("PUBLIC_KEY_ENCRYPTED not implemented");
            }
            if (this.mode == 2) {
                SEQUENCE sEQUENCE = new SEQUENCE();
                for (int i2 = 0; i2 < this.authenticated_safes.length; ++i2) {
                    if (this.authenticated_safes[i2] == null) continue;
                    ((ASN1Object)sEQUENCE).addComponent(this.authenticated_safes[i2].toASN1Object());
                }
                if (((ASN1Object)sEQUENCE).countComponents() == 0) {
                    throw new PKCSException("No key/cert bags set!");
                }
                sEQUENCE.setIndefiniteLength(this.j > 0);
                this.e = DerCoder.encode(sEQUENCE);
                Data data = new Data(this.e);
                data.setBlockSize(this.j);
                object = new ContentInfo(data);
                this.a(cArray);
                this.d = new SEQUENCE();
                this.d.addComponent(new INTEGER(this.i));
                this.d.addComponent(((ContentInfo)object).toASN1Object());
                if (this.c != null) {
                    this.d.addComponent(this.c);
                }
                this.d.setIndefiniteLength(this.j > 0);
            }
        }
        catch (Exception exception) {
            throw new PKCSException(this, exception.getMessage(), exception){
                private final Exception a;
                private final PKCS12 b;
                {
                    this.b = pKCS12;
                    this.a = exception;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
    }

    private void a(char[] cArray) throws PKCSException {
        try {
            PKCS12MacAlgorithm pKCS12MacAlgorithm = null;
            pKCS12MacAlgorithm = PKCS12Algorithms.a() ? PKCS12Algorithms.getDefault().getMacAlg() : this.c();
            this.a(pKCS12MacAlgorithm);
            if (!pKCS12MacAlgorithm.equals(PKCS12MacAlgorithm.NONE)) {
                if (!this.g) {
                    pKCS12MacAlgorithm.setIterationCount(1);
                }
                byte[] byArray = pKCS12MacAlgorithm.a(this.e, cArray);
                DigestInfo digestInfo = new DigestInfo(pKCS12MacAlgorithm.a(), byArray);
                this.c = new SEQUENCE();
                this.c.addComponent(digestInfo.toASN1Object());
                this.c.addComponent(new OCTET_STRING(pKCS12MacAlgorithm.c()));
                int n2 = pKCS12MacAlgorithm.getIterationCount();
                if (n2 != 1) {
                    this.c.addComponent(new INTEGER(n2));
                }
                pKCS12MacAlgorithm.setSalt(null);
            } else {
                this.c = null;
            }
        }
        catch (Exception exception) {
            throw new PKCSException(this, exception.getMessage(), exception){
                private final Exception a;
                private final PKCS12 b;
                {
                    this.b = pKCS12;
                    this.a = exception;
                }

                public Throwable getCause() {
                    return this.a;
                }
            };
        }
    }

    public ASN1Object toASN1Object() throws PKCSException {
        return this.d;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        DerCoder.encodeTo(this.d, outputStream);
    }

    public void setBlockSize(int n2) {
        this.j = n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PKCS#12 object:\n");
        stringBuffer.append("Version: " + this.i + "\n");
        if (this.authenticated_safes == null) {
            stringBuffer.append("No content.\n");
        } else {
            for (int i2 = 0; i2 < this.authenticated_safes.length; ++i2) {
                stringBuffer.append("AuthenticatedSafe: " + i2 + "\n");
                stringBuffer.append(this.authenticated_safes[i2].toString());
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    static {
        Util.toString(null, -1, 1);
    }
}

