/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.pkcs.pkcs12.P12CertEntryProtection;
import iaik.pkcs.pkcs12.P12PasswordProtection;
import iaik.pkcs.pkcs12.P12StoreParameter;
import iaik.pkcs.pkcs12.PKCS12Algorithms;
import iaik.pkcs.pkcs12.PKCS12KeyStore;
import iaik.pkcs.pkcs12.PKCS12MacAlgorithm;
import iaik.pkcs.pkcs12.PKCS12PbeAlgorithm;
import iaik.pkcs.pkcs12.PKCS12Pbes2Algorithm;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class P12KeyStore
extends PKCS12KeyStore {
    public void engineSetEntry(String string, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
        if (entry instanceof KeyStore.TrustedCertificateEntry) {
            Certificate certificate = ((KeyStore.TrustedCertificateEntry)entry).getTrustedCertificate();
            if (certificate == null) {
                throw new KeyStoreException("Cannot add null cert entry!");
            }
            if (protectionParameter != null) {
                if (!(protectionParameter instanceof P12CertEntryProtection)) {
                    throw new KeyStoreException("Only P12CertEntryProtection paramertes supported for TrustedCertificateEntries!");
                }
                String string2 = ((P12CertEntryProtection)protectionParameter).getProtectionAlgorithm();
                try {
                    this.a(string2, false, false);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new KeyStoreException(noSuchAlgorithmException.getMessage());
                }
            }
            this.engineSetCertificateEntry(string, certificate);
        } else if (entry instanceof KeyStore.PrivateKeyEntry) {
            if (protectionParameter == null) {
                throw new KeyStoreException("ProtectionParameter must not be null!");
            }
            if (!(protectionParameter instanceof P12PasswordProtection)) {
                throw new KeyStoreException("Only P12PasswordProtection parameters supported for PrivateKeyEntries!");
            }
            P12PasswordProtection p12PasswordProtection = (P12PasswordProtection)protectionParameter;
            PrivateKey privateKey = ((KeyStore.PrivateKeyEntry)entry).getPrivateKey();
            if (privateKey == null) {
                throw new KeyStoreException("Cannot add null PrivateKey!");
            }
            Certificate[] certificateArray = ((KeyStore.PrivateKeyEntry)entry).getCertificateChain();
            char[] cArray = p12PasswordProtection.getPassword();
            String string3 = p12PasswordProtection.getProtectionAlgorithm();
            try {
                this.a(string3, false, true);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new KeyStoreException(noSuchAlgorithmException.getMessage());
            }
            this.engineSetKeyEntry(string, privateKey, cArray, certificateArray);
        } else {
            throw new KeyStoreException("Unsupported KeyStore entry type: " + entry.getClass().getName() + "!");
        }
    }

    public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
        if (loadStoreParameter == null) {
            throw new NullPointerException("param must not be null!");
        }
        if (!(loadStoreParameter instanceof P12StoreParameter)) {
            throw new InvalidParameterException("Unsupported store parameter. Must be iaik.pkcs.pkcs12.P12StoreParameter!");
        }
        P12StoreParameter p12StoreParameter = (P12StoreParameter)loadStoreParameter;
        OutputStream outputStream = p12StoreParameter.a();
        if (outputStream == null) {
            throw new NullPointerException("Missing output stream in param!");
        }
        KeyStore.PasswordProtection passwordProtection = (KeyStore.PasswordProtection)p12StoreParameter.getProtectionParameter();
        if (passwordProtection == null) {
            throw new NoSuchAlgorithmException("PasswordProtection parameter required!");
        }
        String string = passwordProtection.getProtectionAlgorithm();
        this.a(string, true, false);
        char[] cArray = passwordProtection.getPassword();
        this.b = p12StoreParameter.b();
        super.engineStore(outputStream, cArray);
    }

    private final void a(String string, boolean bl, boolean bl2) throws NoSuchAlgorithmException {
        PKCS12Algorithms pKCS12Algorithms = null;
        if (string != null) {
            if (string.equals("NONE") && bl2 && !PKCS12Algorithms.b()) {
                throw new IllegalArgumentException("NONE encryption not allowed as KeyEntry protection algorithm!");
            }
            pKCS12Algorithms = P12KeyStore.a(string);
            if (pKCS12Algorithms == null) {
                pKCS12Algorithms = this.a;
                if (pKCS12Algorithms != null) {
                    if (bl) {
                        P12KeyStore.a(string, pKCS12Algorithms);
                    } else {
                        P12KeyStore.a(string, pKCS12Algorithms, bl2);
                    }
                } else {
                    try {
                        pKCS12Algorithms = bl ? PKCS12Algorithms.a(string) : PKCS12Algorithms.a(string, bl2);
                    }
                    catch (Exception exception) {
                        throw new NoSuchAlgorithmException(exception.getMessage());
                    }
                    if (pKCS12Algorithms == null) {
                        throw new NoSuchAlgorithmException("Algorithm " + string + " not supported!");
                    }
                }
            }
            this.a = pKCS12Algorithms;
        }
    }

    static final PKCS12Algorithms a(String string) {
        PKCS12Algorithms pKCS12Algorithms = null;
        if (string != null) {
            if (string.equals("DEFAULT")) {
                pKCS12Algorithms = PKCS12Algorithms.getDefault();
            } else if (string.equals("PBES2")) {
                pKCS12Algorithms = (PKCS12Algorithms)PKCS12Algorithms.PBES2.clone();
            } else if (string.equals("PBES1") || string.equals("LEGACY")) {
                pKCS12Algorithms = PKCS12Algorithms.getLegacy();
            }
        }
        return pKCS12Algorithms;
    }

    private static final void a(String string, PKCS12Algorithms pKCS12Algorithms) throws NoSuchAlgorithmException {
        PKCS12MacAlgorithm pKCS12MacAlgorithm = PKCS12MacAlgorithm.getPKCS12MacAlgorithm(string);
        if (pKCS12MacAlgorithm == null) {
            throw new NoSuchAlgorithmException("Mac Algorithm " + string + " not supported!");
        }
        pKCS12Algorithms.setMacAlg(pKCS12MacAlgorithm);
    }

    private static final void a(String string, PKCS12Algorithms pKCS12Algorithms, boolean bl) throws NoSuchAlgorithmException {
        PKCS12PbeAlgorithm pKCS12PbeAlgorithm = P12KeyStore.b(string);
        if (bl) {
            pKCS12Algorithms.setKeyBagCipherAlg(pKCS12PbeAlgorithm);
        } else {
            pKCS12Algorithms.setAuthSafesCipherAlg(pKCS12PbeAlgorithm);
        }
    }

    static final PKCS12PbeAlgorithm b(String string) throws NoSuchAlgorithmException {
        PKCS12PbeAlgorithm pKCS12PbeAlgorithm = PKCS12Pbes2Algorithm.getPKCS12Pbes2Algorithm(string);
        if (pKCS12PbeAlgorithm == null) {
            pKCS12PbeAlgorithm = PKCS12PbeAlgorithm.getPKCS12PbeAlgorithm(string);
        }
        if (pKCS12PbeAlgorithm == null) {
            throw new NoSuchAlgorithmException("Algorithm " + string + " not supported!");
        }
        return pKCS12PbeAlgorithm;
    }
}

