/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Attribute;
import iaik.pkcs.pkcs12.SafeBag;
import iaik.x509.X509Certificate;
import iaik.x509.extensions.ExtendedKeyUsage;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;

public class CertificateBag
extends SafeBag {
    private static final ObjectID n = new ObjectID("2.16.840.1.113894.746875.1.1");
    X509Certificate d;
    ASN1Object e = ObjectID.x509Certificate;

    public static X509Certificate[] getCertificates(CertificateBag[] certificateBagArray) {
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateBagArray.length];
        for (int i2 = 0; i2 < certificateBagArray.length; ++i2) {
            x509CertificateArray[i2] = certificateBagArray[i2].getCertificate();
        }
        return x509CertificateArray;
    }

    protected CertificateBag() {
        this.f = ObjectID.pkcs12_certBag;
    }

    public CertificateBag(X509Certificate x509Certificate) {
        this();
        this.d = x509Certificate;
    }

    public CertificateBag(X509Certificate x509Certificate, String string, byte[] byArray) {
        super(string, byArray);
        this.d = x509Certificate;
        this.f = ObjectID.pkcs12_certBag;
    }

    void a() {
        ASN1Object[] aSN1ObjectArray = new ASN1Object[]{ExtendedKeyUsage.anyExtendedKeyUsage};
        this.c.addAttribute(new Attribute(n, aSN1ObjectArray), true);
    }

    boolean b() {
        boolean bl = this.c.getAttribute(n) != null;
        return bl;
    }

    public X509Certificate getCertificate() {
        return this.d;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.e = aSN1Object.getComponentAt(0);
        ASN1Object aSN1Object2 = (ASN1Object)aSN1Object.getComponentAt(1).getValue();
        try {
            this.d = new X509Certificate((byte[])aSN1Object2.getValue());
        }
        catch (CertificateException certificateException) {
            throw new CodingException("Error decoding certifcate! " + certificateException);
        }
    }

    public ASN1Object toASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.e);
        try {
            OCTET_STRING oCTET_STRING = new OCTET_STRING(this.d.getEncoded());
            sEQUENCE.addComponent(new CON_SPEC(0, oCTET_STRING));
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CodingException("Error encoding certificate!" + certificateEncodingException);
        }
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Certificate type: " + this.d.getType() + "\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

