/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs12.CertificateBag;
import iaik.pkcs.pkcs12.KeyBag;
import iaik.pkcs.pkcs12.PKCS12;
import iaik.pkcs.pkcs12.PKCS12PbeAlgorithm;
import iaik.pkcs.pkcs12.PKCS12Pbes2Algorithm;
import iaik.pkcs.pkcs12.PKCS8ShroudedKeyBag;
import iaik.pkcs.pkcs12.SafeBag;
import iaik.pkcs.pkcs7.Content;
import iaik.pkcs.pkcs7.ContentInfo;
import iaik.pkcs.pkcs7.Data;
import iaik.pkcs.pkcs7.EncryptedContentInfo;
import iaik.pkcs.pkcs7.EncryptedData;
import iaik.pkcs.pkcs7.EncryptedDataStream;
import iaik.security.provider.IAIK;
import iaik.utils.IaikSecurity;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;

public class AuthenticatedSafe
implements ASN1Type {
    public static final int UNENCRYPTED = 1;
    public static final int PASSWORD_ENCRYPTED = 2;
    public static final int PUBLIC_KEY_ENCRYPTED = 3;
    EncryptedContentInfo a;
    private ContentInfo c;
    private int d;
    SafeBag[] b;
    private int e;
    private PKCS12PbeAlgorithm f;

    public AuthenticatedSafe(int n2, SafeBag[] safeBagArray) throws PKCSException {
        this(n2, safeBagArray, PKCS12.a);
    }

    public AuthenticatedSafe(int n2, SafeBag[] safeBagArray, int n3) throws PKCSException {
        block5: {
            this.e = n3;
            this.d = n2;
            this.b = safeBagArray;
            try {
                byte[] byArray = SafeBag.encodeSafeContents(this.b);
                if (n2 == 2) {
                    this.a = new EncryptedContentInfo(ObjectID.pkcs7_data, byArray);
                    this.a.setBlockSize(this.e);
                    break block5;
                }
                if (n2 == 3) {
                    throw new RuntimeException("PUBLIC_KEY_ENCRYPTED not implemented");
                }
                if (n2 == 1) {
                    Data data = new Data(byArray);
                    data.setBlockSize(this.e);
                    this.c = new ContentInfo(data);
                    break block5;
                }
                throw new PKCSException("Unknown mode!");
            }
            catch (CodingException codingException) {
                throw new PKCSException("Unknown mode! " + codingException);
            }
        }
    }

    public AuthenticatedSafe(ASN1Object aSN1Object) throws PKCSParsingException {
        this.e = PKCS12.a;
        try {
            this.decode(aSN1Object);
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException(codingException.toString());
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            this.c = new ContentInfo(aSN1Object);
        }
        catch (PKCSParsingException pKCSParsingException) {
            throw new CodingException(pKCSParsingException.toString());
        }
        if (this.c.getContentType().equals(ObjectID.pkcs7_encryptedData)) {
            this.d = 2;
            EncryptedData encryptedData = (EncryptedData)this.c.getContent();
            this.a = (EncryptedContentInfo)encryptedData.getEncryptedContentInfo();
        } else {
            if (this.c.getContentType().equals(ObjectID.pkcs7_envelopedData)) {
                this.d = 3;
                throw new CodingException("public-key encrypted not implemented.");
            }
            if (this.c.getContentType().equals(ObjectID.pkcs7_data)) {
                this.d = 1;
                byte[] byArray = ((Data)this.c.getContent()).getData();
                this.b = SafeBag.parseSafeContents(byArray);
            } else {
                throw new CodingException("Unknown content type in AuthenticatedSafes.");
            }
        }
    }

    public ASN1Object toASN1Object() throws CodingException {
        try {
            return this.c.toASN1Object();
        }
        catch (PKCSException pKCSException) {
            throw new CodingException(pKCSException.toString());
        }
    }

    public void encrypt(char[] cArray, AlgorithmID algorithmID) throws NoSuchAlgorithmException, PKCSException {
        switch (this.d) {
            case 2: {
                Object object;
                if (algorithmID == null) {
                    throw new NullPointerException("Algorithm must not be null!");
                }
                try {
                    object = PKCS12PbeAlgorithm.a(algorithmID);
                    this.a(cArray, (PKCS12PbeAlgorithm)object);
                }
                catch (Exception exception) {
                    throw new PKCSException(this, exception.getMessage(), exception){
                        private final Exception a;
                        private final AuthenticatedSafe b;
                        {
                            this.b = authenticatedSafe;
                            this.a = exception;
                        }

                        public Throwable getCause() {
                            return this.a;
                        }
                    };
                }
                object = new EncryptedData(this.a);
                ((EncryptedDataStream)object).setBlockSize(this.e);
                this.c = new ContentInfo((Content)object);
                break;
            }
            case 3: {
                throw new RuntimeException("PUBLIC_KEY_ENCRYPTED not implemented");
            }
            case 1: {
                break;
            }
            default: {
                throw new PKCSException("Unknown mode!");
            }
        }
    }

    void a(char[] cArray, PKCS12PbeAlgorithm pKCS12PbeAlgorithm) throws NoSuchAlgorithmException, PKCSException {
        switch (this.d) {
            case 2: {
                Object object;
                try {
                    object = (AlgorithmID)pKCS12PbeAlgorithm.a().clone();
                    AlgorithmParameterSpec algorithmParameterSpec = pKCS12PbeAlgorithm.e();
                    if (IaikSecurity.getTryIAIKProviderFirst()) {
                        try {
                            ((AlgorithmID)object).setAlgorithmParameterSpec(algorithmParameterSpec, IAIK.getInstance());
                        }
                        catch (Exception exception) {
                            try {
                                ((AlgorithmID)object).setAlgorithmParameterSpec(algorithmParameterSpec);
                            }
                            catch (Exception exception2) {
                                ((AlgorithmID)object).setAlgorithmParameterSpec(algorithmParameterSpec);
                            }
                        }
                    }
                    SecretKey secretKey = pKCS12PbeAlgorithm.a(cArray);
                    this.a(secretKey, (AlgorithmID)object, algorithmParameterSpec);
                    PKCS12.a((AlgorithmID)object, pKCS12PbeAlgorithm instanceof PKCS12Pbes2Algorithm);
                    this.a(pKCS12PbeAlgorithm);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw noSuchAlgorithmException;
                }
                catch (Exception exception) {
                    throw new PKCSException(this, exception.toString(), exception){
                        private final Exception a;
                        private final AuthenticatedSafe b;
                        {
                            this.b = authenticatedSafe;
                            this.a = exception;
                        }

                        public Throwable getCause() {
                            return this.a;
                        }
                    };
                }
                object = new EncryptedData(this.a);
                ((EncryptedDataStream)object).setBlockSize(this.e);
                this.c = new ContentInfo((Content)object);
                break;
            }
            case 3: {
                throw new RuntimeException("PUBLIC_KEY_ENCRYPTED not implemented");
            }
            case 1: {
                break;
            }
            default: {
                throw new PKCSException("Unknown mode!");
            }
        }
    }

    void a(SecretKey secretKey, AlgorithmID algorithmID, AlgorithmParameterSpec algorithmParameterSpec) throws NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException {
        this.a.setupCipher(algorithmID, secretKey, algorithmParameterSpec);
        EncryptedData encryptedData = new EncryptedData(this.a);
        encryptedData.setBlockSize(this.e);
        this.c = new ContentInfo(encryptedData);
    }

    public void decrypt(char[] cArray) throws PKCSException, NoSuchAlgorithmException {
        Object object;
        switch (this.d) {
            case 2: {
                try {
                    AlgorithmID algorithmID = this.a.getContentEncryptionAlgorithm();
                    object = PKCS12PbeAlgorithm.a(algorithmID);
                    AlgorithmParameterSpec algorithmParameterSpec = ((PKCS12PbeAlgorithm)object).d();
                    SecretKey secretKey = ((PKCS12PbeAlgorithm)object).a(cArray);
                    this.a.setupCipher(secretKey, algorithmParameterSpec);
                    byte[] byArray = this.a.getContent();
                    ASN1Object aSN1Object = DerCoder.decode(byArray);
                    this.b = SafeBag.parseSafeContents(DerCoder.encode(aSN1Object));
                    this.f = object;
                    this.f.setSalt(null);
                    this.f.a((AlgorithmParameterSpec)null);
                    break;
                }
                catch (Exception exception) {
                    throw new PKCSException(exception.toString());
                }
            }
            case 3: {
                throw new PKCSException("privacy mode PUBLIC_KEY_ENCRYPTED not implemented.");
            }
            case 1: {
                break;
            }
            default: {
                throw new PKCSException("Unknown authenticated safes mode.");
            }
        }
        if (this.b != null) {
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                if (this.b[i2] instanceof PKCS8ShroudedKeyBag) {
                    try {
                        object = (PKCS8ShroudedKeyBag)this.b[i2];
                        ((PKCS8ShroudedKeyBag)object).decrypt(cArray);
                        if (this.d != 1 || this.f != null) continue;
                        this.f = ((PKCS8ShroudedKeyBag)object).b();
                        if (this.f == null) continue;
                        this.f.setSalt(null);
                        this.f.a((AlgorithmParameterSpec)null);
                        continue;
                    }
                    catch (GeneralSecurityException generalSecurityException) {
                        throw new PKCSException("Unable to decrypt PrivateKey! " + generalSecurityException);
                    }
                }
                if (!(this.b[i2] instanceof CertificateBag) && !(this.b[i2] instanceof KeyBag) || this.f != null) continue;
                this.f = PKCS12PbeAlgorithm.NONE;
            }
        }
    }

    public SafeBag[] getSafeBags() {
        return this.b;
    }

    public void setBlockSize(int n2) {
        this.e = n2;
    }

    int a() {
        return this.d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("mode: ");
        switch (this.d) {
            case 1: {
                stringBuffer.append("UNENCRYPTED\n");
                break;
            }
            case 2: {
                stringBuffer.append("PASSWORD_ENCRYPTED\n");
                stringBuffer.append("Content encrypted with: " + this.a.getContentEncryptionAlgorithm().getName() + "\n");
                break;
            }
            case 3: {
                stringBuffer.append("PUBLIC_KEY_ENCRYPTED\n");
                break;
            }
        }
        if (this.b == null) {
            stringBuffer.append("No SafeBags or not decrypted yet.\n");
        } else {
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                stringBuffer.append("\nSafeBag: " + i2 + "\n");
                stringBuffer.append(this.b[i2].toString());
            }
        }
        return stringBuffer.toString();
    }

    int b() {
        return this.d;
    }

    void a(PKCS12PbeAlgorithm pKCS12PbeAlgorithm) throws InvalidAlgorithmParameterException {
        pKCS12PbeAlgorithm.setSalt(null);
        pKCS12PbeAlgorithm.a((AlgorithmParameterSpec)null);
        this.f = pKCS12PbeAlgorithm;
    }

    PKCS12PbeAlgorithm c() {
        return this.f;
    }
}

