/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs10;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCSException;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs10.CertRequest;
import iaik.security.provider.IAIK;
import iaik.utils.IaikSecurity;
import iaik.utils.Util;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Vector;

public class CertificateRequest
implements CertRequest,
Serializable {
    private static final long serialVersionUID = 3287043426874812366L;
    private ASN1 b;
    private int c = 0;
    private Name d;
    private PublicKey e;
    private AlgorithmID f;
    private byte[] g;
    private Attribute[] h;
    private boolean i;
    private byte[] j;
    static Class a;

    public CertificateRequest(InputStream inputStream) throws IOException, PKCSParsingException {
        try {
            this.b = new ASN1(inputStream);
            this.d();
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException(codingException.toString());
        }
    }

    public CertificateRequest(byte[] byArray) throws PKCSParsingException {
        try {
            this.b = new ASN1(byArray);
            this.d();
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException(codingException.toString());
        }
    }

    public CertificateRequest(PublicKey publicKey, Name name) throws InvalidKeyException {
        this.e = publicKey;
        this.d = name;
        this.a();
        this.c = 0;
    }

    private void a() {
        this.i = true;
        this.j = null;
        this.b = null;
    }

    private void b() {
        if (this.i) {
            throw new RuntimeException("Cannot perform operation, certificate has to be signed first");
        }
    }

    private void c() {
        this.i = false;
    }

    private void d() throws PKCSParsingException {
        try {
            ASN1Object aSN1Object = this.b.getComponentAt(0);
            this.f = new AlgorithmID(this.b.getComponentAt(1));
            ASN1Object aSN1Object2 = this.b.getComponentAt(2);
            this.g = (byte[])((BIT_STRING)aSN1Object2).getValue();
            this.c = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
            this.d = new Name(aSN1Object.getComponentAt(1));
            try {
                this.e = PublicKeyInfo.getPublicKey(aSN1Object.getComponentAt(2));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new PKCSParsingException("Unable to create PublicKey: " + invalidKeyException.toString());
            }
            if (aSN1Object.countComponents() > 3) {
                ASN1Object aSN1Object3 = aSN1Object.getComponentAt(3);
                ((CON_SPEC)aSN1Object3).forceImplicitlyTagged(ASN.SEQUENCE);
                if (aSN1Object3.getAsnType().getTag() == 0) {
                    this.h = (Attribute[])ASN.parseSequenceOf((ASN1Object)aSN1Object3.getValue(), a == null ? (a = CertificateRequest.class$("iaik.asn1.structures.Attribute")) : a);
                } else {
                    throw new PKCSParsingException("Unknown context specific tag: " + aSN1Object3.getAsnType().getTag());
                }
            }
            this.b.clearASN1Object();
            this.c();
        }
        catch (RuntimeException runtimeException) {
            throw new PKCSParsingException("Certificate request format error: " + runtimeException.toString());
        }
        catch (CodingException codingException) {
            throw new PKCSParsingException(codingException.toString());
        }
    }

    private ASN1Object e() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new INTEGER(this.c));
        sEQUENCE.addComponent(this.d.toASN1Object());
        sEQUENCE.addComponent(DerCoder.decode(this.e.getEncoded()));
        if (this.h != null) {
            sEQUENCE.addComponent(new CON_SPEC(0, ASN.createSetOf(this.h), true));
        } else {
            sEQUENCE.addComponent(new CON_SPEC(0, new SET(), true));
        }
        return sEQUENCE;
    }

    public byte[] getCertificateRequestInfo() throws PKCSException {
        try {
            if (this.b != null && this.b.toByteArray() != null) {
                return this.b.getFirstObject();
            }
            return DerCoder.encode(this.e());
        }
        catch (CodingException codingException) {
            throw new PKCSException(codingException.toString());
        }
    }

    public void addAttribute(Attribute attribute) {
        if (this.h == null) {
            this.h = new Attribute[]{attribute};
            return;
        }
        Attribute[] attributeArray = new Attribute[this.h.length + 1];
        System.arraycopy(this.h, 0, attributeArray, 0, this.h.length);
        attributeArray[this.h.length] = attribute;
        this.h = attributeArray;
        this.a();
    }

    public void setAttributes(Attribute[] attributeArray) {
        this.h = attributeArray;
        this.a();
    }

    public Attribute[] getAttributes() {
        return this.h;
    }

    public Attribute[] getAttributes(ObjectID objectID) {
        if (this.h == null) {
            return null;
        }
        Vector<Attribute> vector = new Vector<Attribute>();
        for (int i2 = 0; i2 < this.h.length; ++i2) {
            Attribute attribute = this.h[i2];
            if (!attribute.getType().equals(objectID)) continue;
            vector.addElement(this.h[i2]);
        }
        if (vector.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Attribute[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Attribute getAttribute(ObjectID objectID) {
        if (this.h == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.h.length; ++i2) {
            if (!this.h[i2].getType().equals(objectID)) continue;
            return this.h[i2];
        }
        return null;
    }

    public AttributeValue getAttributeValue(ObjectID objectID) throws PKCSException {
        Attribute attribute = this.getAttribute(objectID);
        if (attribute != null) {
            try {
                return attribute.getAttributeValue();
            }
            catch (CodingException codingException) {
                throw new PKCSException("Cannot decode attribute " + objectID.getName() + ": " + codingException.getMessage());
            }
        }
        return null;
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.a(algorithmID, privateKey, null, null, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, String string) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.a(algorithmID, privateKey, null, string, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec, String string) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.a(algorithmID, privateKey, algorithmParameterSpec, string, null);
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, Provider provider) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        try {
            this.a(algorithmID, privateKey, null, null, provider);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    public void sign(AlgorithmID algorithmID, PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec, Provider provider) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this.a(algorithmID, privateKey, algorithmParameterSpec, null, provider);
    }

    private void a(AlgorithmID algorithmID, PrivateKey privateKey, AlgorithmParameterSpec algorithmParameterSpec, String string, Provider provider) throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        Object object;
        Signature signature;
        if (privateKey == null) {
            throw new InvalidKeyException("Cannot sign this request. No private key specified!");
        }
        if (algorithmID == null) {
            throw new NoSuchAlgorithmException("Cannot sign this request. No algorithm specified!");
        }
        this.f = algorithmID;
        Signature signature2 = signature = provider != null ? this.f.getSignatureInstance(provider) : this.f.getSignatureInstance(string);
        if (algorithmParameterSpec != null) {
            signature.setParameter(algorithmParameterSpec);
        }
        signature.initSign(privateKey);
        try {
            if (!AlgorithmID.getDoNotIncludeParameters(this.f) && !this.f.hasParameters() && (object = Util.getSignatureParameters(signature)) != null) {
                this.f.setAlgorithmParameters((AlgorithmParameters)object);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.a();
            object = this.e();
            signature.update(DerCoder.encode((ASN1Object)object));
            this.g = signature.sign();
            BIT_STRING bIT_STRING = new BIT_STRING(this.g);
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)object);
            sEQUENCE.addComponent(this.f.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.b = new ASN1(sEQUENCE);
            this.c();
        }
        catch (CodingException codingException) {
            throw new SignatureException("Cann't sign CertRequest!");
        }
    }

    public void setSignature(AlgorithmID algorithmID, byte[] byArray) throws SignatureException {
        if (algorithmID == null) {
            throw new SignatureException("Cannot sign this request. No signature algorithm specified!");
        }
        if (byArray == null) {
            throw new SignatureException("Cannot sign this request. No signature value specified!");
        }
        this.f = algorithmID;
        this.g = byArray;
        try {
            this.a();
            ASN1Object aSN1Object = this.e();
            BIT_STRING bIT_STRING = new BIT_STRING(this.g);
            SEQUENCE sEQUENCE = null;
            sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(aSN1Object);
            sEQUENCE.addComponent(this.f.toASN1Object());
            sEQUENCE.addComponent(bIT_STRING);
            this.b = new ASN1(sEQUENCE);
            this.c();
        }
        catch (CodingException codingException) {
            throw new SignatureException("Cann't sign CertRequest!");
        }
    }

    public boolean verify() throws SignatureException {
        return this.a(null, null);
    }

    public boolean verify(String string) throws SignatureException {
        return this.a(string, null);
    }

    public boolean verify(Provider provider) throws SignatureException {
        return this.a(null, provider);
    }

    private boolean a(String string, Provider provider) throws SignatureException {
        this.b();
        try {
            Signature signature = provider != null ? this.f.getSignatureInstance(provider) : this.f.getSignatureInstance(string);
            byte[] byArray = this.b.getFirstObject();
            signature.initVerify(this.e);
            signature.update(byArray);
            return signature.verify(this.g);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.getMessage());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SignatureException(noSuchAlgorithmException.getMessage());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new SignatureException(invalidKeyException.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.write(this.toByteArray());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.b = new ASN1(objectInputStream);
            this.d();
        }
        catch (CodingException codingException) {
            throw new IOException("Unable to restore CertificateRequest: " + codingException.toString());
        }
        catch (PKCSParsingException pKCSParsingException) {
            throw new IOException("Unable to restore CertificateRequest: " + pKCSParsingException.toString());
        }
    }

    public byte[] toByteArray() {
        this.b();
        return this.b.toByteArray();
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.b();
        this.b.writeTo(outputStream);
    }

    public int getVersion() {
        return this.c;
    }

    public AlgorithmID getSignatureAlgorithmID() {
        return this.f;
    }

    public Name getSubject() {
        return this.d;
    }

    public PublicKey getPublicKey() {
        return this.e;
    }

    public byte[] getFingerprint() {
        this.b();
        return this.b.fingerprint();
    }

    public byte[] getFingerprint(String string) throws NoSuchAlgorithmException {
        this.b();
        MessageDigest messageDigest = null;
        if (IaikSecurity.getTryIAIKProviderFirst()) {
            try {
                messageDigest = IaikSecurity.getMessageDigestInstance(string, IAIK.getInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (messageDigest == null) {
            messageDigest = MessageDigest.getInstance(string);
        }
        messageDigest.update(this.b.toByteArray());
        return messageDigest.digest();
    }

    public byte[] getFingerprintSHA() {
        if (this.j == null) {
            try {
                this.j = this.getFingerprint("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("Algorithm SHA not available: " + noSuchAlgorithmException.toString());
            }
        }
        return this.j;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.c + "\n");
        if (this.d != null) {
            stringBuffer.append("Subject: " + this.d + "\n");
        }
        if (this.e != null) {
            stringBuffer.append(this.e.toString());
        }
        if (this.f != null) {
            stringBuffer.append("Signature algorithm: " + this.f + "\n");
        }
        stringBuffer.append("\n");
        if (this.h != null && this.h.length > 0) {
            if (bl) {
                for (int i2 = 0; i2 < this.h.length; ++i2) {
                    stringBuffer.append("Attribute " + (i2 + 1) + ": ");
                    stringBuffer.append(this.h[i2]);
                    stringBuffer.append("\n");
                }
            } else {
                stringBuffer.append("Attributes: yes\n");
            }
        }
        stringBuffer.append("Fingerprint (MD5)  : " + Util.toString(this.getFingerprint()) + "\n");
        stringBuffer.append("Fingerprint (SHA-1): " + Util.toString(this.getFingerprintSHA()) + "\n");
        return stringBuffer.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Util.toString(null, -1, 1);
    }
}

