/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CON_SPEC;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.PKCS1AlgorithmParameters;
import iaik.pkcs.pkcs1.RSAPssParameterSpec;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class RSAPssParameters
extends PKCS1AlgorithmParameters {
    private static boolean c;
    private RSAPssParameterSpec d;
    static Class a;
    static Class b;

    public static void setEncodeDefaultValues(boolean bl) {
        c = bl;
    }

    public static boolean getEncodeDefaultValues() {
        return c;
    }

    protected byte[] engineGetEncoded() throws IOException {
        return DerCoder.encode(this.toASN1Object());
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    public ASN1Object toASN1Object() {
        ASN1Object aSN1Object = super.toASN1Object();
        if (aSN1Object == null) {
            if (this.d == null) {
                throw new NullPointerException("Cannot encode null params!");
            }
            AlgorithmID algorithmID = this.d.getHashAlgorithm();
            AlgorithmID algorithmID2 = this.d.getMaskGenAlgorithm();
            int n2 = this.d.getSaltLength();
            int n3 = this.d.getTrailerField();
            Boolean bl = this.d.getEncodeDefaultValues();
            boolean bl2 = bl != null ? bl : c;
            SEQUENCE sEQUENCE = new SEQUENCE();
            if (algorithmID != null && (bl2 || !algorithmID.equals(RSAPssParameterSpec.DEFAULT_HASH_ALGORITHM))) {
                sEQUENCE.addComponent(new CON_SPEC(0, algorithmID.toASN1Object()));
            }
            if (algorithmID2 != null) {
                ASN1Object aSN1Object2 = null;
                ASN1Object aSN1Object3 = algorithmID2.getParameter();
                if (aSN1Object3 != null && aSN1Object3.isA(ASN.SEQUENCE)) {
                    try {
                        aSN1Object2 = aSN1Object3.getComponentAt(0);
                    }
                    catch (CodingException codingException) {
                        // empty catch block
                    }
                }
                if (bl2 || !algorithmID2.equals(RSAPssParameterSpec.DEFAULT_MASK_GEN_ALGORITHM) || !RSAPssParameterSpec.DEFAULT_HASH_ALGORITHM.getAlgorithm().equals(aSN1Object2)) {
                    sEQUENCE.addComponent(new CON_SPEC(1, algorithmID2.toASN1Object()));
                }
            }
            if (n2 != -1 && (bl2 || n2 != 20)) {
                sEQUENCE.addComponent(new CON_SPEC(2, new INTEGER(n2)));
            }
            if (n3 != -1 && (bl2 || n3 != RSAPssParameterSpec.DEFAULT_TRAILER_FIELD)) {
                sEQUENCE.addComponent(new CON_SPEC(3, new INTEGER(n3)));
            }
            aSN1Object = sEQUENCE;
        }
        return aSN1Object;
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        AlgorithmParameterSpec algorithmParameterSpec = null;
        if ("java.security.spec.PSSParameterSpec".equals(clazz.getName())) {
            Constructor<?> constructor;
            if (this.d == null) {
                throw new IllegalStateException("Parameters not initialized yet!");
            }
            String string = null;
            AlgorithmID algorithmID = this.d.getHashAlgorithm();
            try {
                string = algorithmID.getJcaStandardName();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                string = algorithmID.getName();
            }
            String string2 = null;
            AlgorithmParameterSpec algorithmParameterSpec2 = null;
            AlgorithmID algorithmID2 = this.d.getMaskGenAlgorithm();
            try {
                string2 = algorithmID2.getJcaStandardName();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                string2 = algorithmID2.getName();
            }
            ASN1Object aSN1Object = algorithmID2.getParameter();
            if (aSN1Object != null) {
                String string3 = string;
                try {
                    AlgorithmID algorithmID3 = new AlgorithmID(aSN1Object);
                    try {
                        string3 = algorithmID3.getJcaStandardName();
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        string3 = algorithmID3.getName();
                    }
                    constructor = Class.forName("java.security.spec.MGF1ParameterSpec").getConstructor(a == null ? (a = RSAPssParameters.class$("java.lang.String")) : a);
                    algorithmParameterSpec2 = (AlgorithmParameterSpec)constructor.newInstance(string3);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            int n2 = this.d.getSaltLength();
            int n3 = this.d.getTrailerField();
            try {
                constructor = Class.forName("java.security.spec.PSSParameterSpec").getConstructor(a == null ? (a = RSAPssParameters.class$("java.lang.String")) : a, a == null ? (a = RSAPssParameters.class$("java.lang.String")) : a, b == null ? (b = RSAPssParameters.class$("java.security.spec.AlgorithmParameterSpec")) : b, Integer.TYPE, Integer.TYPE);
                algorithmParameterSpec = (AlgorithmParameterSpec)constructor.newInstance(string, string2, algorithmParameterSpec2, new Integer(n2), new Integer(n3));
            }
            catch (Exception exception) {
                throw new InvalidParameterSpecException(exception.toString());
            }
        }
        if (!this.d.getClass().isAssignableFrom(clazz)) {
            try {
                Class<?> clazz2 = Class.forName("iaik.pkcs.pkcs1.PKCS1AlgorithmParameterSpec");
                if (!clazz.isAssignableFrom(clazz2)) {
                    throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
            }
        }
        algorithmParameterSpec = (RSAPssParameterSpec)this.d.clone();
        return algorithmParameterSpec;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        super.engineInit(algorithmParameterSpec);
        this.d = null;
        if (algorithmParameterSpec instanceof RSAPssParameterSpec) {
            this.d = (RSAPssParameterSpec)((RSAPssParameterSpec)algorithmParameterSpec).clone();
        } else if ("java.security.spec.PSSParameterSpec".equals(algorithmParameterSpec.getClass().getName())) {
            try {
                this.d = new RSAPssParameterSpec(algorithmParameterSpec);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidParameterSpecException(invalidAlgorithmParameterException.getMessage());
            }
        } else {
            throw new InvalidParameterSpecException("Parameter must be a RSAPssParameterSpec.");
        }
    }

    protected void engineInit(byte[] byArray) throws IOException {
        super.engineInit(byArray);
        try {
            this.decode(DerCoder.decode(byArray));
        }
        catch (CodingException codingException) {
            throw new IOException("Parsing error: " + codingException.toString());
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.d = null;
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new CodingException("Invalid PSS parameter encoding. Expected ASN.1 SEQUENCE!");
        }
        AlgorithmID algorithmID = null;
        AlgorithmID algorithmID2 = null;
        int n2 = 20;
        int n3 = RSAPssParameterSpec.DEFAULT_TRAILER_FIELD;
        block6: for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
            CON_SPEC cON_SPEC = (CON_SPEC)aSN1Object.getComponentAt(i2);
            int n4 = cON_SPEC.getAsnType().getTag();
            switch (n4) {
                case 0: {
                    algorithmID = new AlgorithmID((ASN1Object)cON_SPEC.getValue());
                    continue block6;
                }
                case 1: {
                    algorithmID2 = new AlgorithmID((ASN1Object)cON_SPEC.getValue());
                    continue block6;
                }
                case 2: {
                    n2 = ((BigInteger)((INTEGER)cON_SPEC.getValue()).getValue()).intValue();
                    continue block6;
                }
                case 3: {
                    n3 = ((BigInteger)((INTEGER)cON_SPEC.getValue()).getValue()).intValue();
                    continue block6;
                }
                default: {
                    throw new CodingException("Invalid tagged (" + n4 + ") in PSS parameter component number " + i2 + ".");
                }
            }
        }
        if (algorithmID == null) {
            algorithmID = RSAPssParameterSpec.DEFAULT_HASH_ALGORITHM;
        }
        if (algorithmID2 == null) {
            algorithmID2 = RSAPssParameterSpec.DEFAULT_MASK_GEN_ALGORITHM;
        }
        this.d = new RSAPssParameterSpec(algorithmID, algorithmID2, n2);
        this.d.setTrailerField(n3);
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        if (this.d == null) {
            return "";
        }
        return this.d.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

