/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.MGF1;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.pkcs.pkcs1.RSAPssSaltParameterSpec;
import iaik.security.md.SHA;
import iaik.security.provider.IAIK;
import iaik.utils.IaikSecurity;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;

public class RSAPssParameterSpec
extends RSAPssSaltParameterSpec
implements Cloneable {
    public static final AlgorithmID DEFAULT_HASH_ALGORITHM = (AlgorithmID)AlgorithmID.sha1.clone();
    public static final AlgorithmID DEFAULT_MASK_GEN_ALGORITHM = (AlgorithmID)AlgorithmID.mgf1.clone();
    public static final int DEFAULT_TRAILER_FIELD;
    private AlgorithmID a;
    private MessageDigest b;
    private AlgorithmID c;
    private MaskGenerationAlgorithm d;
    private int e;
    private Boolean f;

    static final AlgorithmID a(String string) {
        AlgorithmID algorithmID = AlgorithmID.getAlgorithmID(string);
        if (algorithmID == null && string.startsWith("SHA")) {
            int n2;
            int n3 = string.indexOf("-");
            if (n3 != -1 && n3 < (n2 = string.length())) {
                StringBuffer stringBuffer = new StringBuffer(n2 - 1);
                stringBuffer.append(string.substring(0, n3));
                stringBuffer.append(string.substring(n3 + 1));
                string = stringBuffer.toString();
            }
            algorithmID = AlgorithmID.getAlgorithmID(string);
        }
        return algorithmID;
    }

    public RSAPssParameterSpec() {
        this.a = (AlgorithmID)DEFAULT_HASH_ALGORITHM.clone();
        this.b = new SHA();
        this.c = (AlgorithmID)AlgorithmID.mgf1.clone();
        this.c.setParameter(this.a.toASN1Object());
        this.d = new MGF1(this.c, this.b);
        this.e = DEFAULT_TRAILER_FIELD;
    }

    public RSAPssParameterSpec(AlgorithmID algorithmID, AlgorithmID algorithmID2, int n2) {
        super(n2);
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create RSAPssParameterSpec. Missing hashAlgorithm id!");
        }
        this.a = algorithmID;
        if (algorithmID2 == null) {
            throw new IllegalArgumentException("Cannot create RSAPssParameterSpec. Missing maskGenAlgorithm id!");
        }
        this.c = algorithmID2;
        this.e = DEFAULT_TRAILER_FIELD;
    }

    public RSAPssParameterSpec(AlgorithmID algorithmID, AlgorithmID algorithmID2, byte[] byArray) {
        super(byArray);
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create RSAPssParameterSpec. Missing hashAlgorithm id!");
        }
        this.a = algorithmID;
        if (algorithmID2 == null) {
            throw new IllegalArgumentException("Cannot create RSAPssParameterSpec. Missing maskGenAlgorithm id!");
        }
        this.c = algorithmID2;
        this.e = DEFAULT_TRAILER_FIELD;
    }

    public RSAPssParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof RSAPssParameterSpec) {
            RSAPssParameterSpec rSAPssParameterSpec = (RSAPssParameterSpec)algorithmParameterSpec;
            this.saltLength_ = rSAPssParameterSpec.getSaltLength();
            this.salt_ = rSAPssParameterSpec.getSalt();
            this.a = rSAPssParameterSpec.getHashAlgorithm();
            this.c = rSAPssParameterSpec.getMaskGenAlgorithm();
            this.e = rSAPssParameterSpec.getTrailerField();
        } else {
            Class<?> clazz = algorithmParameterSpec.getClass();
            if ("java.security.spec.PSSParameterSpec".equals(clazz.getName())) {
                Object object;
                GenericDeclaration genericDeclaration;
                block25: {
                    Object object2;
                    Object object3;
                    Object object4;
                    String string = null;
                    try {
                        object4 = clazz.getDeclaredMethod("getDigestAlgorithm", new Class[0]);
                        string = (String)((Method)object4).invoke((Object)algorithmParameterSpec, null);
                        if (string != null && (object3 = RSAPssParameterSpec.a(string)) != null) {
                            this.a = object3;
                            try {
                                this.b = this.getHashEngine();
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
                        }
                    }
                    catch (Exception exception) {
                        throw new InvalidAlgorithmParameterException(exception.toString());
                    }
                    object4 = null;
                    try {
                        object3 = clazz.getDeclaredMethod("getMGFAlgorithm", new Class[0]);
                        object4 = (String)((Method)object3).invoke((Object)algorithmParameterSpec, null);
                        if (object4 != null && (object2 = AlgorithmID.getAlgorithmID((String)object4)) != null) {
                            this.c = object2;
                        }
                    }
                    catch (Exception exception) {
                        throw new InvalidAlgorithmParameterException(exception.toString());
                    }
                    object3 = null;
                    try {
                        object2 = clazz.getDeclaredMethod("getMGFParameters", new Class[0]);
                        object3 = (AlgorithmParameterSpec)((Method)object2).invoke((Object)algorithmParameterSpec, null);
                        if (object3 == null) break block25;
                        genericDeclaration = object3.getClass();
                        if ("MGF1".equals(object4) && "java.security.spec.MGF1ParameterSpec".equals(((Class)genericDeclaration).getName())) {
                            object = null;
                            String string2 = null;
                            try {
                                object2 = ((Class)genericDeclaration).getDeclaredMethod("getDigestAlgorithm", new Class[0]);
                                string2 = (String)((Method)object2).invoke(object3, null);
                                object = string2.equals(string) ? (AlgorithmID)this.a.clone() : RSAPssParameterSpec.a(string2);
                                if (object != null) {
                                    this.c.setParameter(((AlgorithmID)object).toASN1Object());
                                    try {
                                        MessageDigest messageDigest = ((AlgorithmID)object).getMessageDigestInstance();
                                        this.d = new MGF1((AlgorithmID)object, messageDigest);
                                    }
                                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
                                }
                                break block25;
                            }
                            catch (Exception exception) {
                                throw new InvalidAlgorithmParameterException(exception.toString());
                            }
                        }
                        this.c.setAlgorithmParameterSpec((AlgorithmParameterSpec)object3);
                    }
                    catch (Exception exception) {
                        throw new InvalidAlgorithmParameterException(exception.toString());
                    }
                }
                int n2 = -1;
                try {
                    genericDeclaration = clazz.getDeclaredMethod("getSaltLength", new Class[0]);
                    n2 = (Integer)((Method)genericDeclaration).invoke(algorithmParameterSpec, null);
                    if (n2 != -1) {
                        this.saltLength_ = n2;
                    }
                }
                catch (Exception exception) {
                    throw new InvalidAlgorithmParameterException(exception.toString());
                }
                int n3 = -1;
                try {
                    object = clazz.getDeclaredMethod("getTrailerField", new Class[0]);
                    n3 = (Integer)((Method)object).invoke((Object)algorithmParameterSpec, null);
                    if (n3 != -1) {
                        this.e = n3;
                    }
                }
                catch (Exception exception) {
                    throw new InvalidAlgorithmParameterException(exception.toString());
                }
            }
        }
    }

    public void setTrailerField(int n2) {
        this.e = n2;
    }

    public int getTrailerField() {
        return this.e;
    }

    public AlgorithmID getHashAlgorithm() {
        return this.a;
    }

    public AlgorithmID getMaskGenAlgorithm() {
        return this.c;
    }

    public void setHashEngine(MessageDigest messageDigest) {
        this.b = messageDigest;
    }

    public MessageDigest getHashEngine() throws NoSuchAlgorithmException {
        if (this.b == null) {
            if (IaikSecurity.getTryIAIKProviderFirst()) {
                try {
                    this.b = this.a.getMessageDigestInstance(IAIK.getInstance());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            if (this.b == null) {
                this.b = this.a.getMessageDigestInstance();
            }
        } else {
            this.b.reset();
        }
        return this.b;
    }

    public void setMGFEngine(MaskGenerationAlgorithm maskGenerationAlgorithm) {
        this.d = maskGenerationAlgorithm;
    }

    public MaskGenerationAlgorithm getMGFEngine() throws NoSuchAlgorithmException {
        if (this.d == null) {
            if (IaikSecurity.getTryIAIKProviderFirst()) {
                try {
                    this.d = this.c.getMaskGenerationAlgorithmInstance(IAIK.getInstance());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            if (this.d == null) {
                this.d = this.c.getMaskGenerationAlgorithmInstance();
            }
            AlgorithmParameters algorithmParameters = null;
            try {
                algorithmParameters = this.c.getAlgorithmParameters(null, IAIK.getInstance());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                algorithmParameters = this.c.getAlgorithmParameters();
            }
            try {
                this.d.setParameters(algorithmParameters);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new NoSuchAlgorithmException("Cannot init MGF parameters: " + invalidAlgorithmParameterException.getMessage());
            }
        }
        return this.d;
    }

    public void setEncodeDefaultValues(Boolean bl) {
        this.f = bl;
    }

    public Boolean getEncodeDefaultValues() {
        return this.f;
    }

    public Object clone() {
        RSAPssParameterSpec rSAPssParameterSpec = null;
        try {
            rSAPssParameterSpec = (RSAPssParameterSpec)super.clone();
            rSAPssParameterSpec.a = (AlgorithmID)this.a.clone();
            rSAPssParameterSpec.c = (AlgorithmID)this.c.clone();
            rSAPssParameterSpec.saltLength_ = this.saltLength_;
            rSAPssParameterSpec.e = this.e;
            if (this.b != null) {
                rSAPssParameterSpec.b = (MessageDigest)this.b.clone();
            }
            if (this.d != null) {
                rSAPssParameterSpec.d = (MaskGenerationAlgorithm)this.d.clone();
            }
            if (this.f != null) {
                rSAPssParameterSpec.f = new Boolean(this.f);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return rSAPssParameterSpec;
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.c.hashCode() ^ this.saltLength_;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof RSAPssParameterSpec) {
            RSAPssParameterSpec rSAPssParameterSpec = (RSAPssParameterSpec)object;
            bl = super.equals(object);
            if (bl) {
                boolean bl2 = this.a.equals(rSAPssParameterSpec.a) && this.c.equals(rSAPssParameterSpec.c, true) && this.e == rSAPssParameterSpec.e;
                bl &= bl2;
            }
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Hash algorithm: " + this.a + "\n");
        stringBuffer.append("Mask generation algorithm: " + this.c + "\n");
        stringBuffer.append("Salt length: " + this.saltLength_ + "\n");
        stringBuffer.append("Trailer field: " + this.e + "\n");
        return stringBuffer.toString();
    }

    static {
        DEFAULT_MASK_GEN_ALGORITHM.setParameter(DEFAULT_HASH_ALGORITHM.toASN1Object());
        DEFAULT_TRAILER_FIELD = 1;
    }
}

