/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.MGF1;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.pkcs.pkcs1.RSAOaepPSourceParameterSpec;
import iaik.pkcs.pkcs1.RSAPssParameterSpec;
import iaik.security.md.SHA;
import iaik.security.provider.IAIK;
import iaik.utils.IaikSecurity;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;

public class RSAOaepParameterSpec
extends RSAOaepPSourceParameterSpec
implements Cloneable {
    public static final AlgorithmID DEFAULT_HASH_ALGORITHM = (AlgorithmID)AlgorithmID.sha1.clone();
    public static final AlgorithmID DEFAULT_MASK_GEN_ALGORITHM = (AlgorithmID)AlgorithmID.mgf1.clone();
    private AlgorithmID a;
    private MessageDigest b;
    private AlgorithmID c;
    private MaskGenerationAlgorithm d;
    private Boolean e;

    public RSAOaepParameterSpec() {
        this.a = (AlgorithmID)DEFAULT_HASH_ALGORITHM.clone();
        this.b = new SHA();
        this.c = (AlgorithmID)AlgorithmID.mgf1.clone();
        this.c.setParameter(this.a.toASN1Object());
        this.d = new MGF1(this.a, this.b);
    }

    public RSAOaepParameterSpec(AlgorithmID algorithmID, AlgorithmID algorithmID2, AlgorithmID algorithmID3) {
        super(algorithmID3);
        if (algorithmID == null) {
            throw new IllegalArgumentException("HashAlgorithm id must not be null!");
        }
        this.a = algorithmID;
        if (algorithmID2 == null) {
            throw new IllegalArgumentException("MaskGenAlgorithm id must no be null!");
        }
        this.c = algorithmID2;
    }

    public RSAOaepParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof RSAOaepParameterSpec) {
            RSAOaepParameterSpec rSAOaepParameterSpec = (RSAOaepParameterSpec)algorithmParameterSpec;
            this.a = rSAOaepParameterSpec.getHashAlgorithm();
            this.c = rSAOaepParameterSpec.getMaskGenAlgorithm();
            if (rSAOaepParameterSpec.b != null) {
                this.b = rSAOaepParameterSpec.b;
            }
            if (rSAOaepParameterSpec.d != null) {
                this.d = rSAOaepParameterSpec.d;
            }
        } else {
            Class<?> clazz = algorithmParameterSpec.getClass();
            if ("javax.crypto.spec.OAEPParameterSpec".equals(clazz.getName())) {
                Object object;
                String string;
                Class<?> clazz2;
                GenericDeclaration genericDeclaration;
                Object object2;
                block26: {
                    Object object3;
                    Object object4;
                    String string2 = null;
                    try {
                        object4 = clazz.getDeclaredMethod("getDigestAlgorithm", new Class[0]);
                        string2 = (String)((Method)object4).invoke((Object)algorithmParameterSpec, null);
                        if (string2 != null && (object3 = RSAPssParameterSpec.a(string2)) != null) {
                            this.a = object3;
                            try {
                                this.b = this.getHashEngine();
                            }
                            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
                        }
                    }
                    catch (Exception exception) {
                        throw new InvalidAlgorithmParameterException(exception.toString());
                    }
                    object4 = null;
                    try {
                        object3 = clazz.getDeclaredMethod("getMGFAlgorithm", new Class[0]);
                        object4 = (String)((Method)object3).invoke((Object)algorithmParameterSpec, null);
                        if (object4 != null && (object2 = AlgorithmID.getAlgorithmID((String)object4)) != null) {
                            this.c = object2;
                        }
                    }
                    catch (Exception exception) {
                        throw new InvalidAlgorithmParameterException(exception.toString());
                    }
                    object3 = null;
                    try {
                        object2 = clazz.getDeclaredMethod("getMGFParameters", new Class[0]);
                        object3 = (AlgorithmParameterSpec)((Method)object2).invoke((Object)algorithmParameterSpec, null);
                        if (object3 == null) break block26;
                        genericDeclaration = object3.getClass();
                        if ("MGF1".equals(object4) && "java.security.spec.MGF1ParameterSpec".equals(((Class)genericDeclaration).getName())) {
                            clazz2 = null;
                            string = null;
                            try {
                                object2 = ((Class)genericDeclaration).getDeclaredMethod("getDigestAlgorithm", new Class[0]);
                                string = (String)((Method)object2).invoke(object3, null);
                                clazz2 = string.equals(string2) ? (AlgorithmID)this.a.clone() : RSAPssParameterSpec.a(string);
                                if (clazz2 != null) {
                                    this.c.setParameter(((AlgorithmID)((Object)clazz2)).toASN1Object());
                                    try {
                                        object = ((AlgorithmID)((Object)clazz2)).getMessageDigestInstance();
                                        this.d = new MGF1((AlgorithmID)((Object)clazz2), (MessageDigest)object);
                                    }
                                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
                                }
                                break block26;
                            }
                            catch (Exception exception) {
                                throw new InvalidAlgorithmParameterException(exception.toString());
                            }
                        }
                        this.c.setAlgorithmParameterSpec((AlgorithmParameterSpec)object3);
                    }
                    catch (Exception exception) {
                        throw new InvalidAlgorithmParameterException(exception.toString());
                    }
                }
                object2 = null;
                try {
                    genericDeclaration = clazz.getDeclaredMethod("getPSource", new Class[0]);
                    object2 = ((Method)genericDeclaration).invoke(algorithmParameterSpec, null);
                    if (object2 != null) {
                        clazz2 = Class.forName("javax.crypto.spec.PSource");
                        genericDeclaration = clazz2.getDeclaredMethod("getAlgorithm", new Class[0]);
                        string = (String)((Method)genericDeclaration).invoke(object2, null);
                        if (!"PSpecified".equalsIgnoreCase(string)) {
                            throw new InvalidAlgorithmParameterException("Unsupported pSource algorithm: " + string);
                        }
                        object = null;
                        Class<?> clazz3 = Class.forName("javax.crypto.spec.PSource$PSpecified");
                        genericDeclaration = clazz3.getDeclaredMethod("getValue", new Class[0]);
                        object = (byte[])((Method)genericDeclaration).invoke(object2, null);
                        if (object != null) {
                            this.setLabel((byte[])object);
                        }
                    }
                }
                catch (Exception exception) {
                    throw new InvalidAlgorithmParameterException(exception.toString());
                }
            }
        }
    }

    public AlgorithmID getHashAlgorithm() {
        return this.a;
    }

    public AlgorithmID getMaskGenAlgorithm() {
        return this.c;
    }

    public void setHashEngine(MessageDigest messageDigest) {
        this.b = messageDigest;
    }

    public MessageDigest getHashEngine() throws NoSuchAlgorithmException {
        if (this.b == null) {
            if (IaikSecurity.getTryIAIKProviderFirst()) {
                try {
                    this.b = this.a.getMessageDigestInstance(IAIK.getInstance());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            if (this.b == null) {
                this.b = this.a.getMessageDigestInstance();
            }
        } else {
            this.b.reset();
        }
        return this.b;
    }

    public void setMGFEngine(MaskGenerationAlgorithm maskGenerationAlgorithm) {
        this.d = maskGenerationAlgorithm;
    }

    public MaskGenerationAlgorithm getMGFEngine() throws NoSuchAlgorithmException {
        if (this.d == null) {
            if (IaikSecurity.getTryIAIKProviderFirst()) {
                try {
                    this.d = this.c.getMaskGenerationAlgorithmInstance(IAIK.getInstance());
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    // empty catch block
                }
            }
            if (this.d == null) {
                this.d = this.c.getMaskGenerationAlgorithmInstance();
            }
            AlgorithmParameters algorithmParameters = null;
            try {
                algorithmParameters = this.c.getAlgorithmParameters(null, IAIK.getInstance());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                algorithmParameters = this.c.getAlgorithmParameters();
            }
            try {
                this.d.setParameters(algorithmParameters);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new NoSuchAlgorithmException("Cannot init MGF parameters: " + invalidAlgorithmParameterException.getMessage());
            }
        }
        return this.d;
    }

    public void setEncodeDefaultValues(Boolean bl) {
        this.e = bl;
    }

    public Boolean getEncodeDefaultValues() {
        return this.e;
    }

    public Object clone() {
        RSAOaepParameterSpec rSAOaepParameterSpec = null;
        try {
            rSAOaepParameterSpec = (RSAOaepParameterSpec)super.clone();
            rSAOaepParameterSpec.a = (AlgorithmID)this.a.clone();
            rSAOaepParameterSpec.c = (AlgorithmID)this.c.clone();
            rSAOaepParameterSpec.pSourceAlgorithm_ = (AlgorithmID)this.pSourceAlgorithm_.clone();
            if (this.b != null) {
                rSAOaepParameterSpec.b = (MessageDigest)this.b.clone();
            }
            if (this.d != null) {
                rSAOaepParameterSpec.d = (MaskGenerationAlgorithm)this.d.clone();
            }
            if (this.e != null) {
                rSAOaepParameterSpec.e = new Boolean(this.e);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return rSAOaepParameterSpec;
    }

    public int hashCode() {
        return this.a.hashCode() ^ this.c.hashCode() ^ this.pSourceAlgorithm_.hashCode();
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof RSAOaepParameterSpec) {
            RSAOaepParameterSpec rSAOaepParameterSpec = (RSAOaepParameterSpec)object;
            bl = super.equals(object) && this.a.equals(rSAOaepParameterSpec.a) && this.c.equals(rSAOaepParameterSpec.c, true) && this.pSourceAlgorithm_.equals(rSAOaepParameterSpec.pSourceAlgorithm_, true);
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Hash algorithm: " + this.a + "\n");
        stringBuffer.append("Mask generation algorithm: " + this.c + "\n");
        stringBuffer.append("PSource algorithm: " + this.pSourceAlgorithm_ + "\n");
        return stringBuffer.toString();
    }

    static {
        DEFAULT_MASK_GEN_ALGORITHM.setParameter(DEFAULT_HASH_ALGORITHM.toASN1Object());
    }
}

