/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.pkcs.pkcs1.Padding;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.NoSuchPaddingException;

public final class PKCS1v15Padding
extends Padding {
    private int a;
    private boolean b;

    PKCS1v15Padding() {
        super("PKCS1Padding");
        this.a = -1;
    }

    public PKCS1v15Padding(String string, String string2) throws NoSuchPaddingException {
        super(string);
        if (string.equalsIgnoreCase("PKCS1PaddingSSL2")) {
            this.b = true;
        }
        if (string2 == null || string2.equalsIgnoreCase("ECB") || string2.equalsIgnoreCase("SSL") || string2.equalsIgnoreCase("NONE")) {
            this.a = -1;
        } else {
            int n2;
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new NoSuchPaddingException("Bad block type (" + string2 + ") for PKCS1Padding");
            }
            if (n2 != 0 && n2 != 1 && n2 != 2) {
                throw new NoSuchPaddingException("Block type for PKCS1Padding must be 0, 1 or 2.");
            }
            this.a = n2;
        }
    }

    public void init(int n2, Key key, int n3, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        super.init(n2, key, n3, algorithmParameterSpec, secureRandom);
        if (this.opMode_ == 2 && this.b) {
            throw new InvalidAlgorithmParameterException("SSL2 variant of PKCS#1 padding not supported in decryption mode!");
        }
        if (this.a != -1) {
            if (this.opMode_ == 1) {
                if (this.a == 2) {
                    if (this.privateKey_ != null) {
                        throw new InvalidKeyException("Must use public key for encryption with block type 2!");
                    }
                } else if (this.publicKey_ != null) {
                    throw new InvalidKeyException("Must use private key for encryption with block type 0 and 1!");
                }
            } else if (this.a == 2) {
                if (this.publicKey_ != null) {
                    throw new InvalidKeyException("Must use private key for decryption with block type 2!");
                }
            } else if (this.privateKey_ != null) {
                throw new InvalidKeyException("Must use public key for decryption with block type 0 and 1!");
            }
        }
        if (this.modLen_ < 41) {
            throw new InvalidKeyException("PKCS#1 requires a modulus of at least 328 bits!");
        }
    }

    public AlgorithmParameters getParameters() {
        return null;
    }

    public byte[] pad(byte[] byArray) throws BadPaddingException {
        int n2 = byArray.length;
        int n3 = 0;
        int n4 = this.modLen_ - 3 - n2;
        if (n4 < 8) {
            throw new BadPaddingException("PKCS#1 requires data at least 11 bytes shorter than the modulus!");
        }
        int n5 = this.a;
        if (n5 == -1) {
            n5 = this.publicKey_ != null ? 2 : 1;
        }
        byte[] byArray2 = new byte[this.modLen_];
        byArray2[n3++] = 0;
        byArray2[n3++] = (byte)n5;
        if (n5 == 2) {
            SecureRandom secureRandom = this.b();
            if (secureRandom == null) {
                throw new NullPointerException("Cannot do PKCS1 padding. No SecureRandom available!");
            }
            byte[] byArray3 = new byte[1];
            for (int i2 = 0; i2 < n4; ++i2) {
                if (this.b && n4 - i2 <= 8) {
                    byArray3[0] = 3;
                } else {
                    do {
                        secureRandom.nextBytes(byArray3);
                    } while (byArray3[0] == 0);
                }
                byArray2[n3++] = byArray3[0];
            }
        } else {
            int n6;
            if (n5 == 0) {
                n6 = 0;
                if (byArray[0] == 0) {
                    throw new BadPaddingException("For block type 0 data must begin with nonzero value");
                }
            } else {
                n6 = 255;
            }
            for (int i3 = 0; i3 < n4; ++i3) {
                byArray2[n3++] = (byte)n6;
            }
        }
        byArray2[n3++] = 0;
        System.arraycopy(byArray, 0, byArray2, n3, n2);
        return byArray2;
    }

    public byte[] unpad(byte[] byArray) throws BadPaddingException {
        int n2;
        int n3;
        BadPaddingException badPaddingException = new BadPaddingException("Invalid padding!");
        int n4 = byArray.length;
        boolean bl = false;
        if (byArray[0] != 0) {
            bl = true;
        }
        int n5 = byArray[1];
        if (this.a != -1 && this.a != n5) {
            bl = true;
        }
        int n6 = n3 = 2;
        if (n5 < 0 || n5 > 2) {
            bl = true;
            int n7 = n5 = this.publicKey_ != null ? 1 : 2;
            if (n5 == 1 && byArray[n3] == 0) {
                n5 = 0;
            }
        }
        switch (n5) {
            case 0: {
                int n8;
                if (this.privateKey_ != null) {
                    bl = true;
                }
                for (n8 = n3; n8 < n4; ++n8) {
                    n2 = byArray[n8] & 0xFF;
                    if (n2 != 0 && n6 == n3) {
                        n6 = n8;
                        if (n8 == n3) {
                            bl = true;
                        }
                    }
                    if (n2 == 255 || n6 != n3) continue;
                    bl = bl;
                }
                if (n6 - 2 >= 8) break;
                bl = true;
                break;
            }
            case 1: {
                int n8;
                if (this.privateKey_ != null) {
                    bl = true;
                }
                for (n8 = n3; n8 < n4; ++n8) {
                    n2 = byArray[n8] & 0xFF;
                    if (n2 == 0 && n6 == n3) {
                        n6 = n8 + 1;
                        if (n8 == n3) {
                            bl = true;
                        }
                    }
                    if (n2 == 255 || n6 != n3) continue;
                    bl = true;
                }
                if (n6 - 3 >= 8) break;
                bl = true;
                break;
            }
            default: {
                int n8;
                if (this.publicKey_ != null) {
                    bl = true;
                }
                for (n8 = n3; n8 < n4; ++n8) {
                    n2 = byArray[n8] & 0xFF;
                    if (n2 == 0 && n6 == n3) {
                        n6 = n8 + 1;
                        if (n8 == n3) {
                            bl = true;
                        }
                    }
                    if (n2 == 255 || n6 != n3) continue;
                    bl = bl;
                }
                if (n6 - 3 >= 8) break;
                bl = true;
            }
        }
        byte[] byArray2 = new byte[n6];
        System.arraycopy(byArray, 0, byArray2, 0, n6);
        n2 = n4 - n6;
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, n6, byArray3, 0, n2);
        System.arraycopy(byArray3, 0, byArray, 0, n2);
        System.arraycopy(byArray2, 0, byArray, n2, n6);
        if (bl) {
            throw badPaddingException;
        }
        return byArray3;
    }
}

