/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs1;

import iaik.asn1.ObjectID;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs1.MGF1ParameterSpec;
import iaik.pkcs.pkcs1.MaskGenerationAlgorithm;
import iaik.security.kdf.HashBasedGenerationFunction;
import iaik.security.provider.IAIK;
import iaik.utils.IaikSecurity;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class MGF1
extends MaskGenerationAlgorithm
implements Cloneable {
    public static final ObjectID OID = AlgorithmID.mgf1.getAlgorithm();
    private HashBasedGenerationFunction b;
    static Class a;

    public MGF1() {
        super("MGF1");
        this.b = new HashBasedGenerationFunction((AlgorithmID)AlgorithmID.sha1.clone(), 0);
        try {
            this.b.setHashEngine();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
    }

    public MGF1(AlgorithmID algorithmID, MessageDigest messageDigest) {
        super("MGF1");
        if (algorithmID == null) {
            throw new NullPointerException("Cannot create a MGF1 object with null hash algorithm.");
        }
        this.b = new HashBasedGenerationFunction(algorithmID, 0);
        this.b.setHashEngine(messageDigest);
    }

    protected void engineMask(byte[] byArray, int n2, int n3, int n4, byte[] byArray2, int n5) {
        try {
            this.b.setHashEngine();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new NullPointerException("No MessageDigest engine available: " + noSuchAlgorithmException.getMessage());
        }
        this.b.generateOctets(byArray, n2, n3, n4, byArray2, n5);
    }

    protected void engineSetParameters(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof MGF1ParameterSpec) {
            MGF1ParameterSpec mGF1ParameterSpec = (MGF1ParameterSpec)algorithmParameterSpec;
            this.b.setHashAlgorithm(mGF1ParameterSpec.getHashAlgorithm());
            try {
                this.b.setHashEngine(mGF1ParameterSpec.getHashEngine());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InvalidAlgorithmParameterException("No hash engine available for the requested hash algorithm: " + noSuchAlgorithmException.getMessage());
            }
        } else {
            throw new InvalidAlgorithmParameterException("Parameter must be of type MGF1ParameterSpec");
        }
    }

    protected void engineSetParameters(AlgorithmParameters algorithmParameters) throws InvalidAlgorithmParameterException {
        if (algorithmParameters != null) {
            try {
                Object t2 = algorithmParameters.getParameterSpec(a == null ? (a = MGF1.class$("iaik.pkcs.pkcs1.MGF1ParameterSpec")) : a);
                this.engineSetParameters((AlgorithmParameterSpec)t2);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new InvalidAlgorithmParameterException("Only MGF1Parameters allowed.");
            }
        }
    }

    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters algorithmParameters = null;
        AlgorithmID algorithmID = this.b.getHashAlgorithm();
        if (algorithmID != null) {
            MGF1ParameterSpec mGF1ParameterSpec = new MGF1ParameterSpec(algorithmID);
            try {
                algorithmParameters = IaikSecurity.getAlgorithmParametersInstance("MGF1", IAIK.getInstance());
                algorithmParameters.init(mGF1ParameterSpec);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return algorithmParameters;
    }

    protected void engineReset() {
        this.b.engineReset();
    }

    public ObjectID getOID() {
        return OID;
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
            this.b = (HashBasedGenerationFunction)this.b.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return object;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

