/*
 * Decompiled with CFR 0.152.
 */
package iaik.iso.iso9796;

import iaik.iso.iso9796.ISO9796P2S2S3ParameterSpec;
import iaik.security.provider.IAIK;
import iaik.utils.IaikSecurity;
import iaik.utils.PretendedMessageDigest;
import iaik.utils.Util;
import java.security.MessageDigest;

public class RawISO9796P2S2S3ParameterSpec
extends ISO9796P2S2S3ParameterSpec {
    private byte[] b;
    private int c;
    private MessageDigest d;

    public RawISO9796P2S2S3ParameterSpec(String string, int n2, byte[] byArray, int n3) {
        if (byArray == null) {
            throw new NullPointerException("Mr must not be null!");
        }
        if (n3 < 0) {
            throw new NullPointerException("msgLen must not be negative!");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Hash length must not be negative!");
        }
        this.b = (byte[])byArray.clone();
        this.c = n3;
        this.d = new PretendedMessageDigest(string, n2);
        try {
            MessageDigest messageDigest = null;
            if (IaikSecurity.getTryIAIKProviderFirst()) {
                try {
                    messageDigest = IaikSecurity.getMessageDigestInstance(string, IAIK.getInstance());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (messageDigest == null) {
                messageDigest = MessageDigest.getInstance(string);
            }
            this.setHashEngine(messageDigest, n2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] getMr() {
        return this.b;
    }

    public int getMsgLen() {
        return this.c;
    }

    MessageDigest a() {
        return this.d;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("Mr: " + Util.toString(this.b));
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

